/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.pom.Navigatable;
import com.intellij.slicer.AnalyzeLeavesAction;
import com.intellij.slicer.CanItBeNullAction;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRenderer;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DuplicateNodeRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class SlicePanel
extends JPanel
implements TypeSafeDataProvider,
Disposable {
    private final SliceTreeBuilder myBuilder;
    private final JTree myTree;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

        protected boolean isAutoScrollMode() {
            return SlicePanel.this.isAutoScroll();
        }

        protected void setAutoScrollMode(boolean state) {
            SlicePanel.this.setAutoScroll(state);
        }
    };
    private UsagePreviewPanel myUsagePreviewPanel;
    private final Project myProject;
    private boolean isDisposed;
    private final ToolWindow myToolWindow;

    public SlicePanel(final Project project, boolean dataFlowToThis, SliceNode rootNode, boolean splitByLeafExpressions, final ToolWindow toolWindow) {
        super(new BorderLayout());
        this.myToolWindow = toolWindow;
        final ToolWindowManagerListener listener = new ToolWindowManagerListener(){
            ToolWindowAnchor myAnchor;
            {
                this.myAnchor = toolWindow.getAnchor();
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SlicePanel$2.toolWindowRegistered must not be null");
                }
            }

            @Override
            public void stateChanged() {
                if (toolWindow.getAnchor() != this.myAnchor) {
                    this.myAnchor = SlicePanel.this.myToolWindow.getAnchor();
                    SlicePanel.this.layoutPanel();
                }
            }
        };
        ToolWindowManagerEx.getInstanceEx(project).addToolWindowManagerListener(listener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                ToolWindowManagerEx.getInstanceEx(project).removeToolWindowManagerListener(listener);
            }
        });
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myProject = project;
        this.myTree = this.createTree();
        this.myBuilder = new SliceTreeBuilder(this.myTree, project, dataFlowToThis, rootNode, splitByLeafExpressions);
        this.myBuilder.setCanYieldUpdate(!ApplicationManager.getApplication().isUnitTestMode());
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myBuilder.addSubtreeToUpdate((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), new Runnable(){

            @Override
            public void run() {
                if (SlicePanel.this.isDisposed || SlicePanel.this.myBuilder.isDisposed() || SlicePanel.this.myProject.isDisposed()) {
                    return;
                }
                final SliceNode rootNode = SlicePanel.this.myBuilder.getRootSliceNode();
                SlicePanel.this.myBuilder.expand(rootNode, new Runnable(){

                    @Override
                    public void run() {
                        if (SlicePanel.this.isDisposed || SlicePanel.this.myBuilder.isDisposed() || SlicePanel.this.myProject.isDisposed()) {
                            return;
                        }
                        SlicePanel.this.myBuilder.select(rootNode.myCachedChildren.get(0));
                    }
                });
                SlicePanel.this.treeSelectionChanged();
            }
        });
        this.layoutPanel();
    }

    private void layoutPanel() {
        if (this.myUsagePreviewPanel != null) {
            Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        }
        this.removeAll();
        if (this.isPreview()) {
            boolean vertical = this.myToolWindow.getAnchor() == ToolWindowAnchor.LEFT || this.myToolWindow.getAnchor() == ToolWindowAnchor.RIGHT;
            Splitter splitter = new Splitter(vertical, UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS);
            splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((JComponent)this.myTree));
            this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject);
            Disposer.register((Disposable)this, (Disposable)this.myUsagePreviewPanel);
            splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
            this.add((Component)splitter, "Center");
        } else {
            this.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myTree), "Center");
        }
        this.add((Component)this.createToolbar().getComponent(), "West");
        this.revalidate();
    }

    public void dispose() {
        if (this.myUsagePreviewPanel != null) {
            UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS = ((Splitter)this.myUsagePreviewPanel.getParent()).getProportion();
            this.myUsagePreviewPanel = null;
        }
        this.isDisposed = true;
        ToolTipManager.sharedInstance().unregisterComponent(this.myTree);
    }

    private JTree createTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Tree tree = new Tree(new DefaultTreeModel(root)){

            protected void paintComponent(Graphics g) {
                DuplicateNodeRenderer.paintDuplicateNodesBackground(g, (JTree)((Object)this));
                super.paintComponent(g);
            }
        };
        tree.setOpaque(false);
        tree.setToggleClickCount(-1);
        SliceUsageCellRenderer renderer = new SliceUsageCellRenderer();
        renderer.setOpaque(false);
        tree.setCellRenderer((TreeCellRenderer)((Object)renderer));
        UIUtil.setLineStyleAngled((JTree)tree);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setSelectionPath(new TreePath(root.getPath()));
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        TreeToolTipHandler.install((JTree)tree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)tree);
        this.myAutoScrollToSourceHandler.install((JTree)tree);
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SlicePanel.this.treeSelectionChanged();
            }
        });
        tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    List navigatables = SlicePanel.this.getNavigatables();
                    if (navigatables.isEmpty()) {
                        return;
                    }
                    for (Navigatable navigatable : navigatables) {
                        if (navigatable instanceof AbstractTreeNode && ((AbstractTreeNode)navigatable).getValue() instanceof Usage) {
                            navigatable = (Usage)((AbstractTreeNode)navigatable).getValue();
                        }
                        if (!navigatable.canNavigateToSource()) continue;
                        navigatable.navigate(false);
                        if (!(navigatable instanceof Usage)) continue;
                        ((Usage)navigatable).highlightInEditor();
                    }
                    e.consume();
                }
            }
        });
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                SliceNode node = SlicePanel.fromPath(path);
                node.calculateDupNode();
            }
        });
        return tree;
    }

    private void treeSelectionChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SlicePanel.this.isDisposed) {
                    return;
                }
                List infos = SlicePanel.this.getSelectedUsageInfos();
                if (infos != null && SlicePanel.this.myUsagePreviewPanel != null) {
                    SlicePanel.this.myUsagePreviewPanel.updateLayout(infos);
                }
            }
        });
    }

    private static SliceNode fromPath(TreePath path) {
        DefaultMutableTreeNode node;
        Object userObject;
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)lastPathComponent).getUserObject()) instanceof SliceNode) {
            return (SliceNode)userObject;
        }
        return null;
    }

    private List<UsageInfo> getSelectedUsageInfos() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (TreePath path : paths) {
            SliceNode sliceNode = SlicePanel.fromPath(path);
            if (sliceNode == null) continue;
            result.add(((SliceUsage)((Object)sliceNode.getValue())).getUsageInfo());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public void calcData(DataKey key, DataSink sink) {
        List<Navigatable> navigatables;
        if (key == PlatformDataKeys.NAVIGATABLE_ARRAY && !(navigatables = this.getNavigatables()).isEmpty()) {
            sink.put(PlatformDataKeys.NAVIGATABLE_ARRAY, (Object)navigatables.toArray(new Navigatable[navigatables.size()]));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<Navigatable> getNavigatables() {
        List<Navigatable> list;
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SlicePanel.getNavigatables must not return null");
            return list;
        }
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (TreePath path : paths) {
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
            Object userObject = node.getUserObject();
            if (userObject instanceof Navigatable) {
                navigatables.add((Navigatable)userObject);
                continue;
            }
            if (!(node instanceof Navigatable)) continue;
            navigatables.add((Navigatable)node);
        }
        list = navigatables;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/slicer/SlicePanel.getNavigatables must not return null");
    }

    private ActionToolbar createToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new MyRefreshAction(this.myTree));
        actionGroup.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        actionGroup.add((AnAction)new CloseAction());
        actionGroup.add((AnAction)new ToggleAction(UsageViewBundle.message((String)"preview.usages.action.text", (Object[])new Object[0]), "preview", IconLoader.getIcon((String)"/actions/preview.png")){

            public boolean isSelected(AnActionEvent e) {
                return SlicePanel.this.isPreview();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SlicePanel.this.setPreview(state);
                SlicePanel.this.layoutPanel();
            }
        });
        if (this.myBuilder.dataFlowToThis) {
            actionGroup.add((AnAction)new AnalyzeLeavesAction(this.myBuilder));
            actionGroup.add((AnAction)new CanItBeNullAction(this.myBuilder));
        }
        return ActionManager.getInstance().createActionToolbar("TypeHierarchyViewToolbar", (ActionGroup)actionGroup, false);
    }

    public abstract boolean isAutoScroll();

    public abstract void setAutoScroll(boolean var1);

    public abstract boolean isPreview();

    public abstract void setPreview(boolean var1);

    protected abstract void close();

    public SliceTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    private final class MyRefreshAction
    extends RefreshAction {
        private MyRefreshAction(JComponent tree) {
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/sync.png"));
            this.registerShortcutOn(tree);
        }

        @Override
        public final void actionPerformed(AnActionEvent e) {
            SliceNode rootNode = (SliceNode)SlicePanel.this.myBuilder.getRootNode().getUserObject();
            rootNode.setChanged();
            SlicePanel.this.myBuilder.addSubtreeToUpdate(SlicePanel.this.myBuilder.getRootNode());
        }

        public final void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(true);
        }
    }

    private class CloseAction
    extends CloseTabToolbarAction {
        private CloseAction() {
        }

        public final void actionPerformed(AnActionEvent e) {
            SlicePanel.this.close();
        }
    }
}

