/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.wrapreturnvalue.WrapReturnValueProcessor;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

class WrapReturnValueDialog
extends RefactoringDialog {
    private final PsiMethod sourceMethod;
    private JTextField sourceMethodTextField;
    private JRadioButton createNewClassButton;
    private JTextField classNameField;
    private PackageNameReferenceEditorCombo packageTextField;
    private JPanel myNewClassPanel;
    private ReferenceEditorComboWithBrowseButton existingClassField;
    private JRadioButton useExistingClassButton;
    private JComboBox myFieldsCombo;
    private JPanel myExistingClassPanel;
    private JPanel myWholePanel;
    private JRadioButton myCreateInnerClassButton;
    private JTextField myInnerClassNameTextField;
    private JPanel myCreateInnerPanel;
    private static final String RECENT_KEYS = "WrapReturnValue.RECENT_KEYS";

    WrapReturnValueDialog(PsiMethod sourceMethod) {
        super(sourceMethod.getProject(), true);
        this.sourceMethod = sourceMethod;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(RefactorJBundle.message("wrap.return.value.title", objectArray));
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.WrapReturnValue";
    }

    @Override
    protected void doAction() {
        String packageName;
        String className;
        boolean useExistingClass = this.useExistingClassButton.isSelected();
        boolean createInnerClass = this.myCreateInnerClassButton.isSelected();
        String existingClassName = this.existingClassField.getText().trim();
        if (useExistingClass) {
            className = StringUtil.getShortName((String)existingClassName);
            packageName = StringUtil.getPackageName((String)existingClassName);
        } else if (createInnerClass) {
            className = this.getInnerClassName();
            packageName = "";
        } else {
            className = this.getClassName();
            packageName = this.getPackageName();
        }
        this.invokeRefactoring(new WrapReturnValueProcessor(className, packageName, this.sourceMethod, useExistingClass, createInnerClass, (PsiField)this.myFieldsCombo.getSelectedItem()));
    }

    @Override
    protected void canRun() throws ConfigurationException {
        Project project = this.sourceMethod.getProject();
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)project);
        PsiNameHelper nameHelper = manager.getNameHelper();
        if (this.myCreateInnerClassButton.isSelected()) {
            String innerClassName = this.getInnerClassName().trim();
            if (!nameHelper.isIdentifier(innerClassName)) {
                throw new ConfigurationException("'" + StringUtil.first((String)innerClassName, (int)10, (boolean)true) + "' is invalid inner class name");
            }
            if (this.sourceMethod.getContainingClass().findInnerClassByName(innerClassName, false) != null) {
                throw new ConfigurationException("Inner class with name '" + StringUtil.first((String)innerClassName, (int)10, (boolean)true) + "' already exist");
            }
        } else if (this.useExistingClassButton.isSelected()) {
            String className = this.existingClassField.getText().trim();
            if (className.length() == 0 || !nameHelper.isQualifiedName(className)) {
                throw new ConfigurationException("'" + StringUtil.last((CharSequence)className, (int)10, (boolean)true) + "' is invalid qualified wrapper class name");
            }
            Object item = this.myFieldsCombo.getSelectedItem();
            if (item == null) {
                throw new ConfigurationException("Wrapper field not found");
            }
        } else {
            String className = this.getClassName();
            if (className.length() == 0 || !nameHelper.isIdentifier(className)) {
                throw new ConfigurationException("'" + StringUtil.first((String)className, (int)10, (boolean)true) + "' is invalid wrapper class name");
            }
            String packageName = this.getPackageName();
            if (packageName.length() == 0 || !nameHelper.isQualifiedName(packageName)) {
                throw new ConfigurationException("'" + StringUtil.last((CharSequence)packageName, (int)10, (boolean)true) + "' is invalid wrapper class package name");
            }
        }
    }

    private String getInnerClassName() {
        return this.myInnerClassNameTextField.getText().trim();
    }

    @NotNull
    public String getPackageName() {
        String string = this.packageTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/wrapreturnvalue/WrapReturnValueDialog.getPackageName must not return null");
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.classNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/wrapreturnvalue/WrapReturnValueDialog.getClassName must not return null");
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        PsiClass containingClass;
        this.sourceMethodTextField.setEditable(false);
        com.intellij.ui.DocumentAdapter docListener = new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                WrapReturnValueDialog.this.validateButtons();
            }
        };
        this.classNameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        this.myFieldsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WrapReturnValueDialog.this.validateButtons();
            }
        });
        this.myInnerClassNameTextField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        PsiFile file = this.sourceMethod.getContainingFile();
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            this.packageTextField.setText(packageName);
        }
        String containingClassName = (containingClass = this.sourceMethod.getContainingClass()) instanceof PsiAnonymousClass ? "Anonymous " + ((PsiAnonymousClass)containingClass).getBaseClassType().getClassName() : containingClass.getName();
        String sourceMethodName = this.sourceMethod.getName();
        this.sourceMethodTextField.setText(containingClassName + '.' + sourceMethodName);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useExistingClassButton);
        buttonGroup.add(this.createNewClassButton);
        buttonGroup.add(this.myCreateInnerClassButton);
        this.createNewClassButton.setSelected(true);
        ActionListener enableListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WrapReturnValueDialog.this.toggleRadioEnablement();
            }
        };
        this.useExistingClassButton.addActionListener(enableListener);
        this.createNewClassButton.addActionListener(enableListener);
        this.myCreateInnerClassButton.addActionListener(enableListener);
        this.toggleRadioEnablement();
        final DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.myFieldsCombo.setModel(model);
        this.myFieldsCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof PsiField) {
                    PsiField field = (PsiField)value;
                    this.setText(field.getName());
                    this.setIcon(field.getIcon(1));
                }
                return rendererComponent;
            }
        });
        ((EditorComboBox)this.existingClassField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                PsiClass currentClass = JavaPsiFacade.getInstance((Project)WrapReturnValueDialog.this.myProject).findClass(WrapReturnValueDialog.this.existingClassField.getText(), GlobalSearchScope.allScope((Project)WrapReturnValueDialog.this.myProject));
                if (currentClass != null) {
                    model.removeAllElements();
                    for (PsiField field : currentClass.getFields()) {
                        PsiType returnType = WrapReturnValueDialog.this.sourceMethod.getReturnType();
                        assert (returnType != null);
                        if (!TypeConversionUtil.isAssignable((PsiType)field.getType(), (PsiType)returnType)) continue;
                        model.addElement(field);
                    }
                }
            }
        });
        return this.myWholePanel;
    }

    private void toggleRadioEnablement() {
        UIUtil.setEnabled((Component)this.myExistingClassPanel, (boolean)this.useExistingClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myNewClassPanel, (boolean)this.createNewClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myCreateInnerPanel, (boolean)this.myCreateInnerClassButton.isSelected(), (boolean)true);
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        if (this.useExistingClassButton.isSelected()) {
            focusManager.requestFocus((Component)((Object)this.existingClassField), true);
        } else if (this.myCreateInnerClassButton.isSelected()) {
            focusManager.requestFocus((Component)this.myInnerClassNameTextField, true);
        } else {
            focusManager.requestFocus((Component)this.classNameField, true);
        }
        this.validateButtons();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classNameField;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactorj.wrapReturnValue");
    }

    private void createUIComponents() {
        DocumentAdapter adapter = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                WrapReturnValueDialog.this.validateButtons();
            }
        };
        this.packageTextField = new PackageNameReferenceEditorCombo("", this.myProject, RECENT_KEYS, RefactoringBundle.message((String)"choose.destination.package"));
        ((EditorComboBox)this.packageTextField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)adapter);
        this.existingClassField = new ReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)WrapReturnValueDialog.this.getProject()).createWithInnerClassesScopeChooser(RefactorJBundle.message("select.wrapper.class", new Object[0]), GlobalSearchScope.allScope((Project)WrapReturnValueDialog.this.myProject), null, null);
                String classText = WrapReturnValueDialog.this.existingClassField.getText();
                PsiClass currentClass = JavaPsiFacade.getInstance((Project)WrapReturnValueDialog.this.myProject).findClass(classText, GlobalSearchScope.allScope((Project)WrapReturnValueDialog.this.myProject));
                if (currentClass != null) {
                    chooser.selectClass(currentClass);
                }
                chooser.showDialog();
                PsiClass selectedClass = chooser.getSelectedClass();
                if (selectedClass != null) {
                    WrapReturnValueDialog.this.existingClassField.setText(selectedClass.getQualifiedName());
                }
            }
        }, "", PsiManager.getInstance((Project)this.myProject), true, RECENT_KEYS);
        ((EditorComboBox)this.existingClassField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)adapter);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JTextField jTextField2;
        JComboBox jComboBox;
        JPanel jPanel2;
        JTextField jTextField3;
        JPanel jPanel3;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        this.createNewClassButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Create new class");
        jRadioButton3.setMnemonic('C');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        jPanel4.add((Component)jRadioButton3, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        jPanel4.add((Component)jPanel5, gridBagConstraints2);
        JPanel jPanel6 = new JPanel();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 8;
        gridBagConstraints3.fill = 3;
        jPanel4.add((Component)jPanel6, gridBagConstraints3);
        this.useExistingClassButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Use existing class");
        jRadioButton2.setMnemonic('U');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 6;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(15, 0, 0, 0);
        jPanel4.add((Component)jRadioButton2, gridBagConstraints4);
        this.myNewClassPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(0, 20, 0, 0);
        jPanel4.add((Component)jPanel3, gridBagConstraints5);
        JLabel jLabel = new JLabel();
        jLabel.setText("Name");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.anchor = 17;
        jPanel3.add((Component)jLabel, gridBagConstraints6);
        this.classNameField = jTextField3 = new JTextField();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.fill = 2;
        jPanel3.add((Component)jTextField3, gridBagConstraints7);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Package name");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 1;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.insets = new Insets(5, 0, 0, 0);
        jPanel3.add((Component)jLabel2, gridBagConstraints8);
        PackageNameReferenceEditorCombo packageNameReferenceEditorCombo = this.packageTextField;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 1;
        gridBagConstraints9.gridy = 1;
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.insets = new Insets(5, 0, 0, 0);
        jPanel3.add((Component)((Object)packageNameReferenceEditorCombo), gridBagConstraints9);
        this.myExistingClassPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 7;
        gridBagConstraints10.gridwidth = 2;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.fill = 1;
        gridBagConstraints10.insets = new Insets(0, 20, 0, 0);
        jPanel4.add((Component)jPanel2, gridBagConstraints10);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Name");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 0;
        gridBagConstraints11.anchor = 17;
        jPanel2.add((Component)jLabel3, gridBagConstraints11);
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.existingClassField;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.gridy = 0;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.fill = 2;
        jPanel2.add((Component)((Object)referenceEditorComboWithBrowseButton), gridBagConstraints12);
        this.myFieldsCombo = jComboBox = new JComboBox();
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.gridy = 1;
        gridBagConstraints13.anchor = 17;
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.insets = new Insets(5, 0, 0, 0);
        jPanel2.add(jComboBox, gridBagConstraints13);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Wrapper field");
        jLabel4.setDisplayedMnemonic('F');
        jLabel4.setDisplayedMnemonicIndex(8);
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.gridy = 1;
        gridBagConstraints14.anchor = 17;
        gridBagConstraints14.insets = new Insets(5, 0, 0, 0);
        jPanel2.add((Component)jLabel4, gridBagConstraints14);
        this.sourceMethodTextField = jTextField2 = new JTextField();
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 0;
        gridBagConstraints15.gridy = 1;
        gridBagConstraints15.gridwidth = 2;
        gridBagConstraints15.anchor = 17;
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.insets = new Insets(0, 5, 0, 0);
        jPanel4.add((Component)jTextField2, gridBagConstraints15);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/refactoring/RefactorJBundle").getString("method.to.wrap.returns.from.label"));
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.gridx = 0;
        gridBagConstraints16.gridy = 0;
        gridBagConstraints16.gridwidth = 2;
        gridBagConstraints16.anchor = 17;
        gridBagConstraints16.insets = new Insets(0, 5, 0, 0);
        jPanel4.add((Component)jLabel5, gridBagConstraints16);
        this.myCreateInnerClassButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Create inner class");
        jRadioButton.setMnemonic('I');
        jRadioButton.setDisplayedMnemonicIndex(7);
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.gridx = 0;
        gridBagConstraints17.gridy = 4;
        gridBagConstraints17.gridwidth = 2;
        gridBagConstraints17.anchor = 17;
        gridBagConstraints17.insets = new Insets(15, 0, 0, 0);
        jPanel4.add((Component)jRadioButton, gridBagConstraints17);
        this.myCreateInnerPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.gridy = 5;
        gridBagConstraints18.gridwidth = 2;
        gridBagConstraints18.fill = 1;
        gridBagConstraints18.insets = new Insets(0, 20, 0, 0);
        jPanel4.add((Component)jPanel, gridBagConstraints18);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Name");
        jLabel6.setDisplayedMnemonic('M');
        jLabel6.setDisplayedMnemonicIndex(2);
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.gridx = 0;
        gridBagConstraints19.gridy = 0;
        gridBagConstraints19.anchor = 17;
        jPanel.add((Component)jLabel6, gridBagConstraints19);
        this.myInnerClassNameTextField = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.gridx = 1;
        gridBagConstraints20.gridy = 0;
        gridBagConstraints20.weightx = 1.0;
        gridBagConstraints20.anchor = 17;
        gridBagConstraints20.fill = 2;
        jPanel.add((Component)jTextField, gridBagConstraints20);
        jLabel.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jComboBox);
        jLabel4.setLabelFor(jComboBox);
        jLabel6.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

