/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodDuplicatesHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"replace.method.code.duplicates.title");
    private static final Logger LOG = Logger.getInstance((String)("#" + MethodDuplicatesHandler.class.getName()));

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiCodeBlock body;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler.invoke must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        final PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (method == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"locate.caret.inside.a.method"));
            MethodDuplicatesHandler.showErrorMessage(message, project, editor);
            return;
        }
        if (method.isConstructor()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"replace.with.method.call.does.not.work.for.constructors"));
            MethodDuplicatesHandler.showErrorMessage(message, project, editor);
        }
        if ((body = method.getBody()) == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"method.does.not.have.a.body", (Object[])new Object[]{method.getName()}));
            MethodDuplicatesHandler.showErrorMessage(message, project, editor);
            return;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"method.has.an.empty.body", (Object[])new Object[]{method.getName()}));
            MethodDuplicatesHandler.showErrorMessage(message, project, editor);
            return;
        }
        final AnalysisScope scope = new AnalysisScope(file);
        final Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        final BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(RefactoringBundle.message((String)"replace.method.duplicates.scope.chooser.title", (Object[])new Object[]{REFACTORING_NAME}), RefactoringBundle.message((String)"replace.method.duplicates.scope.chooser.message"), project, scope, module != null ? module.getName() : null, false, AnalysisUIOptions.getInstance(project), element);
        dlg.show();
        if (dlg.isOK()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                    MethodDuplicatesHandler.invokeOnScope(project, method, dlg.getScope(AnalysisUIOptions.getInstance(project), scope, project, module));
                }
            }, "Locate method duplicates", true, project);
        }
    }

    public static void invokeOnScope(final Project project, final PsiMethod method, AnalysisScope scope) {
        final ArrayList<Match> duplicates = new ArrayList<Match>();
        scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitFile(PsiFile file) {
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (progressIndicator != null && progressIndicator.isCanceled()) {
                    return;
                }
                duplicates.addAll(MethodDuplicatesHandler.hasDuplicates(file, method));
            }
        });
        MethodDuplicatesHandler.replaceDuplicate(project, duplicates, method);
        Runnable nothingFoundRunnable = new Runnable(){

            @Override
            public void run() {
                if (duplicates.isEmpty()) {
                    String message = RefactoringBundle.message((String)"idea.has.not.found.any.code.that.can.be.replaced.with.method.call", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
                    Messages.showInfoMessage((Project)project, (String)message, (String)REFACTORING_NAME);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            nothingFoundRunnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(nothingFoundRunnable, ModalityState.NON_MODAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceDuplicate(final Project project, final List<Match> duplicates, final PsiMethod method) {
        LocalHistoryAction a = LocalHistory.startAction((Project)project, (String)REFACTORING_NAME);
        try {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null && progressIndicator.isCanceled()) {
                return;
            }
            Runnable replaceRunnable = new Runnable(){

                @Override
                public void run() {
                    int duplicatesNo = duplicates.size();
                    WindowManager.getInstance().getStatusBar(project).setInfo(MethodDuplicatesHandler.getStatusMessage(duplicatesNo));
                    CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Runnable(){

                                @Override
                                public void run() {
                                    DuplicatesImpl.invoke(project, new MethodDuplicatesMatchProvider(method, duplicates));
                                }
                            });
                        }
                    }, REFACTORING_NAME, (Object)REFACTORING_NAME);
                    WindowManager.getInstance().getStatusBar(project).setInfo("");
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                replaceRunnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(replaceRunnable, ModalityState.NON_MODAL);
            }
        }
        finally {
            a.finish();
        }
    }

    public static List<Match> hasDuplicates(PsiFile file, PsiMethod method) {
        PsiStatement[] statements;
        PsiCodeBlock body = method.getBody();
        LOG.assertTrue(body != null);
        PsiStatement[] pattern = statements = body.getStatements();
        VariableReturnValue matchedReturnValue = null;
        if (statements.length != 1 || !(statements[0] instanceof PsiReturnStatement)) {
            PsiElement resolved;
            PsiExpression returnValue;
            PsiStatement lastStatement = statements[statements.length - 1];
            if (lastStatement instanceof PsiReturnStatement && (returnValue = ((PsiReturnStatement)lastStatement).getReturnValue()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiVariable) {
                pattern = new PsiElement[statements.length - 1];
                System.arraycopy(statements, 0, pattern, 0, statements.length - 1);
                matchedReturnValue = new VariableReturnValue((PsiVariable)resolved);
            }
        } else {
            PsiExpression returnValue = ((PsiReturnStatement)statements[0]).getReturnValue();
            if (returnValue != null) {
                pattern = new PsiElement[]{returnValue};
            }
        }
        DuplicatesFinder duplicatesFinder = new DuplicatesFinder((PsiElement[])pattern, new InputVariables(Arrays.asList(method.getParameterList().getParameters()), method.getProject(), new LocalSearchScope((PsiElement[])pattern), false), matchedReturnValue, new ArrayList());
        return duplicatesFinder.findDuplicates((PsiElement)file);
    }

    static String getStatusMessage(int duplicatesNo) {
        return RefactoringBundle.message((String)"method.duplicates.found.message", (Object[])new Object[]{duplicatesNo});
    }

    private static void showErrorMessage(String message, Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceMethodCodeDuplicates");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler.invoke must not be null");
        }
        throw new UnsupportedOperationException();
    }

    private static class MethodDuplicatesMatchProvider
    implements MatchProvider {
        private final PsiMethod myMethod;
        private final List<Match> myDuplicates;

        private MethodDuplicatesMatchProvider(PsiMethod method, List<Match> duplicates) {
            this.myMethod = method;
            this.myDuplicates = duplicates;
        }

        @Override
        public PsiElement processMatch(Match match) throws IncorrectOperationException {
            PsiElement var;
            PsiExpression value;
            PsiParameter[] parameters;
            match.changeSignature(this.myMethod);
            PsiClass containingClass = this.myMethod.getContainingClass();
            if (this.isEssentialStaticContextAbsent(match)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)this.myMethod, (String)"static", (boolean)true);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
            boolean needQualifier = match.getInstanceExpression() != null;
            boolean needStaticQualifier = this.isExternal(match);
            String text = needQualifier || needStaticQualifier ? "q." + this.myMethod.getName() + "()" : this.myMethod.getName() + "()";
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)factory.createExpressionFromText(text, null);
            methodCallExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((PsiManager)this.myMethod.getManager()).reformat((PsiElement)methodCallExpression);
            for (PsiParameter parameter : parameters = this.myMethod.getParameterList().getParameters()) {
                List<PsiElement> parameterValue = match.getParameterValues((PsiVariable)parameter);
                if (parameterValue != null) {
                    for (PsiElement val : parameterValue) {
                        methodCallExpression.getArgumentList().add(val);
                    }
                    continue;
                }
                methodCallExpression.getArgumentList().add((PsiElement)factory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)parameter.getType()), (PsiElement)parameter));
            }
            if (needQualifier || needStaticQualifier) {
                PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
                LOG.assertTrue(qualifierExpression != null);
                if (needQualifier) {
                    qualifierExpression.replace((PsiElement)match.getInstanceExpression());
                } else {
                    qualifierExpression.replace((PsiElement)factory.createReferenceExpression(containingClass));
                }
            }
            VisibilityUtil.escalateVisibility((PsiMember)this.myMethod, (PsiElement)match.getMatchStart());
            PsiCodeBlock body = this.myMethod.getBody();
            assert (body != null);
            PsiStatement[] statements = body.getStatements();
            if (statements[statements.length - 1] instanceof PsiReturnStatement && (value = ((PsiReturnStatement)statements[statements.length - 1]).getReturnValue()) instanceof PsiReferenceExpression && (var = ((PsiReferenceExpression)value).resolve()) instanceof PsiVariable) {
                match.replace(this.myMethod, methodCallExpression, (PsiVariable)var);
                return methodCallExpression;
            }
            return match.replace(this.myMethod, methodCallExpression, null);
        }

        private boolean isExternal(Match match) {
            if (PsiTreeUtil.isAncestor((PsiElement)this.myMethod.getContainingClass(), (PsiElement)match.getMatchStart(), (boolean)false)) {
                return false;
            }
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)match.getMatchStart(), PsiClass.class);
            return psiClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)this.myMethod.getContainingClass(), (boolean)true);
        }

        private boolean isEssentialStaticContextAbsent(Match match) {
            if (!this.myMethod.hasModifierProperty("static")) {
                PsiExpression instanceExpression = match.getInstanceExpression();
                if (instanceExpression != null) {
                    return false;
                }
                if (this.isExternal(match)) {
                    return true;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)this.myMethod.getContainingClass(), (PsiElement)match.getMatchStart(), (boolean)false) && RefactoringUtil.isInStaticContext(match.getMatchStart(), this.myMethod.getContainingClass())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public List<Match> getDuplicates() {
            return this.myDuplicates;
        }

        @Override
        public boolean hasDuplicates() {
            return this.myDuplicates.isEmpty();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public String getConfirmDuplicatePrompt(Match match) {
            boolean needToEscalateVisibility;
            String string;
            PsiElement matchStart = match.getMatchStart();
            String visibility = VisibilityUtil.getPossibleVisibility((PsiMember)this.myMethod, (PsiElement)matchStart);
            boolean shouldBeStatic = this.isEssentialStaticContextAbsent(match);
            String signature = match.getChangedSignature(this.myMethod, this.myMethod.hasModifierProperty("static") || shouldBeStatic, visibility);
            if (signature != null) {
                string = RefactoringBundle.message((String)"replace.this.code.fragment.and.change.signature", (Object[])new Object[]{signature});
                if (string == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler$MethodDuplicatesMatchProvider.getConfirmDuplicatePrompt must not return null");
                return string;
            }
            boolean bl = needToEscalateVisibility = !PsiUtil.isAccessible((PsiMember)this.myMethod, (PsiElement)matchStart, null);
            if (needToEscalateVisibility) {
                String visibilityPresentation = VisibilityUtil.toPresentableText((String)visibility);
                string = shouldBeStatic ? RefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.static.visible", (Object[])new Object[]{visibilityPresentation}) : RefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.visible", (Object[])new Object[]{visibilityPresentation});
                if (string == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler$MethodDuplicatesMatchProvider.getConfirmDuplicatePrompt must not return null");
                return string;
            }
            if (shouldBeStatic) {
                string = RefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.static");
                if (string == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler$MethodDuplicatesMatchProvider.getConfirmDuplicatePrompt must not return null");
                return string;
            }
            string = RefactoringBundle.message((String)"replace.this.code.fragment");
            if (string != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler$MethodDuplicatesMatchProvider.getConfirmDuplicatePrompt must not return null");
        }
    }
}

