/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FieldConflictsResolver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.FieldConflictsResolver");
    private final PsiCodeBlock myScope;
    private final PsiField myField;
    private final List<PsiReferenceExpression> myReferenceExpressions;
    private PsiClass myQualifyingClass;

    public FieldConflictsResolver(String name, PsiCodeBlock scope) {
        this.myScope = scope;
        if (this.myScope == null) {
            this.myField = null;
            this.myReferenceExpressions = null;
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myScope.getProject());
        PsiVariable oldVariable = facade.getResolveHelper().resolveReferencedVariable(name, (PsiElement)this.myScope);
        PsiField psiField = this.myField = oldVariable instanceof PsiField ? (PsiField)oldVariable : null;
        if (!(oldVariable instanceof PsiField)) {
            this.myReferenceExpressions = null;
            return;
        }
        this.myReferenceExpressions = new ArrayList<PsiReferenceExpression>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myField, (SearchScope)new LocalSearchScope((PsiElement)this.myScope), (boolean)false)) {
            PsiReferenceExpression referenceExpression;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || (referenceExpression = (PsiReferenceExpression)element).getQualifierExpression() != null) continue;
            this.myReferenceExpressions.add(referenceExpression);
        }
        if (this.myField.hasModifierProperty("static")) {
            this.myQualifyingClass = this.myField.getContainingClass();
        }
    }

    public PsiExpression fixInitializer(PsiExpression initializer) {
        if (this.myField == null) {
            return initializer;
        }
        final PsiReferenceExpression[] replacedRef = new PsiReferenceExpression[]{null};
        initializer.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiExpression qualifierExpression = expression.getQualifierExpression();
                if (qualifierExpression != null) {
                    qualifierExpression.accept((PsiElementVisitor)this);
                } else {
                    PsiElement result = expression.resolve();
                    if (expression.getManager().areElementsEquivalent(result, (PsiElement)FieldConflictsResolver.this.myField)) {
                        try {
                            replacedRef[0] = FieldConflictsResolver.qualifyReference(expression, (PsiMember)FieldConflictsResolver.this.myField, FieldConflictsResolver.this.myQualifyingClass);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        });
        if (!initializer.isValid()) {
            return replacedRef[0];
        }
        return initializer;
    }

    public void fix() throws IncorrectOperationException {
        if (this.myField == null) {
            return;
        }
        PsiManager manager = this.myScope.getManager();
        for (PsiReferenceExpression referenceExpression : this.myReferenceExpressions) {
            PsiElement newlyResolved;
            if (!referenceExpression.isValid() || manager.areElementsEquivalent(newlyResolved = referenceExpression.resolve(), (PsiElement)this.myField)) continue;
            FieldConflictsResolver.qualifyReference(referenceExpression, (PsiMember)this.myField, this.myQualifyingClass);
        }
    }

    public static PsiReferenceExpression qualifyReference(PsiReferenceExpression referenceExpression, PsiMember member, @Nullable PsiClass qualifyingClass) throws IncorrectOperationException {
        PsiReferenceExpression expressionFromText;
        PsiManager manager = referenceExpression.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        if (qualifyingClass == null) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            PsiClass containingClass = member.getContainingClass();
            if (parentClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true)) {
                while (parentClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true)) {
                    parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true);
                }
                LOG.assertTrue(parentClass != null);
                expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("A.this." + member.getName(), null);
                ((PsiThisExpression)expressionFromText.getQualifierExpression()).getQualifier().replace((PsiElement)factory.createClassReferenceElement(parentClass));
            } else {
                expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("this." + member.getName(), null);
            }
        } else {
            expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("A." + member.getName(), null);
            expressionFromText.setQualifierExpression((PsiExpression)factory.createReferenceExpression(qualifyingClass));
        }
        CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
        expressionFromText = (PsiReferenceExpression)codeStyleManager.reformat((PsiElement)expressionFromText);
        return (PsiReferenceExpression)referenceExpression.replace((PsiElement)expressionFromText);
    }
}

