/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class UnsafeUsagesDialog
extends DialogWrapper {
    private JEditorPane myMessagePane;
    private final String[] myConflictDescriptions;
    public static final int VIEW_USAGES_EXIT_CODE = 2;

    public UnsafeUsagesDialog(String[] conflictDescriptions, Project project) {
        super(project, true);
        this.myConflictDescriptions = conflictDescriptions;
        this.setTitle(RefactoringBundle.message((String)"usages.detected"));
        this.setOKButtonText(RefactoringBundle.message((String)"ignore.button"));
        this.getOKAction().putValue("MnemonicKey", new Integer(73));
        this.init();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), new ViewUsagesAction(), new CancelAction()};
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String contentType = "text/html";
        this.myMessagePane = new JEditorPane("text/html", "");
        this.myMessagePane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.myMessagePane);
        scrollPane.setPreferredSize(new Dimension(500, 400));
        panel.add((Component)new JLabel(RefactoringBundle.message((String)"the.following.problems.were.found")), "North");
        panel.add((Component)scrollPane, "Center");
        StringBuffer buf = new StringBuffer();
        for (String description : this.myConflictDescriptions) {
            buf.append(description);
            buf.append("<br><br>");
        }
        this.myMessagePane.setText(buf.toString());
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.safeDelete.UnsafeUsagesDialog";
    }

    private class ViewUsagesAction
    extends AbstractAction {
        public ViewUsagesAction() {
            super(RefactoringBundle.message((String)"view.usages"));
            this.putValue("MnemonicKey", new Integer(86));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UnsafeUsagesDialog.this.close(2);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(RefactoringBundle.message((String)"cancel.button"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UnsafeUsagesDialog.this.doCancelAction();
        }
    }
}

