/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;

public class InheritorRenamer
extends AutomaticRenamer {
    public InheritorRenamer(PsiClass aClass, String newClassName) {
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)true).findAll()) {
            if (inheritor.getName() == null) continue;
            this.myElements.add(inheritor);
        }
        this.suggestAllNames(aClass.getName(), newClassName);
    }

    @Override
    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.inheritors.title");
    }

    @Override
    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.inheritors.with.the.following.names.to");
    }

    @Override
    public String entityName() {
        return RefactoringBundle.message((String)"entity.name.inheritor");
    }
}

