/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;

public class MutationUtils {
    private MutationUtils() {
    }

    public static void replaceType(String newExpression, PsiTypeElement typeElement) throws IncorrectOperationException {
        PsiManager mgr = typeElement.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)mgr.getProject()).getElementFactory();
        PsiType newType = factory.createTypeFromText(newExpression, null);
        PsiTypeElement newTypeElement = factory.createTypeElement(newType);
        PsiElement insertedElement = typeElement.replace((PsiElement)newTypeElement);
        CodeStyleManager codeStyleManager = mgr.getCodeStyleManager();
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)mgr.getProject()).shortenClassReferences(insertedElement);
        codeStyleManager.reformat(shortenedElement);
    }

    public static void replaceExpression(String newExpression, PsiExpression exp) throws IncorrectOperationException {
        PsiManager mgr = exp.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)mgr.getProject()).getElementFactory();
        PsiExpression newCall = factory.createExpressionFromText(newExpression, null);
        PsiElement insertedElement = exp.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = mgr.getCodeStyleManager();
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)mgr.getProject()).shortenClassReferences(insertedElement);
        codeStyleManager.reformat(shortenedElement);
    }

    public static void replaceExpressionIfValid(String newExpression, PsiExpression exp) throws IncorrectOperationException {
        PsiExpression newCall;
        PsiManager mgr = exp.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)mgr.getProject()).getElementFactory();
        try {
            newCall = factory.createExpressionFromText(newExpression, null);
        }
        catch (IncorrectOperationException e) {
            return;
        }
        PsiElement insertedElement = exp.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = mgr.getCodeStyleManager();
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)mgr.getProject()).shortenClassReferences(insertedElement);
        codeStyleManager.reformat(shortenedElement);
    }

    public static void replaceReference(String className, PsiJavaCodeReferenceElement reference) throws IncorrectOperationException {
        PsiManager mgr = reference.getManager();
        Project project = mgr.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)mgr.getProject()).getElementFactory();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiJavaCodeReferenceElement newReference = factory.createReferenceElementByFQClassName(className, scope);
        PsiElement insertedElement = reference.replace((PsiElement)newReference);
        CodeStyleManager codeStyleManager = mgr.getCodeStyleManager();
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)mgr.getProject()).shortenClassReferences(insertedElement);
        codeStyleManager.reformat(shortenedElement);
    }

    public static void replaceStatement(String newStatement, PsiStatement statement) throws IncorrectOperationException {
        Project project = statement.getProject();
        PsiManager mgr = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)mgr.getProject()).getElementFactory();
        PsiStatement newCall = factory.createStatementFromText(newStatement, null);
        PsiElement insertedElement = statement.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = mgr.getCodeStyleManager();
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)mgr.getProject()).shortenClassReferences(insertedElement);
        codeStyleManager.reformat(shortenedElement);
    }
}

