/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MoveFilesOrDirectoriesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor");
    private final PsiElement[] myElementsToMove;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;
    private final PsiDirectory myNewParent;
    private final MoveCallback myMoveCallback;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private Map<PsiFile, List<UsageInfo>> myFoundUsages = new HashMap<PsiFile, List<UsageInfo>>();

    public MoveFilesOrDirectoriesProcessor(Project project, PsiElement[] elements, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback, Runnable prepareSuccessfulCallback) {
        super(project, prepareSuccessfulCallback);
        this.myElementsToMove = elements;
        this.myNewParent = newParent;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new MoveFilesOrDirectoriesViewDescriptor(this.myElementsToMove, this.myNewParent);
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (int i = 0; i < this.myElementsToMove.length; ++i) {
            List<UsageInfo> usages;
            PsiElement element = this.myElementsToMove[i];
            for (PsiReference reference : ReferencesSearch.search((PsiElement)element)) {
                result.add(new MyUsageInfo(reference.getElement(), i, reference));
            }
            if (!(element instanceof PsiFile) || (usages = MoveFileHandler.forElement((PsiFile)element).findUsages((PsiFile)element, this.myNewParent, this.mySearchInComments, this.mySearchInNonJavaFiles)) == null) continue;
            result.addAll(usages);
            this.myFoundUsages.put((PsiFile)element, usages);
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(elements.length == this.myElementsToMove.length);
        System.arraycopy(elements, 0, this.myElementsToMove, 0, elements.length);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        try {
            ArrayList<PsiFile> movedFiles = new ArrayList<PsiFile>();
            HashMap<PsiElement, PsiElement> oldToNewMap = new HashMap<PsiElement, PsiElement>();
            for (PsiElement element : this.myElementsToMove) {
                if (element instanceof PsiDirectory) {
                    MoveFilesOrDirectoriesUtil.doMoveDirectory((PsiDirectory)element, this.myNewParent);
                } else if (element instanceof PsiFile) {
                    PsiFile movedFile = (PsiFile)element;
                    MoveFileHandler.forElement(movedFile).prepareMovedFile(movedFile, this.myNewParent, oldToNewMap);
                    FileReferenceContextUtil.encodeFileReferences(element);
                    MoveFilesOrDirectoriesUtil.doMoveFile(movedFile, this.myNewParent);
                    movedFiles.add(movedFile);
                }
                this.getTransaction().getElementListener(element).elementMoved(element);
            }
            Arrays.sort(usages, new Comparator<UsageInfo>(){

                @Override
                public int compare(UsageInfo o1, UsageInfo o2) {
                    return o1.getElement() == o2.getElement() ? o2.startOffset - o1.startOffset : 0;
                }
            });
            this.retargetUsages(usages, oldToNewMap);
            for (PsiFile movedFile : movedFiles) {
                MoveFileHandler.forElement(movedFile).updateMovedFile(movedFile);
                FileReferenceContextUtil.decodeFileReferences((PsiElement)movedFile);
            }
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
        }
        catch (IncorrectOperationException e) {
            int index;
            final String message = e.getMessage();
            int n = index = message != null ? message.indexOf("java.io.IOException") : -1;
            if (index >= 0) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showMessageDialog((Project)MoveFilesOrDirectoriesProcessor.this.myProject, (String)message.substring(index + "java.io.IOException".length()), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                    }
                });
            }
            LOG.error((Throwable)e);
        }
    }

    private void retargetUsages(UsageInfo[] usages, Map<PsiElement, PsiElement> oldToNewMap) {
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usageInfo : usages) {
            if (usageInfo instanceof MyUsageInfo) {
                PsiFile usageFile;
                PsiFile psiFile;
                PsiElement usageElement;
                MyUsageInfo info = (MyUsageInfo)usageInfo;
                PsiElement element = this.myElementsToMove[info.myIndex];
                if (info.getReference() instanceof FileReference && (usageElement = info.getElement()) != null && (psiFile = (usageFile = usageElement.getContainingFile()).getViewProvider().getPsi(usageFile.getViewProvider().getBaseLanguage())) != null && psiFile.equals(element)) continue;
                info.myReference.bindToElement(element);
                continue;
            }
            if (!(usageInfo instanceof NonCodeUsageInfo)) continue;
            nonCodeUsages.add((NonCodeUsageInfo)usageInfo);
        }
        for (PsiFile movedFile : this.myFoundUsages.keySet()) {
            MoveFileHandler.forElement(movedFile).retargetUsages(this.myFoundUsages.get(movedFile), oldToNewMap);
        }
        this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[nonCodeUsages.size()]);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"move.title");
    }

    static class MyUsageInfo
    extends UsageInfo {
        int myIndex;
        PsiReference myReference;

        public MyUsageInfo(PsiElement element, int index, PsiReference reference) {
            super(element);
            this.myIndex = index;
            this.myReference = reference;
        }
    }
}

