/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"move.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/MoveHandler.invoke must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            PsiElement refElement;
            int relative;
            PsiReference reference;
            if (element == null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.at.the.class.method.or.field.to.be.refactored"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
                return;
            }
            if (MoveHandler.tryToMoveElement(element, project, dataContext, null, editor)) {
                return;
            }
            TextRange range = element.getTextRange();
            if (range != null && (reference = element.findReferenceAt(relative = offset - range.getStartOffset())) != null && (refElement = reference.resolve()) != null && MoveHandler.tryToMoveElement(refElement, project, dataContext, reference, editor)) {
                return;
            }
            element = element.getParent();
        }
    }

    private static boolean tryToMoveElement(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.tryToMove(element, project, dataContext, reference, editor)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/MoveHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/move/MoveHandler.invoke must not be null");
        }
        MoveHandler.doMove(project, elements, dataContext == null ? null : (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext), null);
    }

    public static void doMove(Project project, @NotNull PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/move/MoveHandler.doMove must not be null");
        }
        if (elements.length == 0) {
            return;
        }
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.canMove(elements, targetContainer)) continue;
            delegate.doMove(project, elements, targetContainer, callback);
            break;
        }
    }

    @Nullable
    public static PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.canMove(sourceElements, targetElement)) continue;
            return delegate.adjustForMove(project, sourceElements, targetElement);
        }
        return sourceElements;
    }

    public static boolean canMove(@NotNull PsiElement[] elements, PsiElement targetContainer) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/MoveHandler.canMove must not be null");
        }
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.canMove(elements, targetContainer)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidTarget(PsiElement psiElement) {
        if (psiElement != null) {
            for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
                if (!delegate.isValidTarget(psiElement)) continue;
                return true;
            }
        }
        return false;
    }
}

