/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.ide.util.TreeClassChooserDialog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceparameterobject.IntroduceParameterObjectProcessor;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class IntroduceParameterObjectDialog
extends RefactoringDialog {
    private final PsiMethod sourceMethod;
    private final ParameterTablePanel.VariableData[] parameterInfo;
    private JTextField sourceMethodTextField;
    private JRadioButton useExistingClassButton;
    private JPanel myUseExistingPanel;
    private JRadioButton createNewClassButton;
    private JTextField classNameField;
    private JPanel myCreateNewClassPanel;
    private JRadioButton myCreateInnerClassRadioButton;
    private JTextField myInnerClassNameTextField;
    private JPanel myInnerClassPanel;
    private JPanel myWholePanel;
    private JPanel myParamsPanel;
    private JCheckBox keepMethodAsDelegate;
    private ReferenceEditorComboWithBrowseButton packageTextField;
    private ReferenceEditorComboWithBrowseButton existingClassField;
    private JCheckBox myGenerateAccessorsCheckBox;
    private JCheckBox myEscalateVisibilityCheckBox;
    private static final String RECENTS_KEY = "IntroduceParameterObject.RECENTS_KEY";
    private static final String EXISTING_KEY = "IntroduceParameterObject.EXISTING_KEY";

    public IntroduceParameterObjectDialog(PsiMethod sourceMethod) {
        super(sourceMethod.getProject(), true);
        this.sourceMethod = sourceMethod;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(RefactorJBundle.message("introduce.parameter.object.title", objectArray));
        com.intellij.ui.DocumentAdapter docListener = new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                IntroduceParameterObjectDialog.this.validateButtons();
            }
        };
        PsiClass containingClass = sourceMethod.getContainingClass();
        this.keepMethodAsDelegate.setVisible(containingClass != null && !containingClass.isInterface());
        this.classNameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        this.myInnerClassNameTextField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        PsiParameterList parameterList = sourceMethod.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        this.parameterInfo = new ParameterTablePanel.VariableData[parameters.length];
        for (int i = 0; i < this.parameterInfo.length; ++i) {
            this.parameterInfo[i] = new ParameterTablePanel.VariableData((PsiVariable)parameters[i]);
            this.parameterInfo[i].name = parameters[i].getName();
            this.parameterInfo[i].passAsParameter = true;
        }
        this.sourceMethodTextField.setText(PsiFormatUtil.formatMethod((PsiMethod)sourceMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useExistingClassButton);
        buttonGroup.add(this.createNewClassButton);
        buttonGroup.add(this.myCreateInnerClassRadioButton);
        this.createNewClassButton.setSelected(true);
        this.init();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IntroduceParameterObjectDialog.this.toggleRadioEnablement();
                IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)IntroduceParameterObjectDialog.this.myProject);
                if (IntroduceParameterObjectDialog.this.useExistingClass()) {
                    focusManager.requestFocus((Component)((Object)IntroduceParameterObjectDialog.this.existingClassField), true);
                } else if (IntroduceParameterObjectDialog.this.myCreateInnerClassRadioButton.isSelected()) {
                    focusManager.requestFocus((Component)IntroduceParameterObjectDialog.this.myInnerClassNameTextField, true);
                } else {
                    focusManager.requestFocus((Component)IntroduceParameterObjectDialog.this.classNameField, true);
                }
            }
        };
        this.useExistingClassButton.addActionListener(listener);
        this.createNewClassButton.addActionListener(listener);
        this.myCreateInnerClassRadioButton.addActionListener(listener);
        this.myGenerateAccessorsCheckBox.setSelected(true);
        this.myEscalateVisibilityCheckBox.setSelected(true);
        this.toggleRadioEnablement();
    }

    private void toggleRadioEnablement() {
        UIUtil.setEnabled((Component)this.myUseExistingPanel, (boolean)this.useExistingClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myCreateNewClassPanel, (boolean)this.createNewClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myInnerClassPanel, (boolean)this.myCreateInnerClassRadioButton.isSelected(), (boolean)true);
        this.validateButtons();
        this.enableGenerateAccessors();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.IntroduceParameterObject";
    }

    @Override
    protected void doAction() {
        String packageName;
        String className;
        boolean useExistingClass = this.useExistingClass();
        boolean keepMethod = this.keepMethodAsDelegate();
        boolean createInnerClass = this.myCreateInnerClassRadioButton.isSelected();
        if (createInnerClass) {
            className = this.getInnerClassName();
            packageName = "";
        } else if (useExistingClass) {
            String existingClassName = this.getExistingClassName();
            className = StringUtil.getShortName((String)existingClassName);
            packageName = StringUtil.getPackageName((String)existingClassName);
        } else {
            packageName = this.getPackageName();
            className = this.getClassName();
        }
        ArrayList<ParameterTablePanel.VariableData> parameters = new ArrayList<ParameterTablePanel.VariableData>();
        for (ParameterTablePanel.VariableData data : this.parameterInfo) {
            if (!data.passAsParameter) continue;
            parameters.add(data);
        }
        String newVisibility = this.myEscalateVisibilityCheckBox.isEnabled() && this.myEscalateVisibilityCheckBox.isSelected() ? "EscalateVisible" : null;
        this.invokeRefactoring(new IntroduceParameterObjectProcessor(className, packageName, this.sourceMethod, parameters.toArray(new ParameterTablePanel.VariableData[parameters.size()]), keepMethod, useExistingClass, createInnerClass, newVisibility, this.myGenerateAccessorsCheckBox.isSelected()));
    }

    @Override
    protected void canRun() throws ConfigurationException {
        Project project = this.sourceMethod.getProject();
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)project);
        PsiNameHelper nameHelper = manager.getNameHelper();
        List<PsiParameter> parametersToExtract = this.getParametersToExtract();
        if (parametersToExtract.isEmpty()) {
            throw new ConfigurationException("Nothing found to extract");
        }
        if (this.myCreateInnerClassRadioButton.isSelected()) {
            String innerClassName = this.getInnerClassName().trim();
            if (!nameHelper.isIdentifier(innerClassName)) {
                throw new ConfigurationException("'" + StringUtil.first((String)innerClassName, (int)10, (boolean)true) + "' is invalid inner class name");
            }
            if (this.sourceMethod.getContainingClass().findInnerClassByName(innerClassName, false) != null) {
                throw new ConfigurationException("Inner class with name '" + StringUtil.first((String)innerClassName, (int)10, (boolean)true) + "' already exist");
            }
        } else if (!this.useExistingClass()) {
            String className = this.getClassName();
            if (className.length() == 0 || !nameHelper.isIdentifier(className)) {
                throw new ConfigurationException("'" + StringUtil.first((String)className, (int)10, (boolean)true) + "' is invalid parameter class name");
            }
            String packageName = this.getPackageName();
            if (packageName.length() == 0 || !nameHelper.isQualifiedName(packageName)) {
                throw new ConfigurationException("'" + StringUtil.last((CharSequence)packageName, (int)10, (boolean)true) + "' is invalid parameter class package name");
            }
        } else {
            String className = this.getExistingClassName();
            if (className.length() == 0 || !nameHelper.isQualifiedName(className)) {
                throw new ConfigurationException("'" + StringUtil.first((String)className, (int)10, (boolean)true) + "' is invalid qualified parameter class name");
            }
            if (JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject())) == null) {
                throw new ConfigurationException("'" + StringUtil.first((String)className, (int)10, (boolean)true) + "' does not exist");
            }
        }
    }

    private String getInnerClassName() {
        return this.myInnerClassNameTextField.getText().trim();
    }

    @NotNull
    public String getPackageName() {
        String string = this.packageTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog.getPackageName must not return null");
        }
        return string;
    }

    @NotNull
    public String getExistingClassName() {
        String string = this.existingClassField.getText().trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog.getExistingClassName must not return null");
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.classNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog.getClassName must not return null");
        }
        return string;
    }

    @NotNull
    public List<PsiParameter> getParametersToExtract() {
        ArrayList<PsiParameter> out = new ArrayList<PsiParameter>();
        for (ParameterTablePanel.VariableData info : this.parameterInfo) {
            if (!info.passAsParameter) continue;
            out.add((PsiParameter)info.variable);
        }
        ArrayList<PsiParameter> arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog.getParametersToExtract must not return null");
        }
        return arrayList;
    }

    protected JComponent createCenterPanel() {
        this.sourceMethodTextField.setEditable(false);
        ParameterTablePanel paramsPanel = new ParameterTablePanel(this.myProject, this.parameterInfo, new PsiElement[]{this.sourceMethod}){

            @Override
            protected void updateSignature() {
            }

            @Override
            protected void doEnterAction() {
            }

            @Override
            protected void doCancelAction() {
                IntroduceParameterObjectDialog.this.doCancelAction();
            }
        };
        this.myParamsPanel.add((Component)paramsPanel, "Center");
        return this.myWholePanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classNameField;
    }

    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactorj.introduceParameterObject");
    }

    public boolean useExistingClass() {
        return this.useExistingClassButton.isSelected();
    }

    public boolean keepMethodAsDelegate() {
        return this.keepMethodAsDelegate.isSelected();
    }

    private void createUIComponents() {
        PsiFile file = this.sourceMethod.getContainingFile();
        this.packageTextField = new PackageNameReferenceEditorCombo(file instanceof PsiJavaFile ? ((PsiJavaFile)file).getPackageName() : "", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        Document document = ((EditorComboBox)this.packageTextField.getChildComponent()).getDocument();
        DocumentAdapter adapter = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                IntroduceParameterObjectDialog.this.validateButtons();
            }
        };
        document.addDocumentListener((DocumentListener)adapter);
        this.existingClassField = new ReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = IntroduceParameterObjectDialog.this.sourceMethod.getProject();
                GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                TreeClassChooserDialog chooser = new TreeClassChooserDialog(RefactorJBundle.message("select.wrapper.class", new Object[0]), project, scope, null, null);
                String classText = IntroduceParameterObjectDialog.this.existingClassField.getText();
                PsiClass currentClass = JavaPsiFacade.getInstance((Project)project).findClass(classText, GlobalSearchScope.allScope((Project)project));
                if (currentClass != null) {
                    chooser.selectClass(currentClass);
                }
                chooser.show();
                PsiClass selectedClass = chooser.getSelectedClass();
                if (selectedClass != null) {
                    String className = selectedClass.getQualifiedName();
                    IntroduceParameterObjectDialog.this.existingClassField.setText(className);
                    RecentsManager.getInstance(IntroduceParameterObjectDialog.this.myProject).registerRecentEntry(IntroduceParameterObjectDialog.EXISTING_KEY, className);
                }
            }
        }, "", PsiManager.getInstance((Project)this.myProject), true, EXISTING_KEY);
        ((EditorComboBox)this.existingClassField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                IntroduceParameterObjectDialog.this.validateButtons();
                IntroduceParameterObjectDialog.this.enableGenerateAccessors();
            }
        });
    }

    private void enableGenerateAccessors() {
        VirtualFile virtualFile;
        PsiFile containingFile;
        PsiClass selectedClass;
        boolean existingNotALibraryClass = false;
        if (this.useExistingClassButton.isSelected() && (selectedClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.existingClassField.getText(), GlobalSearchScope.projectScope((Project)this.myProject))) != null && (containingFile = selectedClass.getContainingFile()) != null && (virtualFile = containingFile.getVirtualFile()) != null) {
            existingNotALibraryClass = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInSourceContent(virtualFile);
        }
        this.myGenerateAccessorsCheckBox.setEnabled(existingNotALibraryClass);
        this.myEscalateVisibilityCheckBox.setEnabled(existingNotALibraryClass);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JTextField jTextField;
        JPanel jPanel2;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel3;
        JTextField jTextField2;
        JPanel jPanel4;
        JRadioButton jRadioButton3;
        JTextField jTextField3;
        JPanel jPanel5;
        this.createUIComponents();
        this.myWholePanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/refactoring/RefactorJBundle").getString("method.to.extract.parameters.from.label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        jPanel5.add((Component)jPanel6, gridBagConstraints2);
        this.sourceMethodTextField = jTextField3 = new JTextField();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 4;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        jPanel5.add((Component)jTextField3, gridBagConstraints3);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 6;
        gridBagConstraints4.gridwidth = 4;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(10, 0, 0, 0);
        jPanel5.add((Component)jPanel7, gridBagConstraints4);
        jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Parameter Class", 0, 0, null, null));
        this.createNewClassButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Create new class");
        jRadioButton3.setMnemonic('C');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.fill = 1;
        jPanel7.add((Component)jRadioButton3, gridBagConstraints5);
        this.myCreateNewClassPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.gridwidth = 6;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.insets = new Insets(0, 20, 0, 0);
        jPanel7.add((Component)jPanel4, gridBagConstraints6);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Name");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.anchor = 17;
        jPanel4.add((Component)jLabel2, gridBagConstraints7);
        this.classNameField = jTextField2 = new JTextField();
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 0;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.fill = 2;
        jPanel4.add((Component)jTextField2, gridBagConstraints8);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Package name");
        jLabel3.setDisplayedMnemonic('P');
        jLabel3.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 1;
        gridBagConstraints9.anchor = 17;
        jPanel4.add((Component)jLabel3, gridBagConstraints9);
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageTextField;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.gridy = 1;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.fill = 2;
        jPanel4.add((Component)((Object)referenceEditorComboWithBrowseButton), gridBagConstraints10);
        this.myUseExistingPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 5;
        gridBagConstraints11.gridwidth = 4;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.insets = new Insets(0, 20, 0, 0);
        jPanel7.add((Component)jPanel3, gridBagConstraints11);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Name");
        jLabel4.setDisplayedMnemonic('N');
        jLabel4.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 0;
        gridBagConstraints12.fill = 2;
        jPanel3.add((Component)jLabel4, gridBagConstraints12);
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.existingClassField;
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.gridy = 0;
        gridBagConstraints13.weightx = 1.0;
        gridBagConstraints13.fill = 2;
        jPanel3.add((Component)((Object)referenceEditorComboWithBrowseButton2), gridBagConstraints13);
        this.myGenerateAccessorsCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Generate accessors");
        jCheckBox3.setMnemonic('G');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.gridy = 2;
        gridBagConstraints14.gridwidth = 2;
        gridBagConstraints14.anchor = 18;
        jPanel3.add((Component)jCheckBox3, gridBagConstraints14);
        this.myEscalateVisibilityCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Escalate visibility");
        jCheckBox2.setMnemonic('E');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 0;
        gridBagConstraints15.gridy = 1;
        gridBagConstraints15.gridwidth = 2;
        gridBagConstraints15.anchor = 17;
        jPanel3.add((Component)jCheckBox2, gridBagConstraints15);
        this.myCreateInnerClassRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Create inner class");
        jRadioButton2.setMnemonic('I');
        jRadioButton2.setDisplayedMnemonicIndex(7);
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.gridx = 0;
        gridBagConstraints16.gridy = 2;
        gridBagConstraints16.anchor = 17;
        gridBagConstraints16.insets = new Insets(10, 0, 0, 0);
        jPanel7.add((Component)jRadioButton2, gridBagConstraints16);
        this.myInnerClassPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.gridx = 0;
        gridBagConstraints17.gridy = 3;
        gridBagConstraints17.gridwidth = 3;
        gridBagConstraints17.fill = 1;
        gridBagConstraints17.insets = new Insets(0, 20, 0, 0);
        jPanel7.add((Component)jPanel2, gridBagConstraints17);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Name");
        jLabel5.setDisplayedMnemonic('N');
        jLabel5.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.gridy = 0;
        gridBagConstraints18.fill = 2;
        jPanel2.add((Component)jLabel5, gridBagConstraints18);
        this.myInnerClassNameTextField = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.gridx = 1;
        gridBagConstraints19.gridy = 0;
        gridBagConstraints19.weightx = 1.0;
        gridBagConstraints19.fill = 2;
        jPanel2.add((Component)jTextField, gridBagConstraints19);
        this.useExistingClassButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use existing class");
        jRadioButton.setMnemonic('U');
        jRadioButton.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.gridx = 0;
        gridBagConstraints20.gridy = 4;
        gridBagConstraints20.weightx = 1.0;
        gridBagConstraints20.fill = 1;
        gridBagConstraints20.insets = new Insets(10, 0, 0, 0);
        jPanel7.add((Component)jRadioButton, gridBagConstraints20);
        this.myParamsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.gridy = 7;
        gridBagConstraints21.gridwidth = 4;
        gridBagConstraints21.weighty = 1.0;
        gridBagConstraints21.fill = 1;
        gridBagConstraints21.insets = new Insets(10, 0, 0, 0);
        jPanel5.add((Component)jPanel, gridBagConstraints21);
        jPanel.setBorder(BorderFactory.createTitledBorder(null, "Parameters to Extract", 0, 0, null, null));
        this.keepMethodAsDelegate = jCheckBox = new JCheckBox();
        jCheckBox.setText("Keep method as delegate");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(15);
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.gridx = 0;
        gridBagConstraints22.gridy = 2;
        gridBagConstraints22.gridwidth = 4;
        gridBagConstraints22.anchor = 17;
        jPanel5.add((Component)jCheckBox, gridBagConstraints22);
        jLabel2.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

