/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceVariable.InputValidator;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableDialog;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;

public class IntroduceVariableHandler
extends IntroduceVariableBase {
    @Override
    protected IntroduceVariableSettings getSettings(Project project, Editor editor, PsiExpression expr, PsiElement[] occurrences, boolean anyAssignmentLHS, boolean declareFinalIfAll, PsiType type, TypeSelectorManagerImpl typeSelectorManager, InputValidator validator) {
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = null;
        if (editor != null) {
            highlightManager = HighlightManager.getInstance((Project)project);
            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            if (occurrences.length > 1) {
                highlightManager.addOccurrenceHighlights(editor, occurrences, attributes, true, highlighters);
            }
        }
        IntroduceVariableDialog dialog = new IntroduceVariableDialog(project, expr, occurrences.length, anyAssignmentLHS, declareFinalIfAll, typeSelectorManager, validator);
        dialog.show();
        if (!dialog.isOK()) {
            if (occurrences.length > 1) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
        } else if (editor != null) {
            for (RangeHighlighter highlighter : highlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
        }
        return dialog;
    }

    @Override
    protected void showErrorMessage(Project project, Editor editor, String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.introduceVariable");
    }

    @Override
    protected void highlightReplacedOccurences(Project project, Editor editor, PsiElement[] replacedOccurences) {
        if (editor == null) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlights(editor, replacedOccurences, attributes, true, null);
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    @Override
    protected boolean reportConflicts(MultiMap<PsiElement, String> conflicts, Project project, IntroduceVariableSettings dialog) {
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        conflictsDialog.show();
        boolean ok = conflictsDialog.isOK();
        if (!ok && conflictsDialog.isShowConflicts() && dialog instanceof DialogWrapper) {
            ((DialogWrapper)dialog).close(1);
        }
        return ok;
    }
}

