/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class GenericInlineHandler {
    /*
     * WARNING - void declaration
     */
    public static boolean invoke(final PsiElement element, Editor editor, InlineHandler languageSpecific) {
        PsiReference invocationReference = TargetElementUtilBase.findReference(editor);
        InlineHandler.Settings settings = languageSpecific.prepareInlineElement(element, editor, invocationReference != null);
        if (settings == null || settings == InlineHandler.Settings.CANNOT_INLINE_SETTINGS) {
            return settings != null;
        }
        final Collection<Object> allReferences = settings.isOnlyOneReferenceToInline() ? Collections.singleton(invocationReference) : ReferencesSearch.search((PsiElement)element).findAll();
        HashMap inliners = new HashMap();
        MultiMap conflicts = new MultiMap();
        for (PsiReference psiReference : allReferences) {
            void var11_16;
            Language language = psiReference.getElement().getLanguage();
            if (inliners.containsKey(language)) continue;
            Object var11_17 = null;
            List handlers = InlineHandlers.getInlineHandlers((Language)language);
            for (InlineHandler handler : handlers) {
                InlineHandler.Inliner inliner = handler.createInliner(element, settings);
                if (inliner == null) continue;
                inliners.put(language, inliner);
                break;
            }
            if (var11_16 != null) continue;
            conflicts.putValue(null, (Object)("Cannot inline reference from " + language.getID()));
        }
        for (PsiReference psiReference : allReferences) {
            GenericInlineHandler.collectConflicts(psiReference, element, (Map<Language, InlineHandler.Inliner>)inliners, (MultiMap<PsiElement, String>)conflicts);
        }
        final Project project = element.getProject();
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, (MultiMap<PsiElement, String>)conflicts);
            conflictsDialog.show();
            if (!conflictsDialog.isOK()) {
                return true;
            }
        }
        HashSet hashSet = new HashSet();
        for (PsiReference psiReference : allReferences) {
            PsiElement refElement = psiReference.getElement();
            if (refElement == null) continue;
            hashSet.add((Object)refElement);
        }
        if (!settings.isOnlyOneReferenceToInline()) {
            hashSet.add((Object)element);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, (Collection)hashSet)) {
            return true;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable((Map)inliners, settings, languageSpecific){
            final /* synthetic */ Map val$inliners;
            final /* synthetic */ InlineHandler.Settings val$settings;
            final /* synthetic */ InlineHandler val$languageSpecific;
            {
                this.val$inliners = map;
                this.val$settings = settings;
                this.val$languageSpecific = inlineHandler;
            }

            @Override
            public void run() {
                String subj = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : "element";
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        PsiReference[] references = GenericInlineHandler.sortDepthFirstRightLeftOrder(allReferences);
                        UsageInfo[] usages = new UsageInfo[references.length];
                        for (int i = 0; i < references.length; ++i) {
                            usages[i] = new UsageInfo(references[i]);
                        }
                        for (UsageInfo usage : usages) {
                            GenericInlineHandler.inlineReference(usage, element, val$inliners);
                        }
                        if (!val$settings.isOnlyOneReferenceToInline()) {
                            val$languageSpecific.removeDefinition(element, val$settings);
                        }
                    }
                }, RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{subj}), null);
            }
        });
        return true;
    }

    private static void collectConflicts(PsiReference reference, PsiElement element, Map<Language, InlineHandler.Inliner> inliners, MultiMap<PsiElement, String> conflicts) {
        Map refConflicts;
        Language language = reference.getElement().getLanguage();
        InlineHandler.Inliner inliner = inliners.get(language);
        if (inliner != null && (refConflicts = inliner.getConflicts(reference, element)) != null) {
            for (PsiElement psiElement : refConflicts.keySet()) {
                conflicts.putValue((Object)psiElement, refConflicts.get(psiElement));
            }
        }
    }

    private static void inlineReference(UsageInfo usage, PsiElement element, Map<Language, InlineHandler.Inliner> inliners) {
        Language language = usage.getElement().getLanguage();
        InlineHandler.Inliner inliner = inliners.get(language);
        if (inliner != null) {
            inliner.inlineUsage(usage, element);
        }
    }

    public static PsiReference[] sortDepthFirstRightLeftOrder(Collection<PsiReference> allReferences) {
        PsiReference[] usages = allReferences.toArray(new PsiReference[allReferences.size()]);
        Arrays.sort(usages, new Comparator<PsiReference>(){

            @Override
            public int compare(PsiReference usage1, PsiReference usage2) {
                PsiElement element1 = usage1.getElement();
                PsiElement element2 = usage2.getElement();
                if (element1 == null || element2 == null) {
                    return 0;
                }
                return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
            }
        });
        return usages;
    }
}

