/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.refactoring.extractMethod.AbstractVariableData;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public abstract class AbstractParameterTablePanel
extends JPanel {
    private AbstractVariableData[] myVariableData;
    private Table myTable;
    private MyTableModel myTableModel;
    private JButton myUpButton;
    private JButton myDownButton;
    private final ExtractMethodValidator myValidator;

    protected abstract void updateSignature();

    protected abstract void doEnterAction();

    protected abstract void doCancelAction();

    public void setVariableData(AbstractVariableData[] variableData) {
        this.myVariableData = variableData;
    }

    public AbstractParameterTablePanel(ExtractMethodValidator validator) {
        super(new BorderLayout());
        this.myValidator = validator;
    }

    public void init() {
        this.myTableModel = new MyTableModel();
        this.myTable = new Table((TableModel)this.myTableModel);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.setTableHeader(null);
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.getColumnModel().getColumn(0).setMaxWidth(new JCheckBox().getPreferredSize().width);
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                AbstractVariableData data = AbstractParameterTablePanel.this.myVariableData[row];
                this.setText(data.name);
                return this;
            }
        });
        this.myTable.setPreferredScrollableViewportSize(new Dimension(250, this.myTable.getRowHeight() * 5));
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractParameterTablePanel.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = AbstractParameterTablePanel.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[row].passAsParameter) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[row].passAsParameter = valueToBeSet;
                    }
                    AbstractParameterTablePanel.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)AbstractParameterTablePanel.this.myTable, (int[])rows);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "edit_parameter_name");
        actionMap.put("edit_parameter_name", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!AbstractParameterTablePanel.this.myTable.isEditing() && (row = AbstractParameterTablePanel.this.myTable.getSelectedRow()) >= 0 && row < AbstractParameterTablePanel.this.myTableModel.getRowCount()) {
                    TableUtil.editCellAt((JTable)AbstractParameterTablePanel.this.myTable, (int)row, (int)1);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "invokeImpl");
        actionMap.put("invokeImpl", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = AbstractParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    AbstractParameterTablePanel.this.doEnterAction();
                }
            }
        });
        actionMap.put("doCancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = AbstractParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    AbstractParameterTablePanel.this.doCancelAction();
                }
            }
        });
        JPanel listPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myTable);
        listPanel.add((Component)scrollPane, "Center");
        listPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)listPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)buttonsPanel, "East");
        buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets = new Insets(2, 4, 2, 4);
        this.myUpButton = new JButton();
        this.myUpButton.setText(UIBundle.message((String)"row.move.up", (Object[])new Object[0]));
        this.myUpButton.setDefaultCapable(false);
        buttonsPanel.add((Component)this.myUpButton, gbConstraints);
        this.myDownButton = new JButton();
        this.myDownButton.setText(UIBundle.message((String)"row.move.down", (Object[])new Object[0]));
        this.myDownButton.setDefaultCapable(false);
        buttonsPanel.add((Component)this.myDownButton, gbConstraints);
        gbConstraints.weighty = 1.0;
        buttonsPanel.add((Component)new JPanel(), gbConstraints);
        this.myUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isStopped;
                if (AbstractParameterTablePanel.this.myTable.isEditing() && !(isStopped = AbstractParameterTablePanel.this.myTable.getCellEditor().stopCellEditing())) {
                    return;
                }
                AbstractParameterTablePanel.this.moveSelectedItem(-1);
                AbstractParameterTablePanel.this.updateSignature();
                AbstractParameterTablePanel.this.myTable.requestFocus();
            }
        });
        this.myDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isStopped;
                if (AbstractParameterTablePanel.this.myTable.isEditing() && !(isStopped = AbstractParameterTablePanel.this.myTable.getCellEditor().stopCellEditing())) {
                    return;
                }
                AbstractParameterTablePanel.this.moveSelectedItem(1);
                AbstractParameterTablePanel.this.updateSignature();
                AbstractParameterTablePanel.this.myTable.requestFocus();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractParameterTablePanel.this.updateMoveButtons();
            }
        });
        if (this.myVariableData.length <= 1) {
            this.myUpButton.setEnabled(false);
            this.myDownButton.setEnabled(false);
        } else {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.updateMoveButtons();
    }

    private void updateMoveButtons() {
        int row = this.myTable.getSelectedRow();
        if (0 <= row && row < this.myVariableData.length) {
            this.myUpButton.setEnabled(row > 0);
            this.myDownButton.setEnabled(row < this.myVariableData.length - 1);
        } else {
            this.myUpButton.setEnabled(false);
            this.myDownButton.setEnabled(false);
        }
    }

    private void moveSelectedItem(int moveIncrement) {
        int row = this.myTable.getSelectedRow();
        if (row < 0 || row >= this.myVariableData.length) {
            return;
        }
        int targetRow = row + moveIncrement;
        if (targetRow < 0 || targetRow >= this.myVariableData.length) {
            return;
        }
        AbstractVariableData currentItem = this.myVariableData[row];
        this.myVariableData[row] = this.myVariableData[targetRow];
        this.myVariableData[targetRow] = currentItem;
        this.myTableModel.fireTableRowsUpdated(Math.min(targetRow, row), Math.max(targetRow, row));
        this.myTable.getSelectionModel().setSelectionInterval(targetRow, targetRow);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTable.setEnabled(enabled);
        if (!enabled) {
            this.myUpButton.setEnabled(false);
            this.myDownButton.setEnabled(false);
        } else {
            this.updateMoveButtons();
        }
        super.setEnabled(enabled);
    }

    private class MyTableModel
    extends AbstractTableModel {
        public static final int CHECKMARK_COLUMN = 0;
        public static final int PARAMETER_NAME_COLUMN = 1;

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return AbstractParameterTablePanel.this.myVariableData.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[rowIndex].passAsParameter ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[rowIndex].name;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[rowIndex].passAsParameter = (Boolean)aValue;
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    AbstractParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                    AbstractParameterTablePanel.this.updateSignature();
                    break;
                }
                case 1: {
                    AbstractVariableData data = AbstractParameterTablePanel.this.myVariableData[rowIndex];
                    String name = (String)aValue;
                    if (AbstractParameterTablePanel.this.myValidator.isValidName(name)) {
                        data.name = name;
                    }
                    AbstractParameterTablePanel.this.updateSignature();
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AbstractParameterTablePanel.this.isEnabled();
                }
                case 1: {
                    return AbstractParameterTablePanel.this.isEnabled() && ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[rowIndex].passAsParameter;
                }
            }
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    }
}

