/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class EncapsulateFieldsHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.encapsulateFields.EncapsulateFieldsHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"encapsulate.fields.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/encapsulateFields/EncapsulateFieldsHandler.invoke must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
                return;
            }
            if (element instanceof PsiField) {
                if (((PsiField)element).getContainingClass() == null) {
                    String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.field.should.be.declared.in.a.class"));
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
                    return;
                }
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            if (element instanceof PsiClass) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/encapsulateFields/EncapsulateFieldsHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/encapsulateFields/EncapsulateFieldsHandler.invoke must not be null");
        }
        PsiClass aClass = null;
        HashSet<PsiField> preselectedFields = new HashSet<PsiField>();
        if (elements.length == 1) {
            if (elements[0] instanceof PsiClass) {
                aClass = (PsiClass)elements[0];
            } else {
                if (!(elements[0] instanceof PsiField)) return;
                PsiField field = (PsiField)elements[0];
                aClass = field.getContainingClass();
                preselectedFields.add(field);
            }
        } else {
            for (PsiElement element : elements) {
                if (!(element instanceof PsiField)) {
                    return;
                }
                PsiField field = (PsiField)element;
                if (aClass == null) {
                    aClass = field.getContainingClass();
                    preselectedFields.add(field);
                    continue;
                }
                if (aClass.equals(field.getContainingClass())) {
                    preselectedFields.add(field);
                    continue;
                }
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"fields.to.be.refactored.should.belong.to.the.same.class"));
                Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
                return;
            }
        }
        LOG.assertTrue(aClass != null);
        PsiField[] fields = aClass.getFields();
        if (fields.length == 0) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)((Editor)PlatformDataKeys.EDITOR.getData(dataContext)), (String)"Class has no fields to encapsulate", (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
            return;
        }
        if (aClass.isInterface()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"encapsulate.fields.refactoring.cannot.be.applied.to.interface"));
            Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        EncapsulateFieldsDialog dialog = new EncapsulateFieldsDialog(project, aClass, preselectedFields);
        dialog.show();
    }
}

