/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;

public class ThrownExceptionInfo {
    int oldIndex;
    CanonicalTypes.Type myType;

    public ThrownExceptionInfo() {
        this.oldIndex = -1;
    }

    public ThrownExceptionInfo(int oldIndex) {
        this.oldIndex = oldIndex;
    }

    public ThrownExceptionInfo(int oldIndex, PsiClassType type) {
        this.oldIndex = oldIndex;
        this.setType(type);
    }

    public void setType(PsiClassType type) {
        this.myType = CanonicalTypes.createTypeWrapper((PsiType)type);
    }

    public PsiType createType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
        if (this.myType != null) {
            return this.myType.getType(context, manager);
        }
        return null;
    }

    String getTypeText() {
        if (this.myType != null) {
            return this.myType.getTypeText();
        }
        return "";
    }

    public void updateFromMethod(PsiMethod method) {
        if (this.myType != null) {
            return;
        }
        PsiClassType[] types = method.getThrowsList().getReferencedTypes();
        if (this.oldIndex >= 0) {
            this.setType(types[this.oldIndex]);
        }
    }

    public int getOldIndex() {
        return this.oldIndex;
    }
}

