/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ExceptionsTableModel;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterTableModel;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.inCallers.CallerChooser;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditor;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.DelegationPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.ui.VisibilityPanel;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditableRowTable;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RowEditableTableModel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ChangeSignatureDialog");
    private final PsiMethod myMethod;
    private final boolean myAllowDelegation;
    private EditorTextField myNameField;
    private EditorTextField myReturnTypeField;
    private JTable myParametersTable;
    private final ParameterTableModel myParametersTableModel;
    private JTextArea mySignatureArea;
    private final Alarm myUpdateSignatureAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private VisibilityPanel myVisibilityPanel;
    private PsiTypeCodeFragment myReturnTypeCodeFragment;
    private DelegationPanel myDelegationPanel;
    private JTable myExceptionsTable;
    private final ExceptionsTableModel myExceptionsTableModel;
    private JButton myPropagateParamChangesButton;
    private JButton myPropagateExnChangesButton;
    private Set<PsiMethod> myMethodsToPropagateParameters = null;
    private Set<PsiMethod> myMethodsToPropagateExceptions = null;
    private Tree myExceptionPropagationTree;
    private Tree myParameterPropagationTree;

    public ChangeSignatureDialog(Project project, PsiMethod method, boolean allowDelegation, PsiReferenceExpression ref) {
        super(project, true);
        this.myMethod = method;
        this.myParametersTableModel = new ParameterTableModel(this.myMethod.getParameterList(), ref, this);
        this.myExceptionsTableModel = new ExceptionsTableModel((PsiElement)this.myMethod.getThrowsList());
        this.myAllowDelegation = allowDelegation;
        this.setParameterInfos(ChangeSignatureDialog.getParameterInfos(method));
        this.myExceptionsTableModel.setTypeInfos(method);
        this.setTitle(ChangeSignatureHandler.REFACTORING_NAME);
        this.init();
        this.doUpdateSignature();
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ChangeSignatureDialog.this.myUpdateSignatureAlarm.cancelAllRequests();
            }
        });
    }

    public void setParameterInfos(List<ParameterInfoImpl> parameterInfos) {
        this.myParametersTableModel.setParameterInfos(parameterInfos, (PsiElement)this.myMethod.getParameterList());
        this.updateSignature();
    }

    private static List<ParameterInfoImpl> getParameterInfos(PsiMethod method) {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            ParameterInfoImpl info = new ParameterInfoImpl(i, parameter.getName(), parameter.getType());
            info.defaultValue = "";
            result.add(info);
        }
        return result;
    }

    private String getMethodName() {
        if (this.myNameField != null) {
            return this.myNameField.getText().trim();
        }
        return this.myMethod.getName();
    }

    @Nullable
    private CanonicalTypes.Type getReturnType() {
        if (this.myReturnTypeField != null) {
            try {
                PsiType type = this.myReturnTypeCodeFragment.getType();
                return CanonicalTypes.createTypeWrapper(type);
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return null;
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return null;
            }
        }
        return null;
    }

    private String getVisibility() {
        if (this.myVisibilityPanel != null) {
            return this.myVisibilityPanel.getVisibility();
        }
        return VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myMethod.getModifierList());
    }

    public ParameterInfoImpl[] getParameters() {
        return this.myParametersTableModel.getParameters();
    }

    private ThrownExceptionInfo[] getExceptions() {
        return this.myExceptionsTableModel.getThrownExceptions();
    }

    public boolean isGenerateDelegate() {
        return this.myAllowDelegation && this.myDelegationPanel.isGenerateDelegate();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myParametersTableModel.getRowCount() > 0 ? this.myParametersTable : this.myNameField;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0));
        JPanel top = new JPanel(new BorderLayout());
        if (this.myAllowDelegation) {
            this.myDelegationPanel = this.createDelegationPanel();
            top.add((Component)this.myDelegationPanel, "West");
        }
        JPanel propagatePanel = new JPanel();
        this.myPropagateParamChangesButton = new JButton(RefactoringBundle.message((String)"changeSignature.propagate.parameters.title"));
        this.myPropagateParamChangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CallerChooser(ChangeSignatureDialog.this.myMethod, RefactoringBundle.message((String)"changeSignature.parameter.caller.chooser"), ChangeSignatureDialog.this.myParameterPropagationTree){

                    @Override
                    protected void callersChosen(Set<PsiMethod> callers) {
                        ChangeSignatureDialog.this.myMethodsToPropagateParameters = callers;
                        ChangeSignatureDialog.this.myParameterPropagationTree = this.getTree();
                    }
                }.show();
            }
        });
        propagatePanel.add(this.myPropagateParamChangesButton);
        this.myPropagateExnChangesButton = new JButton(RefactoringBundle.message((String)"changeSignature.propagate.exceptions.title"));
        this.myPropagateExnChangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CallerChooser(ChangeSignatureDialog.this.myMethod, RefactoringBundle.message((String)"changeSignature.exception.caller.chooser"), ChangeSignatureDialog.this.myExceptionPropagationTree){

                    @Override
                    protected void callersChosen(Set<PsiMethod> callers) {
                        ChangeSignatureDialog.this.myMethodsToPropagateExceptions = callers;
                        ChangeSignatureDialog.this.myExceptionPropagationTree = this.getTree();
                    }
                }.show();
            }
        });
        propagatePanel.add(this.myPropagateExnChangesButton);
        top.add((Component)propagatePanel, "East");
        panel.add(top);
        if (!this.myMethod.isConstructor()) {
            JLabel namePrompt = new JLabel();
            this.myNameField = new EditorTextField(this.myMethod.getName());
            namePrompt.setText(RefactoringBundle.message((String)"name.prompt"));
            namePrompt.setLabelFor(this.myNameField);
            panel.add(namePrompt);
            panel.add(this.myNameField);
            DocumentListener documentListener = new DocumentListener(){

                public void beforeDocumentChange(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    ChangeSignatureDialog.this.updateSignature();
                }
            };
            this.myNameField.addDocumentListener(documentListener);
            JLabel typePrompt = new JLabel();
            panel.add(typePrompt);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
            PsiTypeElement typeElement = this.myMethod.getReturnTypeElement();
            if (typeElement == null) {
                LOG.error(this.myMethod.getClass().getName());
                return panel;
            }
            this.myReturnTypeCodeFragment = factory.createTypeCodeFragment(typeElement.getText(), (PsiElement)this.myMethod.getParameterList(), true, true);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)this.myReturnTypeCodeFragment);
            this.myReturnTypeField = new EditorTextField(document, this.myProject, (FileType)StdFileTypes.JAVA);
            typePrompt.setText(RefactoringBundle.message((String)"changeSignature.return.type.prompt"));
            typePrompt.setLabelFor(this.myReturnTypeField);
            panel.add(this.myReturnTypeField);
            this.myReturnTypeField.addDocumentListener(documentListener);
        }
        return panel;
    }

    private DelegationPanel createDelegationPanel() {
        return new DelegationPanel(){

            @Override
            protected void stateModified() {
                ChangeSignatureDialog.this.myParametersTableModel.fireTableDataChanged();
                ChangeSignatureDialog.this.configureParameterTableEditors();
            }
        };
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.add((Component)this.createParametersPanel(), "Center");
        PsiClass containingClass = this.myMethod.getContainingClass();
        if (containingClass != null && !containingClass.isInterface()) {
            this.myVisibilityPanel = new VisibilityPanel(false, false);
            this.myVisibilityPanel.setVisibility(VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myMethod.getModifierList()));
            this.myVisibilityPanel.addStateChangedListener(new VisibilityPanel.StateChanged(){

                @Override
                public void visibilityChanged() {
                    ChangeSignatureDialog.this.updateSignature();
                }
            });
            subPanel.add((Component)this.myVisibilityPanel, "East");
        }
        panel.add((Component)subPanel, "Center");
        JPanel subPanel1 = new JPanel(new GridBagLayout());
        subPanel1.add((Component)this.createExceptionsPanel(), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 1, new Insets(4, 4, 4, 0), 0, 0));
        subPanel1.add((Component)this.createSignaturePanel(), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 1, new Insets(4, 0, 4, 4), 0, 0));
        panel.add((Component)subPanel1, "South");
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "refactoring.ChangeSignatureDialog";
    }

    private JPanel createParametersPanel() {
        this.myParametersTable = new Table((TableModel)this.myParametersTableModel);
        this.myParametersTable.setCellSelectionEnabled(true);
        int minWidth = new JCheckBox().getPreferredSize().width;
        TableColumn anyVarColumn = this.myParametersTable.getColumnModel().getColumn(3);
        int headerWidth = this.myParametersTable.getFontMetrics(this.myParametersTable.getFont()).stringWidth(ParameterTableModel.ANY_VAR_COLUMN_NAME) + 8;
        anyVarColumn.setMaxWidth(Math.max(minWidth, headerWidth));
        this.configureParameterTableEditors();
        return this.createTablePanelImpl(this.myParametersTable, this.myParametersTableModel, RefactoringBundle.message((String)"parameters.border.title"), true);
    }

    private JPanel createExceptionsPanel() {
        this.myExceptionsTable = new Table((TableModel)this.myExceptionsTableModel);
        this.configureExceptionTableEditors();
        return this.createTablePanelImpl(this.myExceptionsTable, this.myExceptionsTableModel, RefactoringBundle.message((String)"changeSignature.exceptions.panel.border.title"), false);
    }

    private JPanel createTablePanelImpl(JTable table, RowEditableTableModel tableModel, String borderTitle, boolean addMnemonics) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)borderTitle));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)table);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)scrollPane, "Center");
        tablePanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        panel.add((Component)tablePanel, "Center");
        table.setPreferredScrollableViewportSize(new Dimension(450, table.getRowHeight() * 8));
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().setSelectionInterval(0, 0);
        table.setSurrendersFocusOnKeystroke(true);
        JPanel buttonsPanel = EditableRowTable.createButtonsTable((JTable)table, (RowEditableTableModel)tableModel, (boolean)addMnemonics);
        panel.add((Component)buttonsPanel, "East");
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ChangeSignatureDialog.this.updateSignature();
            }
        });
        return panel;
    }

    private void configureParameterTableEditors() {
        this.myParametersTable.getColumnModel().getColumn(0).setCellRenderer(new CodeFragmentTableCellRenderer(this.myProject));
        this.myParametersTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)new MyCellRenderer()));
        this.myParametersTable.getColumnModel().getColumn(2).setCellRenderer(new CodeFragmentTableCellRenderer(this.myProject));
        if (this.myParametersTable.getColumnCount() == 4) {
            this.myParametersTable.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (!ChangeSignatureDialog.this.myParametersTableModel.isCellEditable(row, ChangeSignatureDialog.this.myParametersTable.convertColumnIndexToModel(column))) {
                        this.setBackground(this.getBackground().darker());
                    }
                    return this;
                }
            });
        }
        this.myParametersTable.getColumnModel().getColumn(0).setCellEditor(new CodeFragmentTableCellEditor(this.myProject));
        this.myParametersTable.getColumnModel().getColumn(1).setCellEditor(new MyNameTableCellEditor(this.myProject));
        this.myParametersTable.getColumnModel().getColumn(2).setCellEditor(new CodeFragmentTableCellEditor(this.myProject){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Object valueAt;
                Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                if (this.myCodeFragment instanceof PsiExpressionCodeFragment && (valueAt = table.getValueAt(row, 0)) != null) {
                    try {
                        PsiType type = ((PsiTypeCodeFragment)valueAt).getType();
                        ((PsiExpressionCodeFragment)this.myCodeFragment).setExpectedType(type);
                    }
                    catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                    }
                    catch (PsiTypeCodeFragment.NoTypeException e) {
                        // empty catch block
                    }
                }
                return editor;
            }
        });
    }

    private void configureExceptionTableEditors() {
        this.myExceptionsTable.getColumnModel().getColumn(0).setCellRenderer(new CodeFragmentTableCellRenderer(this.myProject));
        this.myExceptionsTable.getColumnModel().getColumn(0).setCellEditor(new CodeFragmentTableCellEditor(this.myProject));
    }

    private void completeVariable(EditorTextField editorTextField, PsiType type) {
        Editor editor = editorTextField.getEditor();
        String prefix = editorTextField.getText();
        if (prefix == null) {
            prefix = "";
        }
        LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
        JavaCompletionUtil.completeVariableNameForRefactoring(this.myProject, set, prefix, type, VariableKind.PARAMETER);
        LookupElement[] lookupItems = set.toArray(new LookupElement[set.size()]);
        editor.getCaretModel().moveToOffset(prefix.length());
        editor.getSelectionModel().removeSelection();
        LookupManager.getInstance(this.myProject).showLookup(editor, lookupItems, prefix);
    }

    private JComponent createSignaturePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"signature.preview.border.title")), IdeBorderFactory.createEmptyBorder((Insets)new Insets(4, 4, 4, 4))));
        String s = this.calculateSignature();
        s = StringUtil.convertLineSeparators((String)s);
        int height = new StringTokenizer(s, "\n\r").countTokens() + 2;
        if (height > 10) {
            height = 10;
        }
        this.mySignatureArea = new JTextArea(height, 50);
        this.mySignatureArea.setEditable(false);
        this.mySignatureArea.setBackground(this.getContentPane().getBackground());
        JScrollPane scrollPane = new JScrollPane(this.mySignatureArea);
        scrollPane.setBorder(IdeBorderFactory.createEmptyBorder((Insets)new Insets(0, 0, 0, 0)));
        panel.add((Component)scrollPane, "Center");
        this.updateSignature();
        return panel;
    }

    private void updateSignature() {
        if (this.mySignatureArea == null) {
            return;
        }
        this.myUpdateSignatureAlarm.cancelAllRequests();
        this.myUpdateSignatureAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ChangeSignatureDialog.this.doUpdateSignature();
                ChangeSignatureDialog.this.updatePropagateButtons();
            }
        }, 100, ModalityState.stateForComponent((Component)this.mySignatureArea));
    }

    private void doUpdateSignature() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        String signature = this.calculateSignature();
        this.mySignatureArea.setText(signature);
    }

    private void updatePropagateButtons() {
        this.myPropagateParamChangesButton.setEnabled(!this.isGenerateDelegate() && this.mayPropagateParameters());
        this.myPropagateExnChangesButton.setEnabled(!this.isGenerateDelegate() && this.mayPropagateExceptions());
    }

    private boolean mayPropagateExceptions() {
        PsiClassType[] types;
        ThrownExceptionInfo[] thrownExceptions = this.myExceptionsTableModel.getThrownExceptions();
        if (thrownExceptions.length < (types = this.myMethod.getThrowsList().getReferencedTypes()).length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (thrownExceptions[i].oldIndex == i) continue;
            return false;
        }
        return true;
    }

    private boolean mayPropagateParameters() {
        PsiParameter[] parameters;
        ParameterInfoImpl[] infos = this.myParametersTableModel.getParameters();
        if (infos.length < (parameters = this.myMethod.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (infos[i].oldParameterIndex == i) continue;
            return false;
        }
        return true;
    }

    private String calculateSignature() {
        StringBuilder buffer = new StringBuilder();
        PsiModifierList modifierList = this.myMethod.getModifierList();
        String modifiers = modifierList.getText();
        String oldModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList);
        String newModifier = this.getVisibility();
        String newModifierStr = VisibilityUtil.getVisibilityString((String)newModifier);
        if (!newModifier.equals(oldModifier)) {
            int index = modifiers.indexOf(oldModifier);
            if (index >= 0) {
                StringBuilder buf = new StringBuilder(modifiers);
                buf.replace(index, index + oldModifier.length() + ("".equals(newModifierStr) ? 1 : 0), newModifierStr);
                modifiers = buf.toString();
            } else {
                if (!"".equals(newModifierStr)) {
                    newModifierStr = newModifierStr + " ";
                }
                modifiers = newModifierStr + modifiers;
            }
        }
        buffer.append(modifiers);
        if (!(modifiers.length() <= 0 || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\n') || StringUtil.endsWithChar((CharSequence)modifiers, (char)'\r') || StringUtil.endsWithChar((CharSequence)modifiers, (char)' '))) {
            buffer.append(" ");
        }
        if (!this.myMethod.isConstructor()) {
            CanonicalTypes.Type returnType = this.getReturnType();
            if (returnType != null) {
                buffer.append(returnType.getTypeText());
            }
            buffer.append(" ");
        }
        buffer.append(this.getMethodName());
        buffer.append("(");
        List<PsiTypeCodeFragment> codeFraments = this.myParametersTableModel.getCodeFraments();
        ParameterInfoImpl[] parameterInfos = this.myParametersTableModel.getParameters();
        LOG.assertTrue(codeFraments.size() == parameterInfos.length);
        String indent = "    ";
        for (int i = 0; i < parameterInfos.length; ++i) {
            ParameterInfoImpl info = parameterInfos[i];
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("\n");
            buffer.append("    ");
            buffer.append(codeFraments.get(i).getText());
            buffer.append(" ");
            buffer.append(info.getName());
        }
        if (parameterInfos.length > 0) {
            buffer.append("\n");
        }
        buffer.append(")");
        PsiTypeCodeFragment[] thrownExceptionsFragments = this.myExceptionsTableModel.getTypeCodeFragments();
        if (thrownExceptionsFragments.length > 0) {
            buffer.append("\n");
            buffer.append("throws\n");
            for (PsiTypeCodeFragment thrownExceptionsFragment : thrownExceptionsFragments) {
                String text = thrownExceptionsFragment.getText();
                buffer.append("    ");
                buffer.append(text);
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    @Override
    protected void doAction() {
        this.stopEditing();
        String message = this.validateAndCommitData();
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.incorrect.data"), (String)message, (String)"refactoring.changeSignature", (Project)this.myProject);
            return;
        }
        if (!this.checkMethodConflicts()) {
            return;
        }
        if (this.myMethodsToPropagateParameters != null && !this.mayPropagateParameters()) {
            Messages.showWarningDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.parameters.wont.propagate"), (String)ChangeSignatureHandler.REFACTORING_NAME);
            this.myMethodsToPropagateParameters = null;
        }
        if (this.myMethodsToPropagateExceptions != null && !this.mayPropagateExceptions()) {
            Messages.showWarningDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.exceptions.wont.propagate"), (String)ChangeSignatureHandler.REFACTORING_NAME);
            this.myMethodsToPropagateExceptions = null;
        }
        this.invokeRefactoring(new ChangeSignatureProcessor(this.getProject(), this.myMethod, this.isGenerateDelegate(), this.getVisibility(), this.getMethodName(), this.getReturnType(), this.getParameters(), this.getExceptions(), this.myMethodsToPropagateParameters, this.myMethodsToPropagateExceptions));
    }

    private String validateAndCommitData() {
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String name = this.getMethodName();
        if (!JavaPsiFacade.getInstance((Project)manager.getProject()).getNameHelper().isIdentifier(name)) {
            return RefactoringMessageUtil.getIncorrectIdentifierMessage(name);
        }
        if (!this.myMethod.isConstructor()) {
            try {
                this.myReturnTypeCodeFragment.getType();
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                this.myReturnTypeField.requestFocus();
                return RefactoringBundle.message((String)"changeSignature.wrong.return.type", (Object[])new Object[]{this.myReturnTypeCodeFragment.getText()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                this.myReturnTypeField.requestFocus();
                return RefactoringBundle.message((String)"changeSignature.no.return.type");
            }
        }
        List<PsiTypeCodeFragment> codeFraments = this.myParametersTableModel.getCodeFraments();
        List<JavaCodeFragment> defaultValueFraments = this.myParametersTableModel.getDefaultValueFraments();
        ParameterInfoImpl[] parameterInfos = this.myParametersTableModel.getParameters();
        int newParametersNumber = parameterInfos.length;
        LOG.assertTrue(codeFraments.size() == newParametersNumber);
        for (int i = 0; i < newParametersNumber; ++i) {
            PsiType type;
            ParameterInfoImpl info = parameterInfos[i];
            PsiTypeCodeFragment psiCodeFragment = codeFraments.get(i);
            PsiCodeFragment defaultValueFragment = (PsiCodeFragment)defaultValueFraments.get(i);
            if (!JavaPsiFacade.getInstance((Project)manager.getProject()).getNameHelper().isIdentifier(info.getName())) {
                return RefactoringMessageUtil.getIncorrectIdentifierMessage(info.getName());
            }
            try {
                type = psiCodeFragment.getType();
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return RefactoringBundle.message((String)"changeSignature.wrong.type.for.parameter", (Object[])new Object[]{psiCodeFragment.getText(), info.getName()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return RefactoringBundle.message((String)"changeSignature.no.type.for.parameter", (Object[])new Object[]{info.getName()});
            }
            info.setType(type);
            if (type instanceof PsiEllipsisType && i != newParametersNumber - 1) {
                return RefactoringBundle.message((String)"changeSignature.vararg.not.last");
            }
            if (info.oldParameterIndex >= 0) continue;
            String def = info.defaultValue = defaultValueFragment.getText();
            def = def.trim();
            if (type instanceof PsiEllipsisType) continue;
            if (def.length() == 0) {
                return RefactoringBundle.message((String)"changeSignature.no.default.value", (Object[])new Object[]{info.getName()});
            }
            try {
                factory.createExpressionFromText(info.defaultValue, null);
                continue;
            }
            catch (IncorrectOperationException e) {
                return e.getMessage();
            }
        }
        ThrownExceptionInfo[] exceptionInfos = this.myExceptionsTableModel.getThrownExceptions();
        PsiTypeCodeFragment[] typeCodeFragments = this.myExceptionsTableModel.getTypeCodeFragments();
        for (int i = 0; i < exceptionInfos.length; ++i) {
            ThrownExceptionInfo exceptionInfo = exceptionInfos[i];
            PsiTypeCodeFragment typeCodeFragment = typeCodeFragments[i];
            try {
                PsiType type = typeCodeFragment.getType();
                if (!(type instanceof PsiClassType)) {
                    return RefactoringBundle.message((String)"changeSignature.wrong.type.for.exception", (Object[])new Object[]{typeCodeFragment.getText()});
                }
                PsiClassType throwable = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Throwable", type.getResolveScope());
                if (!throwable.isAssignableFrom(type)) {
                    return RefactoringBundle.message((String)"changeSignature.not.throwable.type", (Object[])new Object[]{typeCodeFragment.getText()});
                }
                exceptionInfo.setType((PsiClassType)type);
                continue;
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return RefactoringBundle.message((String)"changeSignature.wrong.type.for.exception", (Object[])new Object[]{typeCodeFragment.getText()});
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return RefactoringBundle.message((String)"changeSignature.no.type.for.exception");
            }
        }
        return null;
    }

    private boolean checkMethodConflicts() {
        try {
            ParameterInfoImpl[] parameters;
            PsiManager manager = PsiManager.getInstance((Project)this.myProject);
            for (ParameterInfoImpl info : parameters = this.getParameters()) {
                int ret;
                PsiType parameterType = info.createType((PsiElement)this.myMethod, manager);
                if (RefactoringUtil.isResolvableType(parameterType) || (ret = Messages.showOkCancelDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.cannot.resolve.type", (Object[])new Object[]{info.getTypeText()}), (String)ChangeSignatureHandler.REFACTORING_NAME, (Icon)Messages.getErrorIcon())) == 0) continue;
                return false;
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return true;
    }

    private void stopEditing() {
        TableUtil.stopEditing((JTable)this.myParametersTable);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.changeSignature");
    }

    private class MyNameTableCellEditor
    extends StringTableCellEditor {
        public MyNameTableCellEditor(Project project) {
            super(project);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            final EditorTextField textField = (EditorTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            textField.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int column = ChangeSignatureDialog.this.myParametersTable.convertColumnIndexToModel(ChangeSignatureDialog.this.myParametersTable.getEditingColumn());
                    if (column == 1) {
                        int row = ChangeSignatureDialog.this.myParametersTable.getEditingRow();
                        PsiType type = ChangeSignatureDialog.this.myParametersTableModel.getTypeByRow(row);
                        if (type != null) {
                            ChangeSignatureDialog.this.completeVariable(textField, type);
                        }
                    }
                }
            }, KeyStroke.getKeyStroke(32, 2), 2);
            return textField;
        }
    }

    private class MyCellRenderer
    extends ColoredTableCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return;
            }
            if (!ChangeSignatureDialog.this.myParametersTableModel.isCellEditable(row, ChangeSignatureDialog.this.myParametersTable.convertColumnIndexToModel(column))) {
                this.setBackground(this.getBackground().darker());
            }
            this.append((String)value, new SimpleTextAttributes(0, null));
        }
    }
}

