/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.IdeEventQueue;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRefactoringAction
extends AnAction {
    protected abstract boolean isAvailableInEditorOnly();

    protected abstract boolean isEnabledOnElements(PsiElement[] var1);

    protected boolean isAvailableOnElementInEditor(PsiElement element, Editor editor) {
        return true;
    }

    @Nullable
    protected abstract RefactoringActionHandler getHandler(DataContext var1);

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        PsiElement[] elements = BaseRefactoringAction.getPsiElementArray(dataContext);
        int eventCount = IdeEventQueue.getInstance().getEventCount();
        RefactoringActionHandler handler = this.getHandler(dataContext);
        if (handler == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.symbol.to.refactor")), (String)RefactoringBundle.getCannotRefactorMessage(null), null);
            return;
        }
        IdeEventQueue.getInstance().setEventCount(eventCount);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            DaemonCodeAnalyzer.getInstance((Project)project).autoImportReferenceAtCursor(editor, file);
            handler.invoke(project, editor, file, dataContext);
        } else {
            handler.invoke(project, elements, dataContext);
        }
    }

    protected boolean isEnabledOnDataContext(DataContext dataContext) {
        return false;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setVisible(true);
        presentation.setEnabled(true);
        DataContext dataContext = e.getDataContext();
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            BaseRefactoringAction.disableAction(e);
            return;
        }
        if (this.isHidden()) {
            e.getPresentation().setVisible(false);
            return;
        }
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (file != null && (file instanceof PsiCompiledElement || !this.isAvailableForFile(file))) {
            BaseRefactoringAction.disableAction(e);
            return;
        }
        if (editor == null) {
            boolean isEnabled;
            if (this.isAvailableInEditorOnly()) {
                BaseRefactoringAction.disableAction(e);
                return;
            }
            PsiElement[] elements = BaseRefactoringAction.getPsiElementArray(dataContext);
            boolean bl = isEnabled = this.isEnabledOnDataContext(dataContext) || elements.length != 0 && this.isEnabledOnElements(elements);
            if (!isEnabled) {
                BaseRefactoringAction.disableAction(e);
            }
        } else {
            boolean isEnabled;
            PsiElement element = (PsiElement)e.getData(LangDataKeys.PSI_ELEMENT);
            if (element == null || !this.isAvailableForLanguage(element.getLanguage())) {
                if (file == null) {
                    BaseRefactoringAction.disableAction(e);
                    return;
                }
                element = BaseRefactoringAction.getElementAtCaret(editor, file);
            }
            boolean bl = isEnabled = element != null && !(element instanceof SyntheticElement) && this.isAvailableForLanguage(PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project)) && this.isAvailableOnElementInEditor(element, editor);
            if (!isEnabled) {
                BaseRefactoringAction.disableAction(e);
            }
        }
    }

    protected boolean isHidden() {
        return false;
    }

    public static PsiElement getElementAtCaret(Editor editor, PsiFile file) {
        int offset = BaseRefactoringAction.fixCaretOffset(editor);
        PsiElement element = file.findElementAt(offset);
        if (element == null && offset == file.getTextLength()) {
            element = file.findElementAt(offset - 1);
        }
        if (element instanceof PsiWhiteSpace) {
            element = file.findElementAt(element.getTextRange().getStartOffset() - 1);
        }
        return element;
    }

    private static int fixCaretOffset(Editor editor) {
        int caret = editor.getCaretModel().getOffset();
        if (editor.getSelectionModel().hasSelection() && !editor.getSelectionModel().hasBlockSelection() && caret == editor.getSelectionModel().getSelectionEnd()) {
            return Math.max(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd() - 1);
        }
        return caret;
    }

    private static void disableAction(AnActionEvent e) {
        e.getPresentation().setEnabled(false);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(false);
        }
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language.isKindOf(StdFileTypes.JAVA.getLanguage());
    }

    protected boolean isAvailableForFile(PsiFile file) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement[] getPsiElementArray(DataContext dataContext) {
        PsiElement[] psiElementArray;
        PsiElement element;
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if ((psiElements == null || psiElements.length == 0) && (element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext)) != null) {
            psiElements = new PsiElement[]{element};
        }
        if (psiElements == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/actions/BaseRefactoringAction.getPsiElementArray must not return null");
            return psiElementArray;
        }
        ArrayList<PsiElement> filtered = null;
        for (PsiElement element2 : psiElements) {
            if (!(element2 instanceof SyntheticElement)) continue;
            if (filtered == null) {
                filtered = new ArrayList<PsiElement>(Arrays.asList(element2));
            }
            filtered.remove(element2);
        }
        psiElementArray = filtered == null ? psiElements : filtered.toArray(new PsiElement[filtered.size()]);
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/refactoring/actions/BaseRefactoringAction.getPsiElementArray must not return null");
    }
}

