/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.resolve;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodResolveHelper {
    private final Set<MethodSignature> myDuplicates = new THashSet();
    private final MethodCandidatesProcessor myProcessor;
    @Nullable
    private final PsiType[] myParameterTypes;

    public JavaMethodResolveHelper(final PsiElement argumentList, final @Nullable PsiType[] parameterTypes) {
        this.myParameterTypes = parameterTypes;
        PsiConflictResolver resolver = parameterTypes == null ? DuplicateConflictResolver.INSTANCE : new JavaMethodsConflictResolver(argumentList, parameterTypes);
        this.myProcessor = new MethodResolverProcessor(argumentList, new PsiConflictResolver[]{resolver}){

            @Override
            protected MethodCandidateInfo createCandidateInfo(PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem, boolean accessible) {
                return new MethodCandidateInfo((PsiElement)method, substitutor, !accessible, staticProblem, argumentList, this.myCurrentFileContext, parameterTypes, PsiType.EMPTY_ARRAY);
            }

            @Override
            protected boolean isAccepted(PsiMethod candidate) {
                return !candidate.isConstructor();
            }
        };
    }

    public void addMethod(PsiMethod method, PsiSubstitutor substitutor, boolean staticError) {
        if (this.myDuplicates.add(method.getSignature(substitutor))) {
            this.myProcessor.addMethod(method, substitutor, staticError);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ErrorType getResolveError() {
        boolean hasNulls;
        ErrorType errorType;
        block12: {
            PsiParameter[] parameters;
            block13: {
                block11: {
                    CandidateInfo[] candidates = this.myProcessor.getCandidates();
                    if (candidates.length != 1) {
                        errorType = ErrorType.RESOLVE;
                        if (errorType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/resolve/JavaMethodResolveHelper.getResolveError must not return null");
                        return errorType;
                    }
                    if (!candidates[0].isStaticsScopeCorrect()) {
                        errorType = ErrorType.STATIC;
                        if (errorType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/resolve/JavaMethodResolveHelper.getResolveError must not return null");
                        return errorType;
                    }
                    MethodCandidateInfo info = (MethodCandidateInfo)candidates[0];
                    if (this.myParameterTypes == null) {
                        errorType = ErrorType.NONE;
                        if (errorType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/resolve/JavaMethodResolveHelper.getResolveError must not return null");
                        return errorType;
                    }
                    if (info.isApplicable()) break block11;
                    hasNulls = false;
                    parameters = info.getElement().getParameterList().getParameters();
                    if (this.myParameterTypes.length != parameters.length) break block12;
                    break block13;
                }
                errorType = ErrorType.NONE;
                if (errorType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/resolve/JavaMethodResolveHelper.getResolveError must not return null");
                return errorType;
            }
            for (int i = 0; i < this.myParameterTypes.length; ++i) {
                PsiType type = this.myParameterTypes[i];
                if (type == null) {
                    hasNulls = true;
                    continue;
                }
                if (parameters[i].getType().isAssignableFrom(type)) continue;
                errorType = ErrorType.RESOLVE;
                if (errorType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/resolve/JavaMethodResolveHelper.getResolveError must not return null");
                return errorType;
            }
        }
        if ((errorType = hasNulls ? ErrorType.NONE : ErrorType.RESOLVE) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/resolve/JavaMethodResolveHelper.getResolveError must not return null");
        return errorType;
    }

    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        this.myProcessor.handleEvent(event, associated);
    }

    public Collection<JavaMethodCandidateInfo> getMethods() {
        return ContainerUtil.mapNotNull((Object[])this.myProcessor.getResult(), (Function)new Function<JavaResolveResult, JavaMethodCandidateInfo>(){

            public JavaMethodCandidateInfo fun(JavaResolveResult javaResolveResult) {
                return new JavaMethodCandidateInfo((PsiMethod)javaResolveResult.getElement(), javaResolveResult.getSubstitutor());
            }
        });
    }

    public static enum ErrorType {
        NONE,
        STATIC,
        RESOLVE;

    }
}

