/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.impl.events.XmlDocumentChangedImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlNSDescriptorSequence;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlDocumentImpl
extends XmlElementImpl
implements XmlDocument {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlDocumentImpl");
    private volatile XmlProlog myProlog;
    private volatile XmlTag myRootTag;
    private ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>> myDefaultDescriptorsCacheStrict = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>> myDefaultDescriptorsCacheNotStrict = new ConcurrentHashMap();

    public XmlDocumentImpl() {
        this(XmlElementType.XML_DOCUMENT);
    }

    protected XmlDocumentImpl(IElementType type) {
        super(type);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlDocumentImpl.accept must not be null");
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlDocument((XmlDocument)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XmlElementType.XML_PROLOG) {
            return 225;
        }
        if (i == XmlElementType.XML_TAG) {
            return 241;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlProlog getProlog() {
        XmlProlog prolog = this.myProlog;
        if (prolog == null) {
            XmlDocumentImpl xmlDocumentImpl = this;
            synchronized (xmlDocumentImpl) {
                prolog = this.myProlog;
                if (prolog == null) {
                    this.myProlog = prolog = (XmlProlog)this.findElementByTokenType(XmlElementType.XML_PROLOG);
                }
            }
        }
        return this.myProlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlTag getRootTag() {
        XmlTag rootTag = this.myRootTag;
        if (rootTag == null) {
            XmlDocumentImpl xmlDocumentImpl = this;
            synchronized (xmlDocumentImpl) {
                rootTag = this.myRootTag;
                if (rootTag == null) {
                    this.myRootTag = rootTag = (XmlTag)this.findElementByTokenType(XmlElementType.XML_TAG);
                }
            }
        }
        return this.myRootTag;
    }

    public XmlNSDescriptor getRootTagNSDescriptor() {
        XmlTag rootTag = this.getRootTag();
        return rootTag != null ? rootTag.getNSDescriptor(rootTag.getNamespace(), false) : null;
    }

    @Override
    public void clearCaches() {
        this.myDefaultDescriptorsCacheStrict.clear();
        this.myDefaultDescriptorsCacheNotStrict.clear();
        this.myProlog = null;
        this.myRootTag = null;
        super.clearCaches();
    }

    public XmlNSDescriptor getDefaultNSDescriptor(final String namespace, final boolean strict) {
        ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>> defaultDescriptorsCache = strict ? this.myDefaultDescriptorsCacheStrict : this.myDefaultDescriptorsCacheNotStrict;
        PsiCachedValueImpl<XmlNSDescriptor> cachedValue = (PsiCachedValueImpl<XmlNSDescriptor>)defaultDescriptorsCache.get((Object)namespace);
        if (cachedValue == null) {
            cachedValue = new PsiCachedValueImpl<XmlNSDescriptor>(this.getManager(), new CachedValueProvider<XmlNSDescriptor>(){

                public CachedValueProvider.Result<XmlNSDescriptor> compute() {
                    XmlNSDescriptor defaultNSDescriptorInner = XmlDocumentImpl.this.getDefaultNSDescriptorInner(namespace, strict);
                    if (XmlDocumentImpl.this.isGeneratedFromDtd(defaultNSDescriptorInner)) {
                        return new CachedValueProvider.Result((Object)defaultNSDescriptorInner, new Object[]{XmlDocumentImpl.this, ExternalResourceManager.getInstance()});
                    }
                    return new CachedValueProvider.Result((Object)defaultNSDescriptorInner, new Object[]{defaultNSDescriptorInner != null ? defaultNSDescriptorInner.getDependences() : ExternalResourceManager.getInstance()});
                }
            });
            defaultDescriptorsCache.put((Object)namespace, cachedValue);
        }
        return (XmlNSDescriptor)cachedValue.getValue();
    }

    private boolean isGeneratedFromDtd(XmlNSDescriptor defaultNSDescriptorInner) {
        if (defaultNSDescriptorInner == null) {
            return false;
        }
        XmlFile descriptorFile = defaultNSDescriptorInner.getDescriptorFile();
        if (descriptorFile == null) {
            return false;
        }
        String otherName = XmlUtil.getContainingFile(this).getName() + ".dtd";
        return descriptorFile.getName().equals(otherName);
    }

    private XmlNSDescriptor getDefaultNSDescriptorInner(String namespace, boolean strict) {
        XmlFile xmlFile;
        XmlNSDescriptor descr;
        XmlFile containingFile = XmlUtil.getContainingFile(this);
        XmlProlog prolog = this.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        boolean dtdUriFromDocTypeIsNamespace = false;
        if ("http://www.w3.org/1999/html".equals(namespace)) {
            XmlNSDescriptor nsDescriptor;
            XmlNSDescriptor xmlNSDescriptor = nsDescriptor = doctype != null ? this.getNsDescriptorFormDocType(doctype, containingFile) : null;
            if (nsDescriptor == null) {
                nsDescriptor = this.getDefaultNSDescriptor("http://www.w3.org/1999/xhtml", false);
            }
            return new HtmlNSDescriptorImpl(nsDescriptor);
        }
        if (namespace != null && namespace != "") {
            if (doctype == null || !namespace.equals(XmlUtil.getDtdUri(doctype))) {
                XmlDocument document;
                XmlFile xmlFile2;
                boolean documentIsSchemaThatDefinesNs = namespace.equals(XmlUtil.getTargetSchemaNsFromTag(this.getRootTag()));
                XmlFile xmlFile3 = xmlFile2 = documentIsSchemaThatDefinesNs ? containingFile : XmlUtil.findNamespace((PsiFile)containingFile, namespace);
                if (xmlFile2 != null && (document = xmlFile2.getDocument()) != null) {
                    return (XmlNSDescriptor)document.getMetaData();
                }
            } else {
                dtdUriFromDocTypeIsNamespace = true;
            }
        }
        if (strict && !dtdUriFromDocTypeIsNamespace) {
            return null;
        }
        if (doctype != null && (descr = this.getNsDescriptorFormDocType(doctype, containingFile)) != null) {
            return XmlExtension.getExtension((PsiFile)containingFile).getDescriptorFromDoctype(containingFile, descr);
        }
        if (strict) {
            return null;
        }
        if (namespace == "" && (xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, namespace)) != null) {
            return (XmlNSDescriptor)xmlFile.getDocument().getMetaData();
        }
        try {
            PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(containingFile.getName() + ".dtd", XmlUtil.generateDocumentDTD(this, false));
            if (fileFromText instanceof XmlFile) {
                return (XmlNSDescriptor)((XmlFile)fileFromText).getDocument().getMetaData();
            }
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (RuntimeException ignored) {
            // empty catch block
        }
        return null;
    }

    private XmlNSDescriptor getNsDescriptorFormDocType(XmlDoctype doctype, XmlFile containingFile) {
        String dtdUri;
        XmlElementDescriptor[] rootElementsDescriptors;
        XmlNSDescriptor descr = null;
        if (doctype.getMarkupDecl() != null && (rootElementsDescriptors = (descr = (XmlNSDescriptor)doctype.getMarkupDecl().getMetaData()).getRootElementsDescriptors((XmlDocument)this)).length == 0) {
            descr = null;
        }
        if ((dtdUri = XmlUtil.getDtdUri(doctype)) != null && dtdUri.length() > 0) {
            XmlNSDescriptor descr1;
            XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, dtdUri);
            XmlNSDescriptor xmlNSDescriptor = descr1 = xmlFile == null ? null : (XmlNSDescriptor)xmlFile.getDocument().getMetaData();
            if (descr != null && descr1 != null) {
                descr = new XmlNSDescriptorSequence(new XmlNSDescriptor[]{descr, descr1});
            } else if (descr1 != null) {
                descr = descr1;
            }
        }
        return descr;
    }

    @Override
    public Object clone() {
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>((Map<String, CachedValue<XmlNSDescriptor>>)this.myDefaultDescriptorsCacheStrict);
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>((Map<String, CachedValue<XmlNSDescriptor>>)this.myDefaultDescriptorsCacheNotStrict);
        XmlDocumentImpl copy = (XmlDocumentImpl)super.clone();
        this.updateSelfDependentDtdDescriptors(copy, cacheStrict, cacheNotStrict);
        return copy;
    }

    @Override
    public PsiElement copy() {
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>((Map<String, CachedValue<XmlNSDescriptor>>)this.myDefaultDescriptorsCacheStrict);
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>((Map<String, CachedValue<XmlNSDescriptor>>)this.myDefaultDescriptorsCacheNotStrict);
        XmlDocumentImpl copy = (XmlDocumentImpl)super.copy();
        this.updateSelfDependentDtdDescriptors(copy, cacheStrict, cacheNotStrict);
        return copy;
    }

    private void updateSelfDependentDtdDescriptors(XmlDocumentImpl copy, HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict, HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict) {
        XmlNSDescriptor nsDescriptor;
        copy.myDefaultDescriptorsCacheNotStrict = new ConcurrentHashMap();
        copy.myDefaultDescriptorsCacheStrict = new ConcurrentHashMap();
        for (Map.Entry<String, CachedValue<XmlNSDescriptor>> e : cacheStrict.entrySet()) {
            if (!e.getValue().hasUpToDateValue() || this.isGeneratedFromDtd(nsDescriptor = (XmlNSDescriptor)e.getValue().getValue())) continue;
            copy.myDefaultDescriptorsCacheStrict.put((Object)e.getKey(), e.getValue());
        }
        for (Map.Entry<String, CachedValue<XmlNSDescriptor>> e : cacheNotStrict.entrySet()) {
            if (!e.getValue().hasUpToDateValue() || this.isGeneratedFromDtd(nsDescriptor = (XmlNSDescriptor)e.getValue().getValue())) continue;
            copy.myDefaultDescriptorsCacheNotStrict.put((Object)e.getKey(), e.getValue());
        }
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta(this);
    }

    public void dumpStatistics() {
        Object[] keys;
        System.out.println("Statistics:");
        final TObjectIntHashMap map = new TObjectIntHashMap();
        XmlRecursiveElementVisitor psiRecursiveElementVisitor = new XmlRecursiveElementVisitor(){
            @NonNls
            private static final String TOKENS_KEY = "Tokens";
            @NonNls
            private static final String ELEMENTS_KEY = "Elements";

            public void visitXmlToken(XmlToken token) {
                this.inc(TOKENS_KEY);
            }

            public void visitElement(PsiElement element) {
                this.inc(ELEMENTS_KEY);
                super.visitElement(element);
            }

            private void inc(String key) {
                map.put((Object)key, map.get((Object)key) + 1);
            }
        };
        this.accept((PsiElementVisitor)psiRecursiveElementVisitor);
        for (Object key : keys = map.keys()) {
            System.out.println(key + ": " + map.get(key));
        }
    }

    @Override
    public TreeElement addInternal(final TreeElement first, final ASTNode last, final ASTNode anchor, final Boolean before) {
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        final TreeElement[] holder = new TreeElement[1];
        try {
            model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

                public PomModelEvent runInner() {
                    holder[0] = XmlDocumentImpl.super.addInternal(first, last, anchor, before);
                    return XmlDocumentChangedImpl.createXmlDocumentChanged(model, XmlDocumentImpl.this);
                }
            });
        }
        catch (IncorrectOperationException ignored) {
            // empty catch block
        }
        return holder[0];
    }

    @Override
    public void deleteChildInternal(final @NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlDocumentImpl.deleteChildInternal must not be null");
        }
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        try {
            model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

                public PomModelEvent runInner() {
                    XmlDocumentImpl.super.deleteChildInternal(child);
                    return XmlDocumentChangedImpl.createXmlDocumentChanged(model, XmlDocumentImpl.this);
                }
            });
        }
        catch (IncorrectOperationException ignored) {
            // empty catch block
        }
    }

    @Override
    public void replaceChildInternal(final @NotNull ASTNode child, final @NotNull TreeElement newElement) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlDocumentImpl.replaceChildInternal must not be null");
        }
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlDocumentImpl.replaceChildInternal must not be null");
        }
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        try {
            model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

                public PomModelEvent runInner() {
                    XmlDocumentImpl.super.replaceChildInternal(child, newElement);
                    return XmlDocumentChangedImpl.createXmlDocumentChanged(model, XmlDocumentImpl.this);
                }
            });
        }
        catch (IncorrectOperationException ignored) {
            // empty catch block
        }
    }
}

