/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiSwitchStatementImpl
extends CompositePsiElement
implements PsiSwitchStatement,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiSwitchStatementImpl");

    public PsiSwitchStatementImpl() {
        super(SWITCH_STATEMENT);
    }

    public PsiExpression getExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(43);
    }

    public PsiCodeBlock getBody() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(44);
    }

    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 42: {
                return this.findChildByType(SWITCH_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 43: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 44: 
        }
        return this.findChildByType((IElementType)CODE_BLOCK);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == SWITCH_KEYWORD) {
            return 42;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 43;
        }
        if (child.getElementType() == CODE_BLOCK) {
            return 44;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiSwitchStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSwitchStatement((PsiSwitchStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiSwitchStatement";
    }
}

