/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiLabeledStatementImpl
extends CompositePsiElement
implements PsiLabeledStatement,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiLabeledStatementImpl");

    public PsiLabeledStatementImpl() {
        super(LABELED_STATEMENT);
    }

    @NotNull
    public PsiIdentifier getLabelIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.findChildByRoleAsPsiElement(93);
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.getLabelIdentifier must not return null");
        }
        return psiIdentifier;
    }

    public PsiStatement getStatement() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(94);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 94: {
                return this.findChildByType(STATEMENT_BIT_SET);
            }
            case 87: {
                return this.findChildByType(COLON);
            }
            case 93: 
        }
        return this.getFirstChildNode();
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == IDENTIFIER) {
            return 93;
        }
        if (i == COLON) {
            return 87;
        }
        if (STATEMENT_BIT_SET.contains(child.getElementType())) {
            return 94;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLabeledStatement((PsiLabeledStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiLabeledStatement";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.processDeclarations must not be null");
        }
        if (lastParent != null && lastParent.getParent() != this) {
            PsiElement[] children;
            for (PsiElement aChildren : children = this.getChildren()) {
                if (aChildren.processDeclarations(processor, state, null, place)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return this.getLabelIdentifier().getText();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getLabelIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this);
        if (localSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.getUseScope must not return null");
        }
        return localSearchScope;
    }
}

