/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.PsiElementArrayConstructor;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class CompositePsiElement
extends CompositeElement
implements PsiElement,
NavigationItem {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.CompositePsiElement");
    protected static int ourHC = 0;

    protected CompositePsiElement(IElementType type) {
        super(type);
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(null, PsiElementArrayConstructor.PSI_ELEMENT_ARRAY_CONSTRUCTOR);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositePsiElement.getChildren must not return null");
        }
        return psiElementArray;
    }

    public PsiElement getFirstChild() {
        TreeElement node = this.getFirstChildNode();
        return node != null ? node.getPsi() : null;
    }

    public PsiElement getLastChild() {
        TreeElement node = this.getLastChildNode();
        return node != null ? node.getPsi() : null;
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.acceptChildren must not be null");
        }
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor);
        }
    }

    public PsiElement getParent() {
        CompositeElement parentNode = this.getTreeParent();
        return parentNode != null ? parentNode.getPsi() : null;
    }

    public PsiElement getNextSibling() {
        TreeElement node = this.getTreeNext();
        return node != null ? node.getPsi() : null;
    }

    public PsiElement getPrevSibling() {
        TreeElement node = this.getTreePrev();
        return node != null ? node.getPsi() : null;
    }

    public PsiFile getContainingFile() {
        PsiFile file = SharedImplUtil.getContainingFile(this);
        if (file == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return file;
    }

    public PsiElement findElementAt(int offset) {
        LeafElement leaf = this.findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(leaf);
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositePsiElement.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.add must not be null");
        }
        return this.addInnerBefore(element, null);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.addBefore must not be null");
        }
        return this.addInnerBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.addAfter must not be null");
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        return ChangeUtil.decodeInformation(treeElement).getPsi();
    }

    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.checkAdd must not be null");
        }
        CheckUtil.checkWritable(this);
    }

    public final PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    public final PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.addRangeBefore must not be null");
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    public final PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null, (Object)("Parent not found for " + this));
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this);
        LOG.assertTrue(lastElement.getTreeParent() == this);
        CodeEditUtil.removeChildren(this, firstElement, lastElement);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.replace must not be null");
        }
        LOG.assertTrue(this.getTreeParent() != null);
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        this.getTreeParent().replaceChildInternal(this, elementCopy);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        PsiElement result = SourceTreeToPsiMap.treeElementToPsi(elementCopy);
        this.invalidate();
        return result;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.accept must not be null");
        }
        visitor.visitElement((PsiElement)this);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositePsiElement.processDeclarations must not be null");
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        CompositePsiElement compositePsiElement = this;
        if (compositePsiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositePsiElement.getNavigationElement must not return null");
        }
        return compositePsiElement;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getManager().getFileManager().getResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositePsiElement.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = this.getManager().getFileManager().getUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositePsiElement.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public String getName() {
        return null;
    }

    public void navigate(boolean requestFocus) {
        EditSourceUtil.getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return EditSourceUtil.canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public FileStatus getFileStatus() {
        if (!this.isPhysical()) {
            return FileStatus.NOT_CHANGED;
        }
        PsiFile contFile = this.getContainingFile();
        if (contFile == null) {
            return FileStatus.NOT_CHANGED;
        }
        VirtualFile vFile = contFile.getVirtualFile();
        return vFile != null ? FileStatusManager.getInstance((Project)this.getProject()).getStatus(vFile) : FileStatus.NOT_CHANGED;
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositePsiElement.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositePsiElement.getLanguage must not return null");
        }
        return language;
    }

    @NotNull
    public ASTNode getNode() {
        CompositePsiElement compositePsiElement = this;
        if (compositePsiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositePsiElement.getNode must not return null");
        }
        return compositePsiElement;
    }

    @Override
    public PsiElement getPsi() {
        ProgressManager.checkCanceled();
        return this;
    }

    private PsiElement addInnerBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        if (treeElement != null) {
            return ChangeUtil.decodeInformation(treeElement).getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

