/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.QuickFixProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.AddXsiSchemaLocationForExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.FetchExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.IgnoreExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ManuallySetupExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URIReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLReference
implements PsiReference,
QuickFixProvider,
EmptyResolveMessageProvider {
    @NonNls
    private static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    private final PsiElement myElement;
    private TextRange myRange;
    private boolean mySoft;
    private boolean myIncorrectResourceMapped;

    public URLReference(PsiElement element) {
        this.myElement = element;
    }

    public URLReference(PsiElement element, @Nullable TextRange range, boolean soft) {
        this.myElement = element;
        this.myRange = range;
        this.mySoft = soft;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange != null ? this.myRange : ElementManipulators.getValueTextRange((PsiElement)this.myElement);
    }

    @Nullable
    public PsiElement resolve() {
        PsiFile file;
        this.myIncorrectResourceMapped = false;
        final String canonicalText = this.getCanonicalText();
        if (canonicalText.length() == 0) {
            XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlAttribute.class);
            if (attr != null && attr.isNamespaceDeclaration() && attr.getNamespacePrefix().length() == 0 || ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
                return this.myElement;
            }
            return null;
        }
        if (ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
            return this.myElement;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
        if (tag != null && canonicalText.equals(tag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME))) {
            return tag;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        if (tag != null && tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance") == null && (file = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, tag.getAttributeValue("version"))) != null) {
            return file;
        }
        if (containingFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)containingFile).getDocument();
            assert (document != null);
            XmlTag rootTag = document.getRootTag();
            if (rootTag == null) {
                return ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, null);
            }
            XmlNSDescriptor nsDescriptor = rootTag.getNSDescriptor(canonicalText, true);
            if (nsDescriptor != null) {
                return nsDescriptor.getDescriptorFile();
            }
            String url = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, this.myElement.getProject());
            if (!url.equals(canonicalText)) {
                this.myIncorrectResourceMapped = true;
                return null;
            }
            if (tag == rootTag && tag.getNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
                for (XmlTag t : tag.getSubTags()) {
                    String name = t.getLocalName();
                    if ("import".equals(name)) {
                        if (!canonicalText.equals(t.getAttributeValue("namespace"))) continue;
                        return t;
                    }
                    if (!"include".equals(name) && !"redefine".equals(name) && !"annotation".equals(name)) break;
                }
            }
            final PsiElement[] result = new PsiElement[1];
            URLReference.processWsdlSchemas(rootTag, new Processor<XmlTag>(){

                public boolean process(XmlTag t) {
                    if (canonicalText.equals(t.getAttributeValue(URLReference.TARGET_NAMESPACE_ATTR_NAME))) {
                        result[0] = t;
                        return false;
                    }
                    return true;
                }
            });
            return result[0];
        }
        return null;
    }

    public String getCanonicalText() {
        String text = this.myElement.getText();
        if (text.length() > 1) {
            return this.myRange == null ? text.substring(1, text.length() - 1) : this.myRange.substring(text);
        }
        return "";
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        TextRange textRangeInElement = this.getRangeInElement();
        PsiElement elementToChange = this.myElement.findElementAt(textRangeInElement.getStartOffset());
        assert (elementToChange != null);
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)elementToChange);
        assert (manipulator != null);
        int offsetFromStart = this.myElement.getTextRange().getStartOffset() + textRangeInElement.getStartOffset() - elementToChange.getTextOffset();
        manipulator.handleContentChange(elementToChange, new TextRange(offsetFromStart, offsetFromStart + textRangeInElement.getLength()), newElementName);
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference.bindToElement must not be null");
        }
        assert (element instanceof PsiFile);
        if (!URIReferenceProvider.isUrlText(this.getCanonicalText(), element.getProject())) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            assert (virtualFile != null);
            this.handleElementRename(VfsUtil.fixIDEAUrl((String)virtualFile.getPresentableUrl()));
        }
        return this.myElement;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        XmlFile file = (XmlFile)this.myElement.getContainingFile();
        HashSet list = new HashSet();
        for (XmlSchemaProvider provider : (XmlSchemaProvider[])Extensions.getExtensions((ExtensionPointName)XmlSchemaProvider.EP_NAME)) {
            if (!provider.isAvailable(file)) continue;
            list.addAll(provider.getAvailableNamespaces(file, null));
        }
        if (!list.isEmpty()) {
            objectArray = ArrayUtil.toObjectArray(list);
            if (objectArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference.getVariants must not return null");
            return objectArray;
        }
        Object[] resourceUrls = ExternalResourceManager.getInstance().getResourceUrls(null, true);
        XmlDocument document = file.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        final ArrayList additionalNs = new ArrayList();
        if (rootTag != null) {
            URLReference.processWsdlSchemas(rootTag, new Processor<XmlTag>(){

                public boolean process(XmlTag xmlTag) {
                    String s = xmlTag.getAttributeValue(URLReference.TARGET_NAMESPACE_ATTR_NAME);
                    if (s != null) {
                        additionalNs.add(s);
                    }
                    return true;
                }
            });
        }
        resourceUrls = (String[])ArrayUtil.mergeArrays((Object[])resourceUrls, (Object[])ArrayUtil.toStringArray(additionalNs), String.class);
        objectArray = resourceUrls;
        if (resourceUrls != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference.getVariants must not return null");
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    public void registerQuickfix(HighlightInfo info, PsiReference reference) {
        QuickFixAction.registerQuickFixAction(info, (IntentionAction)new FetchExtResourceAction());
        QuickFixAction.registerQuickFixAction(info, (IntentionAction)new ManuallySetupExtResourceAction());
        QuickFixAction.registerQuickFixAction(info, (IntentionAction)new IgnoreExtResourceAction());
        PsiElement parentElement = reference.getElement().getParent();
        if (parentElement instanceof XmlAttribute && ((XmlAttribute)parentElement).isNamespaceDeclaration()) {
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)new AddXsiSchemaLocationForExtResourceAction());
        }
    }

    public String getUnresolvedMessagePattern() {
        return XmlErrorMessages.message(this.myIncorrectResourceMapped ? "registered.resource.is.not.recognized" : "uri.is.not.registered", new Object[0]);
    }

    public static void processWsdlSchemas(XmlTag rootTag, Processor<XmlTag> processor) {
        XmlTag subTag;
        if ("definitions".equals(rootTag.getLocalName()) && (subTag = rootTag.findFirstSubTag(rootTag.getNamespacePrefix() + ":" + "types")) != null) {
            XmlTag[] tags;
            for (XmlTag t : tags = subTag.findSubTags("xsd:schema")) {
                if (processor.process((Object)t)) continue;
                return;
            }
        }
    }
}

