/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.util.ReferenceSetBase;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PackageReferenceSet
extends ReferenceSetBase<PsiPackageReference> {
    public PackageReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet.<init> must not be null");
        }
        super(str, element, startInElement, '.');
    }

    @NotNull
    protected PsiPackageReference createReference(TextRange range, int index) {
        PsiPackageReference psiPackageReference = new PsiPackageReference(this, range, index);
        if (psiPackageReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PackageReferenceSet.createReference must not return null");
        }
        return psiPackageReference;
    }

    public Collection<PsiPackage> resolvePackageName(PsiPackage context, String packageName) {
        for (PsiPackage aPackage : context.getSubPackages()) {
            if (!Comparing.equal((String)aPackage.getName(), (String)packageName)) continue;
            return Collections.singleton(aPackage);
        }
        return Collections.emptyList();
    }

    public Collection<PsiPackage> resolvePackage() {
        PsiPackageReference packageReference = (PsiPackageReference)this.getLastReference();
        if (packageReference == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.map2List((Object[])packageReference.multiResolve(false), (Function)new NullableFunction<ResolveResult, PsiPackage>(){

            public PsiPackage fun(ResolveResult resolveResult) {
                return (PsiPackage)resolveResult.getElement();
            }
        });
    }
}

