/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;

public class FileReferenceCharFilter
extends CharFilter {
    @Override
    public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup) {
        PsiFile file = lookup.getPsiFile();
        if (file == null) {
            return null;
        }
        LookupElement item = lookup.getCurrentItem();
        if (item != null && item.getObject() instanceof PsiFileSystemItem) {
            if ('.' == c) {
                return CharFilter.Result.ADD_TO_PREFIX;
            }
            PsiReference reference = file.findReferenceAt(lookup.getEditor().getCaretModel().getOffset());
            if (reference instanceof FileReference) {
                return CharFilter.Result.HIDE_LOOKUP;
            }
            if (reference instanceof PsiMultiReference) {
                for (PsiReference psiReference : ((PsiMultiReference)reference).getReferences()) {
                    if (!(psiReference instanceof FileReference)) continue;
                    return CharFilter.Result.HIDE_LOOKUP;
                }
            }
        }
        return null;
    }
}

