/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.lexer.OldXmlLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.ParsingContext;
import com.intellij.psi.impl.source.parsing.TokenProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.intellij.xml.XmlBundle;
import java.util.HashSet;
import java.util.Set;

public class OldXmlParsing
implements XmlElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.xml.XmlParser");
    public static final TokenSet XML_WHITE_SPACE_OR_COMMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{XML_WHITE_SPACE, XML_COMMENT_START, XML_COMMENT_CHARACTERS, XML_COMMENT_END, XML_BAD_CHARACTER});
    public static final TokenSet XML_COMMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{XML_COMMENT_START, XML_COMMENT_CHARACTERS, XML_COMMENT_END});
    private final ParsingContext myContext;
    private int myLastTokenEnd = -1;

    public OldXmlParsing(ParsingContext context) {
        this.myContext = context;
    }

    public TreeElement parse(Lexer originalLexer, CharSequence buffer, int startOffset, int endOffset, PsiManager manager) {
        FilterLexer lexer = new FilterLexer(originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(XML_WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer, startOffset, endOffset);
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        CompositeElement root = ASTFactory.composite(XML_DOCUMENT);
        dummyRoot.rawAddChildren(root);
        root.rawAddChildren(this.parseProlog((Lexer)lexer));
        this.parseGenericXml((Lexer)lexer, root, new HashSet<String>());
        OldXmlParsing.insertMissingTokens(root, originalLexer, startOffset, endOffset, -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return root;
    }

    public void parseGenericXml(Lexer lexer, CompositeElement root, Set<String> names) {
        IElementType tokenType;
        boolean rootTagChecked = false;
        while ((tokenType = lexer.getTokenType()) != null) {
            if (tokenType == XML_ATTLIST_DECL_START) {
                root.rawAddChildren(this.parseAttlistDecl(lexer));
                continue;
            }
            if (tokenType == XML_ELEMENT_DECL_START) {
                root.rawAddChildren(this.parseElementDecl(lexer));
                continue;
            }
            if (tokenType == XML_ENTITY_DECL_START) {
                root.rawAddChildren(this.parseEntityDecl(lexer));
                continue;
            }
            if (tokenType == XML_NOTATION_DECL_START) {
                root.rawAddChildren(this.parseNotationDecl(lexer));
                continue;
            }
            if (tokenType == XML_ENTITY_REF_TOKEN) {
                root.rawAddChildren(this.parseEntityRef(lexer));
                continue;
            }
            if (this.parseProcessingInstruction(root, lexer) || this._parseTag(root, lexer, names) || this.parseConditionalSection(root, lexer) || tokenType == null) continue;
            if (!rootTagChecked) {
                rootTagChecked = true;
            }
            this.addToken(root, lexer);
        }
        if (!rootTagChecked) {
            rootTagChecked = true;
        }
        OldXmlParsing.insertMissingTokens(root, ((FilterLexer)lexer).getOriginal(), 0, lexer.getBufferEnd(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
    }

    public TreeElement parseNotationDecl(Lexer lexer) {
        CompositeElement decl = ASTFactory.composite(XML_NOTATION_DECL);
        if (lexer.getTokenType() != XML_NOTATION_DECL_START) {
            return decl;
        }
        this.addToken(decl, lexer);
        if (!this.parseName(decl, lexer)) {
            return decl;
        }
        this.parseEntityDeclContent(decl, lexer);
        if (lexer.getTokenType() != null) {
            this.addToken(decl, lexer);
        }
        return decl;
    }

    private TreeElement parseEntityDecl(Lexer lexer) {
        CompositeElement decl = ASTFactory.composite(XML_ENTITY_DECL);
        if (lexer.getTokenType() != XML_ENTITY_DECL_START) {
            return decl;
        }
        this.addToken(decl, lexer);
        if (lexer.getTokenType() == XML_PERCENT) {
            this.addToken(decl, lexer);
        }
        if (this.parseCompositeName(lexer, decl)) {
            return decl;
        }
        this.parseEntityDeclContent(decl, lexer);
        if (lexer.getTokenType() != null) {
            this.addToken(decl, lexer);
        }
        return decl;
    }

    private boolean parseCompositeName(Lexer lexer, CompositeElement decl) {
        if (!this.parseName(decl, lexer)) {
            if (lexer.getTokenType() == XML_LEFT_PAREN) {
                this.parseGroup(decl, lexer);
            } else {
                decl.rawAddChildren(Factory.createErrorElement(XmlBundle.message((String)"dtd.parser.message.name.expected", (Object[])new Object[0])));
                return true;
            }
        }
        return false;
    }

    public void parseEntityDeclContent(CompositeElement decl, Lexer lexer) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType != XML_ATTRIBUTE_VALUE_START_DELIMITER && tokenType != XML_DOCTYPE_PUBLIC && tokenType != XML_DOCTYPE_SYSTEM) {
            decl.rawAddChildren(Factory.createErrorElement(XmlBundle.message((String)"dtd.parser.message.literal.public.system.expected", (Object[])new Object[0])));
            return;
        }
        while (tokenType != XML_TAG_END && tokenType != null) {
            if (tokenType == XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                this.parseAttributeValue(decl, lexer);
            } else {
                this.addToken(decl, lexer);
            }
            tokenType = lexer.getTokenType();
        }
    }

    private boolean parseConditionalSection(CompositeElement parent, Lexer lexer) {
        if (lexer.getTokenType() != XML_CONDITIONAL_SECTION_START) {
            return false;
        }
        CompositeElement conditionalSection = ASTFactory.composite(XML_CONDITIONAL_SECTION);
        parent.rawAddChildren(conditionalSection);
        this.addToken(conditionalSection, lexer);
        IElementType tokenType = lexer.getTokenType();
        if (tokenType != XML_CONDITIONAL_IGNORE && tokenType != XML_CONDITIONAL_INCLUDE && tokenType != XML_ENTITY_REF_TOKEN) {
            return true;
        }
        if (tokenType == XML_ENTITY_REF_TOKEN) {
            conditionalSection.rawAddChildren(this.parseEntityRef(lexer));
        } else {
            this.addToken(conditionalSection, lexer);
        }
        if (lexer.getTokenType() != XML_MARKUP_START) {
            return true;
        }
        this.parseMarkupContent(lexer, conditionalSection);
        if (lexer.getTokenType() != XML_CONDITIONAL_SECTION_END) {
            return true;
        }
        this.addToken(conditionalSection, lexer);
        return true;
    }

    private boolean parseProcessingInstruction(CompositeElement parent, Lexer lexer) {
        if (lexer.getTokenType() != XML_PI_START) {
            return false;
        }
        CompositeElement tag = ASTFactory.composite(XML_PROCESSING_INSTRUCTION);
        parent.rawAddChildren(tag);
        this.addToken(tag, lexer);
        if (lexer.getTokenType() != XML_PI_TARGET) {
            return true;
        }
        this.addToken(tag, lexer);
        if (lexer.getTokenType() != XML_PI_END) {
            return true;
        }
        this.addToken(tag, lexer);
        return true;
    }

    private boolean _parseTag(CompositeElement parent, Lexer lexer, Set<String> names) {
        if (lexer.getTokenType() != XML_START_TAG_START) {
            return false;
        }
        CompositeElement tag = ASTFactory.composite(XML_TAG);
        parent.rawAddChildren(tag);
        this.addToken(tag, lexer);
        if (lexer.getTokenType() != XML_TAG_NAME) {
            return true;
        }
        String openedName = lexer.getTokenText();
        this.addToken(tag, lexer);
        this.parseAttributeList(tag, lexer);
        while (lexer.getTokenType() == XML_BAD_CHARACTER || lexer.getTokenType() == XML_NAME) {
            this.addToken(tag, lexer);
            this.parseAttributeList(tag, lexer);
        }
        if (lexer.getTokenType() == XML_TAG_END) {
            TreeElement tagEnd = this.addToken(tag, lexer);
            boolean setFlag = false;
            if (!names.contains(openedName)) {
                names.add(openedName);
                setFlag = true;
            }
            CompositeElement text = null;
            while (true) {
                if (this.parseProcessingInstruction(tag, lexer) || this._parseTag(tag, lexer, names)) {
                    continue;
                }
                if (lexer.getTokenType() == XML_DATA_CHARACTERS) {
                    if (text == null) {
                        text = ASTFactory.composite(XML_TEXT);
                        tag.rawAddChildren(text);
                    }
                    this.addToken(text, lexer);
                    continue;
                }
                if (lexer.getTokenType() == XML_CDATA_START) {
                    this.addToken(tag, lexer);
                    continue;
                }
                if (lexer.getTokenType() == XML_CDATA_END) {
                    this.addToken(tag, lexer);
                    continue;
                }
                if (lexer.getTokenType() == XML_CHAR_ENTITY_REF) {
                    this.addToken(tag, lexer);
                    continue;
                }
                if (lexer.getTokenType() != XML_ENTITY_REF_TOKEN) break;
                tag.rawAddChildren(this.parseEntityRef(lexer));
            }
            if (setFlag) {
                names.remove(openedName);
            }
            int pos = lexer.getTokenStart();
            if (lexer.getTokenType() != XML_END_TAG_START) {
                tagEnd.rawInsertAfterMe(Factory.createErrorElement(XmlErrorMessages.message("element.is.not.closed", new Object[0])));
                return false;
            }
            TreeElement endTagStart = OldXmlParsing.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            if (lexer.getTokenType() != XML_TAG_NAME) {
                tag.rawAddChildren(endTagStart);
                return true;
            }
            String closingName = ((Object)lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd())).toString();
            if (!closingName.equals(openedName) && names.contains(closingName)) {
                lexer.start(lexer.getBufferSequence(), pos, lexer.getBufferEnd());
                if (tagEnd != null) {
                    TreeElement start = tagEnd.getTreeNext();
                    tagEnd.setTreeNext(null);
                    if (start != null) {
                        parent.rawAddChildren(start);
                    }
                }
                tagEnd.rawInsertAfterMe(Factory.createErrorElement(XmlErrorMessages.message("element.is.not.closed", new Object[0])));
                return true;
            }
            tag.rawAddChildren(endTagStart);
            this.addToken(tag, lexer);
            if (lexer.getTokenType() != XML_TAG_END) {
                return true;
            }
            this.addToken(tag, lexer);
        } else if (lexer.getTokenType() == XML_EMPTY_ELEMENT_END) {
            this.addToken(tag, lexer);
        } else {
            tag.getLastChildNode().rawInsertAfterMe(Factory.createErrorElement(XmlErrorMessages.message("element.is.not.closed", new Object[0])));
        }
        return true;
    }

    public static TreeElement createTokenElement(Lexer lexer, CharTable table) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType == null) {
            return null;
        }
        return ASTFactory.leaf(tokenType, LexerUtil.internToken((Lexer)lexer, (CharTable)table));
    }

    private TreeElement parseEntityRef(Lexer lexer) {
        CompositeElement ref = ASTFactory.composite(XML_ENTITY_REF);
        if (lexer.getTokenType() == XML_ENTITY_REF_TOKEN) {
            this.addToken(ref, lexer);
        }
        return ref;
    }

    private TreeElement parseProlog(Lexer lexer) {
        CompositeElement prolog = ASTFactory.composite(XML_PROLOG);
        while (this.parseProcessingInstruction(prolog, lexer)) {
        }
        if (lexer.getTokenType() == XML_DECL_START) {
            prolog.rawAddChildren(this.parseDecl(lexer));
        }
        while (this.parseProcessingInstruction(prolog, lexer)) {
        }
        if (lexer.getTokenType() == XML_DOCTYPE_START) {
            prolog.rawAddChildren(this.parseDocType(lexer));
        }
        while (this.parseProcessingInstruction(prolog, lexer)) {
        }
        return prolog;
    }

    private TreeElement parseDocType(Lexer lexer) {
        CompositeElement docType = ASTFactory.composite(XML_DOCTYPE);
        if (lexer.getTokenType() != XML_DOCTYPE_START) {
            return docType;
        }
        this.addToken(docType, lexer);
        if (lexer.getTokenType() != XML_NAME) {
            return docType;
        }
        this.addToken(docType, lexer);
        if (lexer.getTokenType() == XML_DOCTYPE_SYSTEM) {
            this.addToken(docType, lexer);
            if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken(docType, lexer);
            }
        } else if (lexer.getTokenType() == XML_DOCTYPE_PUBLIC) {
            this.addToken(docType, lexer);
            if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken(docType, lexer);
            }
            if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken(docType, lexer);
            }
        }
        if (lexer.getTokenType() == XML_MARKUP_START) {
            docType.rawAddChildren(this.parseMarkupDecl(lexer));
        }
        if (lexer.getTokenType() != XML_DOCTYPE_END) {
            return docType;
        }
        this.addToken(docType, lexer);
        return docType;
    }

    private TreeElement parseMarkupDecl(Lexer lexer) {
        CompositeElement decl = ASTFactory.composite(XML_MARKUP_DECL);
        this.parseMarkupContent(lexer, decl);
        return decl;
    }

    private void parseMarkupContent(Lexer lexer, CompositeElement decl) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType == XML_MARKUP_START) {
            this.addToken(decl, lexer);
        }
        while (true) {
            if ((tokenType = lexer.getTokenType()) == XML_ELEMENT_DECL_START) {
                decl.rawAddChildren(this.parseElementDecl(lexer));
                continue;
            }
            if (tokenType == XML_ATTLIST_DECL_START) {
                decl.rawAddChildren(this.parseAttlistDecl(lexer));
                continue;
            }
            if (tokenType == XML_ENTITY_DECL_START) {
                decl.rawAddChildren(this.parseEntityDecl(lexer));
                continue;
            }
            if (tokenType == XML_NOTATION_DECL_START) {
                decl.rawAddChildren(this.parseNotationDecl(lexer));
                continue;
            }
            if (tokenType == XML_ENTITY_REF_TOKEN) {
                decl.rawAddChildren(this.parseEntityRef(lexer));
                continue;
            }
            if (!this.parseConditionalSection(decl, lexer)) break;
        }
        if (tokenType == XML_MARKUP_END) {
            this.addToken(decl, lexer);
        }
    }

    private TreeElement parseElementDecl(Lexer lexer) {
        CompositeElement decl = ASTFactory.composite(XML_ELEMENT_DECL);
        if (lexer.getTokenType() != XML_ELEMENT_DECL_START) {
            return decl;
        }
        this.addToken(decl, lexer);
        if (this.parseCompositeName(lexer, decl)) {
            return decl;
        }
        this.doParseContentSpec(decl, lexer, false);
        if (lexer.getTokenType() == XML_TAG_END) {
            this.addToken(decl, lexer);
        }
        return decl;
    }

    private boolean parseName(CompositeElement decl, Lexer lexer) {
        if (lexer.getTokenType() == XML_NAME) {
            this.addToken(decl, lexer);
            return true;
        }
        if (lexer.getTokenType() == XML_ENTITY_REF_TOKEN) {
            decl.rawAddChildren(this.parseEntityRef(lexer));
            return true;
        }
        return false;
    }

    public ASTNode parseElementContentSpec(CompositeElement parent, Lexer lexer) {
        return this.doParseContentSpec(parent, lexer, true);
    }

    private ASTNode doParseContentSpec(CompositeElement parent, Lexer lexer, boolean topLevel) {
        String tokenText;
        IElementType tokenType;
        if (this.myLastTokenEnd == lexer.getTokenStart()) {
            parent.rawAddChildren(Factory.createErrorElement(XmlBundle.message((String)"dtd.parser.message.whitespace.expected", (Object[])new Object[0])));
        } else if (!(topLevel || (tokenType = lexer.getTokenType()) == XML_LEFT_PAREN || tokenType == XML_ENTITY_REF_TOKEN || tokenType == XML_CONTENT_ANY || tokenType == XML_CONTENT_EMPTY || tokenType == XML_NAME && ((tokenText = TreeUtil.getTokenText(lexer)).equals("-") || tokenText.equals("O")))) {
            parent.rawAddChildren(Factory.createErrorElement(XmlBundle.message((String)"dtd.parser.message.left.paren.or.entityref.or.empty.or.any.expected", (Object[])new Object[0])));
        }
        CompositeElement spec = ASTFactory.composite(XML_ELEMENT_CONTENT_SPEC);
        parent.rawAddChildren(spec);
        this.parseElementContentSpecInner(lexer, spec, topLevel);
        return spec;
    }

    private boolean parseElementContentSpecInner(Lexer lexer, CompositeElement spec, boolean topLevel) {
        IElementType tokenType = lexer.getTokenType();
        boolean endedWithDelimiter = false;
        while (tokenType != null && tokenType != XML_TAG_END && tokenType != XML_START_TAG_START && tokenType != XML_ELEMENT_DECL_START && tokenType != XML_RIGHT_PAREN) {
            if (tokenType == XML_BAR && topLevel) {
                this.addToken(spec, lexer);
                tokenType = lexer.getTokenType();
                continue;
            }
            if (tokenType == XML_LEFT_PAREN) {
                if (!this.parseGroup(spec, lexer)) {
                    return false;
                }
                endedWithDelimiter = false;
            } else if (tokenType == XML_ENTITY_REF_TOKEN) {
                spec.rawAddChildren(this.parseEntityRef(lexer));
                endedWithDelimiter = false;
            } else if (tokenType == XML_NAME || tokenType == XML_CONTENT_EMPTY || tokenType == XML_CONTENT_ANY || tokenType == XML_PCDATA) {
                this.addToken(spec, lexer);
                endedWithDelimiter = false;
            } else {
                spec.rawAddChildren(Factory.createErrorElement(XmlBundle.message((String)"dtd.parser.message.name.or.entity.ref.expected", (Object[])new Object[0])));
                return false;
            }
            tokenType = lexer.getTokenType();
            if (tokenType == XML_STAR || tokenType == XML_PLUS || tokenType == XML_QUESTION) {
                this.addToken(spec, lexer);
                tokenType = lexer.getTokenType();
                if (tokenType == XML_PLUS) {
                    this.addToken(spec, lexer);
                    tokenType = lexer.getTokenType();
                }
            }
            if (tokenType != XML_BAR && tokenType != XML_COMMA) continue;
            this.addToken(spec, lexer);
            tokenType = lexer.getTokenType();
            endedWithDelimiter = true;
        }
        if (endedWithDelimiter && tokenType == XML_RIGHT_PAREN) {
            spec.rawAddChildren(Factory.createErrorElement(XmlBundle.message((String)"dtd.parser.message.name.or.entity.ref.expected", (Object[])new Object[0])));
        }
        return true;
    }

    private boolean parseGroup(CompositeElement spec, Lexer lexer) {
        this.addToken(spec, lexer);
        boolean b = this.parseElementContentSpecInner(lexer, spec, false);
        if (b && lexer.getTokenType() == XML_RIGHT_PAREN) {
            this.addToken(spec, lexer);
            return true;
        }
        if (b) {
            spec.rawAddChildren(Factory.createErrorElement(XmlBundle.message((String)"dtd.parser.message.rbrace.expected", (Object[])new Object[0])));
            return false;
        }
        return b;
    }

    private TreeElement parseAttlistDecl(Lexer lexer) {
        CompositeElement decl = ASTFactory.composite(XML_ATTLIST_DECL);
        if (lexer.getTokenType() != XML_ATTLIST_DECL_START) {
            return decl;
        }
        this.addToken(decl, lexer);
        if (!this.parseName(decl, lexer)) {
            IElementType tokenType = lexer.getTokenType();
            if (tokenType == XML_LEFT_PAREN) {
                this.parseGroup(decl, lexer);
            } else {
                decl.rawAddChildren(Factory.createErrorElement(XmlBundle.message((String)"dtd.parser.message.name.expected", (Object[])new Object[0])));
                return decl;
            }
        }
        this.parseAttlistContent(decl, lexer);
        if (lexer.getTokenType() == XML_TAG_END) {
            this.addToken(decl, lexer);
        }
        return decl;
    }

    public void parseAttlistContent(CompositeElement parent, Lexer lexer) {
        while (true) {
            if (lexer.getTokenType() == XML_ENTITY_REF_TOKEN) {
                parent.rawAddChildren(this.parseEntityRef(lexer));
                continue;
            }
            if (!this.parseAttributeDecl(parent, lexer)) break;
        }
    }

    private boolean parseAttributeDecl(CompositeElement parent, Lexer lexer) {
        if (lexer.getTokenType() != XML_NAME) {
            return false;
        }
        CompositeElement decl = ASTFactory.composite(XML_ATTRIBUTE_DECL);
        parent.rawAddChildren(decl);
        this.addToken(decl, lexer);
        return this.parseAttributeContentSpec(decl, lexer);
    }

    public boolean parseAttributeContentSpec(CompositeElement parent, Lexer lexer) {
        if (!this.parseName(parent, lexer)) {
            if (lexer.getTokenType() == XML_LEFT_PAREN) {
                parent.rawAddChildren(this.parseEnumeratedType(lexer));
            } else {
                return true;
            }
        }
        if (lexer.getTokenType() == XML_ATT_IMPLIED) {
            this.addToken(parent, lexer);
        } else if (lexer.getTokenType() == XML_ATT_REQUIRED) {
            this.addToken(parent, lexer);
        } else if (lexer.getTokenType() == XML_ATT_FIXED) {
            this.addToken(parent, lexer);
            if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                this.parseAttributeValue(parent, lexer);
            }
        } else if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            this.parseAttributeValue(parent, lexer);
        }
        return true;
    }

    private CompositeElement parseEnumeratedType(Lexer lexer) {
        CompositeElement enumeratedType = ASTFactory.composite(XML_ENUMERATED_TYPE);
        this.addToken(enumeratedType, lexer);
        this.parseEnumeratedTypeContent(enumeratedType, lexer);
        if (lexer.getTokenType() == XML_RIGHT_PAREN) {
            this.addToken(enumeratedType, lexer);
        }
        return enumeratedType;
    }

    public void parseEnumeratedTypeContent(CompositeElement enumeratedType, Lexer lexer) {
        while (true) {
            if (lexer.getTokenType() == XML_ENTITY_REF_TOKEN) {
                enumeratedType.rawAddChildren(this.parseEntityRef(lexer));
                continue;
            }
            if (lexer.getTokenType() != XML_NAME && lexer.getTokenType() != XML_BAR) break;
            this.addToken(enumeratedType, lexer);
        }
    }

    TreeElement parseDecl(Lexer lexer) {
        CompositeElement decl = ASTFactory.composite(XML_DECL);
        if (lexer.getTokenType() != XML_DECL_START) {
            return decl;
        }
        this.addToken(decl, lexer);
        this.parseAttributeList(decl, lexer);
        if (lexer.getTokenType() == XML_DECL_END) {
            this.addToken(decl, lexer);
        } else {
            decl.rawAddChildren(Factory.createErrorElement(XmlErrorMessages.message("expected.prologue.tag.termination.expected", new Object[0])));
        }
        return decl;
    }

    private void parseAttributeList(CompositeElement tag, Lexer lexer) {
        CompositeElement parent = tag;
        int lastPosition = -1;
        while (true) {
            if (lexer.getTokenType() == XML_ENTITY_REF_TOKEN) {
                tag.rawAddChildren(this.parseEntityRef(lexer));
                continue;
            }
            if (lexer.getTokenType() != XML_NAME) {
                return;
            }
            if (lastPosition != -1 && lastPosition == lexer.getTokenStart()) {
                tag.rawAddChildren(Factory.createErrorElement(XmlErrorMessages.message("expected.whitespace", new Object[0])));
                lastPosition = -1;
            }
            if (tag instanceof XmlTag) {
                CompositeElement attribute = ASTFactory.composite(XML_ATTRIBUTE);
                tag.rawAddChildren(attribute);
                parent = attribute;
            }
            this.addToken(parent, lexer);
            if (lexer.getTokenType() != XML_EQ) {
                parent.rawAddChildren(Factory.createErrorElement(XmlErrorMessages.message("expected.attribute.eq.sign", new Object[0])));
                continue;
            }
            this.addToken(parent, lexer);
            if (tag instanceof XmlTag) {
                CompositeElement attributeValue = ASTFactory.composite(XML_ATTRIBUTE_VALUE);
                parent.rawAddChildren(attributeValue);
                parent = attributeValue;
            }
            if (lexer.getTokenType() != XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                return;
            }
            this.addToken(parent, lexer);
            if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken(parent, lexer);
                if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                    lastPosition = lexer.getTokenEnd();
                    this.addToken(parent, lexer);
                } else {
                    lastPosition = -1;
                }
            } else if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                lastPosition = lexer.getTokenEnd();
                this.addToken(parent, lexer);
            } else {
                lastPosition = -1;
            }
            if (!(tag instanceof XmlTag)) continue;
            parent = tag;
        }
    }

    private int parseAttributeValue(CompositeElement parent, Lexer lexer) {
        if (lexer.getTokenType() != XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return -1;
        }
        CompositeElement value = ASTFactory.composite(XML_ATTRIBUTE_VALUE);
        parent.rawAddChildren(value);
        this.addToken(value, lexer);
        while (true) {
            if (lexer.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken(value, lexer);
                continue;
            }
            if (lexer.getTokenType() == XML_CHAR_ENTITY_REF) {
                this.addToken(value, lexer);
                continue;
            }
            if (lexer.getTokenType() != XML_ENTITY_REF_TOKEN) break;
            value.rawAddChildren(this.parseEntityRef(lexer));
        }
        if (lexer.getTokenType() != XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            return -1;
        }
        int tokenEnd = lexer.getTokenEnd();
        this.addToken(value, lexer);
        return tokenEnd;
    }

    private TreeElement addToken(CompositeElement decl, Lexer lexer) {
        TreeElement element = OldXmlParsing.createTokenElement(lexer, this.myContext.getCharTable());
        if (element != null) {
            decl.rawAddChildren(element);
            this.myLastTokenEnd = lexer.getTokenEnd();
            lexer.advance();
        }
        return element;
    }

    public TreeElement parseMarkupDecl(CharSequence text) {
        CompositeElement root = ASTFactory.composite(XML_MARKUP_DECL);
        OldXmlLexer originalLexer = new OldXmlLexer();
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(XML_WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(text, 0, text.length(), 13);
        this.parseMarkupContent((Lexer)lexer, root);
        while (lexer.getTokenType() != null) {
            TreeElement children;
            if (lexer.getTokenType() == XML_ENTITY_REF_TOKEN) {
                children = this.parseEntityRef((Lexer)lexer);
            } else if (lexer.getTokenType() == XML_ENTITY_DECL_START) {
                children = this.parseEntityDecl((Lexer)lexer);
            } else {
                children = OldXmlParsing.createTokenElement((Lexer)lexer, this.myContext.getCharTable());
                lexer.advance();
            }
            root.rawAddChildren(children);
        }
        originalLexer.start(text, 0, text.length(), 13);
        OldXmlParsing.insertMissingTokens(root, (Lexer)originalLexer, 0, text.length(), 13, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return root;
    }

    public void parseAttrValue(CompositeElement element, Lexer lexer) {
        while (lexer.getTokenType() != null) {
            this.addToken(element, lexer);
        }
    }

    public static void insertMissingTokens(CompositeElement root, Lexer lexer, int startOffset, int endOffset, int state, TokenProcessor processor, ParsingContext context) {
        TreeElement firstMissing;
        TreeElement firstMissing2;
        if (state < 0) {
            lexer.start(lexer.getBufferSequence(), startOffset, endOffset);
        } else {
            lexer.start(lexer.getBufferSequence(), startOffset, endOffset, state);
        }
        LeafElement leaf = TreeUtil.findFirstLeaf(root);
        if (leaf == null) {
            TreeElement firstMissing3 = processor.process(lexer, context);
            if (firstMissing3 != null) {
                root.rawAddChildren(firstMissing3);
            }
            return;
        }
        IElementType tokenType = lexer.getTokenType();
        if (tokenType != leaf.getElementType() && processor.isTokenValid(tokenType) && (firstMissing2 = processor.process(lexer, context)) != null) {
            root.getFirstChildNode().rawInsertBeforeMe(firstMissing2);
        }
        OldXmlParsing.passTokenOrChameleon(leaf, lexer);
        OldXmlParsing.insertMissingTokensInTreeBody(leaf, lexer, processor, context, null);
        if (lexer.getTokenType() != null && (firstMissing = processor.process(lexer, context)) != null) {
            CompositeElement current = root;
            while (current instanceof CompositeElement && current.getUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY) == null) {
                current = current.getLastChildNode();
            }
            if (current instanceof CompositeElement) {
                current.rawAddChildren(firstMissing);
            } else {
                root.getLastChildNode().rawInsertAfterMe(firstMissing);
            }
        }
    }

    public static void insertMissingTokensInTreeBody(TreeElement leaf, Lexer lexer, TokenProcessor processor, ParsingContext context, ASTNode endToken) {
        TreeUtil.CommonParentState commonParents = new TreeUtil.CommonParentState();
        while (leaf != null) {
            commonParents.strongWhiteSpaceHolder = null;
            IElementType tokenType = lexer.getTokenType();
            TreeElement next = TreeUtil.nextLeaf(leaf, commonParents, null, false);
            if (next == null || tokenType == null || next == endToken) break;
            if (tokenType != next.getElementType() && processor.isTokenValid(tokenType)) {
                TreeElement firstMissing = processor.process(lexer, context);
                CompositeElement unclosedElement = commonParents.strongWhiteSpaceHolder;
                if (unclosedElement != null) {
                    if (commonParents.isStrongElementOnRisingSlope || unclosedElement.getFirstChildNode() == null) {
                        unclosedElement.rawAddChildren(firstMissing);
                    } else {
                        unclosedElement.getFirstChildNode().rawInsertBeforeMe(firstMissing);
                    }
                } else {
                    ASTNode insertBefore = commonParents.nextLeafBranchStart;
                    TreeElement insertAfter = commonParents.startLeafBranchStart;
                    TreeElement current = commonParents.startLeafBranchStart;
                    while (current != insertBefore) {
                        TreeElement treeNext = current.getTreeNext();
                        if (treeNext == insertBefore) {
                            insertAfter = current;
                            break;
                        }
                        if (treeNext.getUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY) != null) {
                            insertAfter = null;
                            ((CompositeElement)treeNext).rawAddChildren(firstMissing);
                            break;
                        }
                        current = treeNext;
                    }
                    if (insertAfter != null && firstMissing != null) {
                        insertAfter.rawInsertAfterMe(firstMissing);
                    }
                }
            }
            OldXmlParsing.passTokenOrChameleon(next, lexer);
            leaf = next;
        }
    }

    private static void passTokenOrChameleon(ASTNode next, Lexer lexer) {
        if (next instanceof LeafElement && next instanceof OuterLanguageElement) {
            int endOfChameleon = next.getTextLength() + lexer.getTokenStart();
            while (lexer.getTokenType() != null && lexer.getTokenEnd() < endOfChameleon) {
                lexer.advance();
            }
        }
        lexer.advance();
    }

    public static class WhiteSpaceAndCommentsProcessor
    implements TokenProcessor {
        public static final TokenProcessor INSTANCE = new WhiteSpaceAndCommentsProcessor();

        private WhiteSpaceAndCommentsProcessor() {
        }

        @Override
        public TreeElement process(Lexer lexer, ParsingContext context) {
            TreeElement first = null;
            TreeElement last = null;
            while (this.isTokenValid(lexer.getTokenType())) {
                TreeElement tokenElement;
                IElementType type = lexer.getTokenType();
                if (!XML_WHITE_SPACE_OR_COMMENT_BIT_SET.contains(type)) {
                    LOG.error("Missed token should be white space or comment:" + type);
                    throw new RuntimeException();
                }
                if (lexer.getTokenType() == XmlTokenType.XML_COMMENT_START) {
                    tokenElement = this.parseComment(lexer, context);
                } else {
                    tokenElement = OldXmlParsing.createTokenElement(lexer, context.getCharTable());
                    lexer.advance();
                }
                if (last != null) {
                    last.setTreeNext(tokenElement);
                    tokenElement.setTreePrev(last);
                    last = tokenElement;
                    continue;
                }
                first = last = tokenElement;
            }
            return first;
        }

        @Override
        public boolean isTokenValid(IElementType tokenType) {
            return tokenType != null && XML_WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tokenType);
        }

        private TreeElement parseComment(Lexer lexer, ParsingContext context) {
            CompositeElement comment = ASTFactory.composite(XmlElementType.XML_COMMENT);
            while (lexer.getTokenType() != null && XML_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
                TreeElement tokenElement = OldXmlParsing.createTokenElement(lexer, context.getCharTable());
                lexer.advance();
                comment.rawAddChildren(tokenElement);
            }
            return comment;
        }
    }
}

