/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.lang.ASTFactory;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;

class GTTokens
implements JavaTokenType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.GTTokens");

    GTTokens() {
    }

    static IElementType getTokenType(Lexer lexer) {
        IElementType resultType;
        if (lexer.getTokenType() != GT) {
            return lexer.getTokenType();
        }
        LexerPosition originalPosition = lexer.getCurrentPosition();
        int prevTokenEnd = lexer.getTokenEnd();
        lexer.advance();
        if (lexer.getTokenStart() != prevTokenEnd) {
            lexer.restore(originalPosition);
            return GT;
        }
        IElementType i1 = lexer.getTokenType();
        if (i1 == EQ) {
            resultType = GE;
        } else if (i1 == GT) {
            int prevTokenEnd2 = lexer.getTokenEnd();
            lexer.advance();
            if (lexer.getTokenStart() != prevTokenEnd2) {
                resultType = GTGT;
            } else {
                IElementType i = lexer.getTokenType();
                if (i == GT) {
                    int prevTokenEnd3 = lexer.getTokenEnd();
                    lexer.advance();
                    resultType = lexer.getTokenStart() != prevTokenEnd3 || lexer.getTokenType() != EQ ? GTGTGT : GTGTGTEQ;
                } else {
                    resultType = i == EQ ? GTGTEQ : GTGT;
                }
            }
        } else {
            resultType = GT;
        }
        lexer.restore(originalPosition);
        return resultType;
    }

    static TreeElement createTokenElementAndAdvance(IElementType tokenType, Lexer lexer, CharTable table) {
        TreeElement result;
        if (tokenType == GTGT || tokenType == GE) {
            result = GTTokens.mergeTokens(1, lexer, tokenType, table);
        } else if (tokenType == GTGTEQ || tokenType == GTGTGT) {
            result = GTTokens.mergeTokens(2, lexer, tokenType, table);
        } else if (tokenType == GTGTGTEQ) {
            result = GTTokens.mergeTokens(3, lexer, tokenType, table);
        } else {
            LOG.assertTrue(tokenType == lexer.getTokenType());
            result = ParseUtil.createTokenElement(lexer, table);
        }
        lexer.advance();
        return result;
    }

    static void advance(IElementType tokenType, Lexer lexer) {
        if (lexer.getTokenType() != GT) {
            lexer.advance();
        } else {
            if (tokenType == GTGTGTEQ) {
                lexer.advance();
                lexer.advance();
                lexer.advance();
            } else if (tokenType == GTGTEQ || tokenType == GTGTGT) {
                lexer.advance();
                lexer.advance();
            } else if (tokenType == GTGT || tokenType == GE) {
                lexer.advance();
            }
            lexer.advance();
        }
    }

    private static TreeElement mergeTokens(int nTokens, Lexer lexer, IElementType tokenType, CharTable table) {
        int tokenStart = lexer.getTokenStart();
        for (int i = 0; i < nTokens; ++i) {
            lexer.advance();
        }
        int tokenEnd = lexer.getTokenEnd();
        return ASTFactory.leaf(tokenType, table.intern(lexer.getBufferSequence(), tokenStart, tokenEnd));
    }
}

