/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTFactory;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.parsing.GTTokens;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.parsing.WhiteSpaceAndCommentsProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class ExpressionParsing
extends Parsing {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.ExpressionParsing");
    private static final int PARSE_ASSIGNMENT = 0;
    private static final int PARSE_CONDITIONAL = 1;
    private static final int PARSE_COND_OR = 2;
    private static final int PARSE_COND_AND = 3;
    private static final int PARSE_OR = 4;
    private static final int PARSE_XOR = 5;
    private static final int PARSE_AND = 6;
    private static final int PARSE_EQUALITY = 7;
    private static final int PARSE_RELATIONAL = 8;
    private static final int PARSE_SHIFT = 9;
    private static final int PARSE_ADDITIVE = 10;
    private static final int PARSE_MULTIPLICATIVE = 11;
    private static final int PARSE_UNARY = 12;
    private static final int PARSE_POSTFIX = 13;
    private static final int PARSE_PRIMARY = 14;
    private static final int PARSE_ARGUMENT_LIST = 16;
    private static final int PARSE_ARRAY_INITIALIZER = 17;
    private static final int PARSE_TYPE = 18;
    private static final TokenSet COND_OR_SIGN_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OROR});
    private static final TokenSet COND_AND_SIGN_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.ANDAND});
    private static final TokenSet OR_SIGN_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OR});
    private static final TokenSet XOR_SIGN_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.XOR});
    private static final TokenSet AND_SIGN_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.AND});
    private static final TokenSet EQUALITY_SIGN_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EQEQ, JavaTokenType.NE});
    private static final TokenSet SHIFT_SIGN_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT});
    private static final TokenSet ADDITIVE_SIGN_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS});
    private static final TokenSet MULTIPLICATIVE_SIGN_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC});

    public ExpressionParsing(JavaParsingContext context) {
        super(context);
    }

    public static CompositeElement parseExpressionText(PsiManager manager, CharSequence buffer, int startOffset, int endOffset, CharTable table) {
        LanguageLevel level = LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel();
        JavaLexer originalLexer = new JavaLexer(level);
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer, startOffset, endOffset);
        JavaParsingContext context = new JavaParsingContext(table, level);
        CompositeElement expression = context.getExpressionParsing().parseExpression((Lexer)lexer);
        if (expression == null) {
            return null;
        }
        expression.putUserData(CharTable.CHAR_TABLE_KEY, table);
        if (lexer.getTokenType() != null) {
            return null;
        }
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, table).getTreeElement();
        dummyRoot.rawAddChildren(expression);
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, 0, buffer.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, context);
        return expression;
    }

    public TreeElement parseExpressionText(Lexer originalLexer, CharSequence buffer, int startOffset, int endOffset, PsiManager manager) {
        FilterLexer lexer = new FilterLexer(originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer, startOffset, endOffset);
        CharTable table = this.myContext.getCharTable();
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, table).getTreeElement();
        CompositeElement expression = this.parseExpression((Lexer)lexer);
        if (expression != null) {
            dummyRoot.rawAddChildren(expression);
        }
        CompositeElement parent = dummyRoot;
        IElementType tokenType = lexer.getTokenType();
        if (tokenType != null && tokenType != TokenType.BAD_CHARACTER) {
            CompositeElement errorElement = Factory.createErrorElement("Unexpected tokens");
            dummyRoot.rawAddChildren(errorElement);
            parent = errorElement;
        }
        while (lexer.getTokenType() != null) {
            ((CompositeElement)parent).rawAddChildren(ParseUtil.createTokenElement((Lexer)lexer, table));
            lexer.advance();
        }
        ParseUtil.insertMissingTokens(dummyRoot, originalLexer, 0, buffer.length(), -1, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return dummyRoot.getFirstChildNode();
    }

    public TreeElement parseExpressionTextFragment(PsiManager manager, CharSequence buffer, int startOffset, int endOffset, int state) {
        JavaLexer originalLexer = new JavaLexer(this.myContext.getLanguageLevel());
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        if (state >= 0) {
            lexer.start(buffer, startOffset, endOffset, state);
        } else {
            lexer.start(buffer, startOffset, endOffset);
        }
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, this.myContext.getCharTable()).getTreeElement();
        CompositeElement expression = this.parseExpression((Lexer)lexer);
        if (expression != null) {
            dummyRoot.rawAddChildren(expression);
        }
        if (lexer.getTokenType() != null) {
            dummyRoot.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("unexpected.tokens.beyond.the.end.of.expression", new Object[0])));
            while (lexer.getTokenType() != null) {
                dummyRoot.rawAddChildren(ParseUtil.createTokenElement((Lexer)lexer, this.myContext.getCharTable()));
                lexer.advance();
            }
        }
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, 0, buffer.length(), state, WhiteSpaceAndCommentsProcessor.INSTANCE, this.myContext);
        return dummyRoot.getFirstChildNode();
    }

    public CompositeElement parseExpression(Lexer lexer) {
        return this.parseConstruct(lexer, 0);
    }

    private CompositeElement parseConstruct(Lexer lexer, int number) {
        switch (number) {
            case 0: {
                return this.parseAssignmentExpression(lexer);
            }
            case 1: {
                return this.parseConditionalExpression(lexer);
            }
            case 2: {
                return this.parseBinaryExpression(lexer, 3, COND_OR_SIGN_BIT_SET);
            }
            case 3: {
                return this.parseBinaryExpression(lexer, 4, COND_AND_SIGN_BIT_SET);
            }
            case 4: {
                return this.parseBinaryExpression(lexer, 5, OR_SIGN_BIT_SET);
            }
            case 5: {
                return this.parseBinaryExpression(lexer, 6, XOR_SIGN_BIT_SET);
            }
            case 6: {
                return this.parseBinaryExpression(lexer, 7, AND_SIGN_BIT_SET);
            }
            case 7: {
                return this.parseBinaryExpression(lexer, 8, EQUALITY_SIGN_BIT_SET);
            }
            case 8: {
                return this.parseRelationalExpression(lexer);
            }
            case 9: {
                return this.parseBinaryExpression(lexer, 10, SHIFT_SIGN_BIT_SET);
            }
            case 10: {
                return this.parseBinaryExpression(lexer, 11, ADDITIVE_SIGN_BIT_SET);
            }
            case 11: {
                return this.parseBinaryExpression(lexer, 12, MULTIPLICATIVE_SIGN_BIT_SET);
            }
            case 12: {
                return this.parseUnaryExpression(lexer);
            }
            case 13: {
                return this.parsePostfixExpression(lexer);
            }
            case 14: {
                return this.parsePrimaryExpression(lexer);
            }
            case 16: {
                return this.parseArgumentList(lexer);
            }
            case 17: {
                return this.parseArrayInitializerExpression(lexer);
            }
            case 18: {
                return this.parseType(lexer);
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    private CompositeElement parseBinaryExpression(Lexer lexer, int argNumber, TokenSet opSignBitSet) {
        IElementType tokenType;
        CompositeElement element = this.parseConstruct(lexer, argNumber);
        if (element == null) {
            return null;
        }
        while ((tokenType = GTTokens.getTokenType(lexer)) != null && opSignBitSet.contains(tokenType)) {
            CompositeElement result = ASTFactory.composite(JavaElementType.BINARY_EXPRESSION);
            result.rawAddChildren(element);
            result.rawAddChildren(GTTokens.createTokenElementAndAdvance(tokenType, lexer, this.myContext.getCharTable()));
            CompositeElement element1 = this.parseConstruct(lexer, argNumber);
            if (element1 == null) {
                result.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
                return result;
            }
            result.rawAddChildren(element1);
            element = result;
        }
        return element;
    }

    private CompositeElement parseAssignmentExpression(Lexer lexer) {
        CompositeElement element1 = this.parseConditionalExpression(lexer);
        if (element1 == null) {
            return null;
        }
        IElementType tokenType = GTTokens.getTokenType(lexer);
        if (tokenType == JavaTokenType.EQ || tokenType == JavaTokenType.ASTERISKEQ || tokenType == JavaTokenType.DIVEQ || tokenType == JavaTokenType.PERCEQ || tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ || tokenType == JavaTokenType.LTLTEQ || tokenType == JavaTokenType.GTGTEQ || tokenType == JavaTokenType.GTGTGTEQ || tokenType == JavaTokenType.ANDEQ || tokenType == JavaTokenType.OREQ || tokenType == JavaTokenType.XOREQ) {
            CompositeElement element = ASTFactory.composite(JavaElementType.ASSIGNMENT_EXPRESSION);
            element.rawAddChildren(element1);
            element.rawAddChildren(GTTokens.createTokenElementAndAdvance(tokenType, lexer, this.myContext.getCharTable()));
            CompositeElement element2 = this.parseAssignmentExpression(lexer);
            if (element2 == null) {
                element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
                return element;
            }
            element.rawAddChildren(element2);
            return element;
        }
        return element1;
    }

    public CompositeElement parseConditionalExpression(Lexer lexer) {
        CompositeElement element1 = this.parseConstruct(lexer, 2);
        if (element1 == null) {
            return null;
        }
        if (lexer.getTokenType() != JavaTokenType.QUEST) {
            return element1;
        }
        CompositeElement element = ASTFactory.composite(JavaElementType.CONDITIONAL_EXPRESSION);
        element.rawAddChildren(element1);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement element2 = this.parseExpression(lexer);
        if (element2 == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
            return element;
        }
        element.rawAddChildren(element2);
        if (lexer.getTokenType() != JavaTokenType.COLON) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.colon", new Object[0])));
            return element;
        }
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement element3 = this.parseConditionalExpression(lexer);
        if (element3 == null) {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
            return element;
        }
        element.rawAddChildren(element3);
        return element;
    }

    private CompositeElement parseRelationalExpression(Lexer lexer) {
        IElementType tokenType;
        CompositeElement element = this.parseConstruct(lexer, 9);
        if (element == null) {
            return null;
        }
        while ((tokenType = GTTokens.getTokenType(lexer)) != null) {
            int argNumber;
            IElementType elementType;
            if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GE) {
                elementType = JavaElementType.BINARY_EXPRESSION;
                argNumber = 9;
            } else {
                if (tokenType != JavaTokenType.INSTANCEOF_KEYWORD) break;
                elementType = JavaElementType.INSTANCE_OF_EXPRESSION;
                argNumber = 18;
            }
            CompositeElement result = ASTFactory.composite(elementType);
            result.rawAddChildren(element);
            result.rawAddChildren(GTTokens.createTokenElementAndAdvance(tokenType, lexer, this.myContext.getCharTable()));
            CompositeElement element1 = this.parseConstruct(lexer, argNumber);
            if (element1 == null) {
                CompositeElement errorElement = Factory.createErrorElement(argNumber == 18 ? JavaErrorMessages.message("expected.type", new Object[0]) : JavaErrorMessages.message("expected.expression", new Object[0]));
                result.rawAddChildren(errorElement);
                return result;
            }
            result.rawAddChildren(element1);
            element = result;
        }
        return element;
    }

    private CompositeElement parseUnaryExpression(Lexer lexer) {
        boolean isPrefix;
        IElementType tokenType = lexer.getTokenType();
        boolean bl = isPrefix = tokenType == JavaTokenType.PLUS || tokenType == JavaTokenType.MINUS || tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS || tokenType == JavaTokenType.TILDE || tokenType == JavaTokenType.EXCL;
        if (isPrefix) {
            CompositeElement element = ASTFactory.composite(JavaElementType.PREFIX_EXPRESSION);
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            CompositeElement element1 = this.parseUnaryExpression(lexer);
            if (element1 == null) {
                element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
                return element;
            }
            element.rawAddChildren(element1);
            return element;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            LeafElement lastNode;
            LexerPosition pos = lexer.getCurrentPosition();
            TreeElement lparenth = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            CompositeElement type = this.parseType(lexer);
            if (type == null || lexer.getTokenType() != JavaTokenType.RPARENTH) {
                lexer.restore(pos);
                return this.parsePostfixExpression(lexer);
            }
            TreeElement rparenth = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            if (!(lexer.getTokenType() != JavaTokenType.PLUS && lexer.getTokenType() != JavaTokenType.MINUS && lexer.getTokenType() != JavaTokenType.PLUSPLUS && lexer.getTokenType() != JavaTokenType.MINUSMINUS || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(((TreeElement)type).getFirstChildNode().getElementType()))) {
                lexer.restore(pos);
                return this.parsePostfixExpression(lexer);
            }
            CompositeElement expr = this.parseUnaryExpression(lexer);
            if (expr == null && (lastNode = TreeUtil.findLastLeaf(type)).getElementType() != JavaTokenType.GT) {
                lexer.restore(pos);
                return this.parsePostfixExpression(lexer);
            }
            CompositeElement element = ASTFactory.composite(JavaElementType.TYPE_CAST_EXPRESSION);
            element.rawAddChildren(lparenth);
            element.rawAddChildren(type);
            element.rawAddChildren(rparenth);
            if (expr != null) {
                element.rawAddChildren(expr);
            } else {
                element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
            }
            return element;
        }
        return this.parsePostfixExpression(lexer);
    }

    private CompositeElement parsePostfixExpression(Lexer lexer) {
        CompositeElement element = this.parsePrimaryExpression(lexer);
        if (element == null) {
            return null;
        }
        while (lexer.getTokenType() == JavaTokenType.PLUSPLUS || lexer.getTokenType() == JavaTokenType.MINUSMINUS) {
            CompositeElement element1 = ASTFactory.composite(JavaElementType.POSTFIX_EXPRESSION);
            element1.rawAddChildren(element);
            element1.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            element = element1;
        }
        return element;
    }

    private CompositeElement parsePrimaryExpression(Lexer lexer) {
        LexerPosition startPos = lexer.getCurrentPosition();
        CompositeElement element = this.parsePrimaryExpressionStart(lexer);
        if (element == null) {
            return null;
        }
        while (true) {
            CompositeElement element1;
            LexerPosition pos;
            IElementType i;
            if ((i = lexer.getTokenType()) == JavaTokenType.DOT) {
                CompositeElement element12;
                CompositeElement element13;
                CompositeElement referenceParameterList;
                pos = lexer.getCurrentPosition();
                TreeElement dot = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
                lexer.advance();
                IElementType tokenType = lexer.getTokenType();
                if (tokenType == JavaTokenType.LT) {
                    referenceParameterList = this.parseReferenceParameterList(lexer, false);
                    element13 = ASTFactory.composite(JavaElementType.REFERENCE_EXPRESSION);
                    element13.rawAddChildren(element);
                    element13.rawAddChildren(dot);
                    element13.rawAddChildren(referenceParameterList);
                    if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
                        element13.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
                        return element13;
                    }
                    element13.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    element = element13;
                    continue;
                }
                if (tokenType == JavaTokenType.CLASS_KEYWORD && element.getElementType() == JavaElementType.REFERENCE_EXPRESSION) {
                    LexerPosition pos1 = lexer.getCurrentPosition();
                    lexer.restore(startPos);
                    element13 = this.parseClassObjectAccessExpression(lexer);
                    if (lexer.getTokenStart() <= pos1.getOffset()) {
                        lexer.restore(pos1);
                        element.rawAddChildren(dot);
                        element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
                        return element;
                    }
                    element = element13;
                    continue;
                }
                if (tokenType == JavaTokenType.NEW_KEYWORD) {
                    element = this.parseNewExpression(lexer, element, dot);
                    continue;
                }
                if ((tokenType == JavaTokenType.THIS_KEYWORD || tokenType == JavaTokenType.SUPER_KEYWORD) && element.getElementType() == JavaElementType.REFERENCE_EXPRESSION) {
                    lexer.restore(startPos);
                    element12 = this.parseJavaCodeReference(lexer, false, true, false);
                    if (element12 == null || lexer.getTokenType() != JavaTokenType.DOT || lexer.getTokenStart() != pos.getOffset()) {
                        lexer.restore(pos);
                        return element;
                    }
                    IElementType type = tokenType == JavaTokenType.THIS_KEYWORD ? JavaElementType.THIS_EXPRESSION : JavaElementType.SUPER_EXPRESSION;
                    CompositeElement element2 = ASTFactory.composite(type);
                    element2.rawAddChildren(element12);
                    element2.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    if (lexer.getTokenType() != tokenType) {
                        lexer.restore(pos);
                        return element;
                    }
                    element2.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    element = element2;
                    continue;
                }
                if (tokenType == JavaTokenType.SUPER_KEYWORD) {
                    element12 = ASTFactory.composite(JavaElementType.REFERENCE_EXPRESSION);
                    element12.rawAddChildren(element);
                    element12.rawAddChildren(dot);
                    element12.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                    element = element12;
                    continue;
                }
                referenceParameterList = this.parseReferenceParameterList(lexer, false);
                element13 = ASTFactory.composite(JavaElementType.REFERENCE_EXPRESSION);
                element13.rawAddChildren(element);
                element13.rawAddChildren(dot);
                element13.rawAddChildren(referenceParameterList);
                if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
                    element13.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
                    return element13;
                }
                element13.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                element = element13;
                continue;
            }
            if (i == JavaTokenType.LPARENTH) {
                if (element.getElementType() != JavaElementType.REFERENCE_EXPRESSION) {
                    if (element.getElementType() == JavaElementType.SUPER_EXPRESSION) {
                        pos = lexer.getCurrentPosition();
                        lexer.restore(startPos);
                        CompositeElement qualifier = this.parsePrimaryExpressionStart(lexer);
                        if (qualifier != null) {
                            element1 = ASTFactory.composite(JavaElementType.REFERENCE_EXPRESSION);
                            element1.rawAddChildren(qualifier);
                            if (lexer.getTokenType() == JavaTokenType.DOT) {
                                TreeElement dot = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
                                lexer.advance();
                                element1.rawAddChildren(dot);
                                if (lexer.getTokenType() == JavaTokenType.SUPER_KEYWORD) {
                                    TreeElement superKeyword = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
                                    lexer.advance();
                                    element1.rawAddChildren(superKeyword);
                                    element = element1;
                                    continue;
                                }
                            }
                        }
                        lexer.restore(pos);
                        return element;
                    }
                    return element;
                }
                CompositeElement element14 = ASTFactory.composite(JavaElementType.METHOD_CALL_EXPRESSION);
                element14.rawAddChildren(element);
                CompositeElement argumentList = this.parseArgumentList(lexer);
                element14.rawAddChildren(argumentList);
                element = element14;
                continue;
            }
            if (i != JavaTokenType.LBRACKET) break;
            pos = lexer.getCurrentPosition();
            TreeElement lbracket = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            if (lexer.getTokenType() == JavaTokenType.RBRACKET && element.getElementType() == JavaElementType.REFERENCE_EXPRESSION) {
                lexer.restore(startPos);
                element1 = this.parseClassObjectAccessExpression(lexer);
                if (lexer.getTokenStart() <= pos.getOffset()) {
                    lexer.restore(pos);
                    return element;
                }
                element = element1;
                continue;
            }
            element1 = ASTFactory.composite(JavaElementType.ARRAY_ACCESS_EXPRESSION);
            element1.rawAddChildren(element);
            element1.rawAddChildren(lbracket);
            CompositeElement expr = this.parseExpression(lexer);
            if (expr == null) {
                element1.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
                return element1;
            }
            element1.rawAddChildren(expr);
            if (lexer.getTokenType() != JavaTokenType.RBRACKET) {
                element1.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rbracket", new Object[0])));
                return element1;
            }
            element1.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            element = element1;
        }
        return element;
    }

    private CompositeElement parsePrimaryExpressionStart(Lexer lexer) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType == JavaTokenType.TRUE_KEYWORD || tokenType == JavaTokenType.FALSE_KEYWORD || tokenType == JavaTokenType.NULL_KEYWORD || tokenType == JavaTokenType.INTEGER_LITERAL || tokenType == JavaTokenType.LONG_LITERAL || tokenType == JavaTokenType.FLOAT_LITERAL || tokenType == JavaTokenType.DOUBLE_LITERAL || tokenType == JavaTokenType.CHARACTER_LITERAL || tokenType == JavaTokenType.STRING_LITERAL) {
            CompositeElement element = ASTFactory.composite(JavaElementType.LITERAL_EXPRESSION);
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            return element;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            CompositeElement element = ASTFactory.composite(JavaElementType.PARENTH_EXPRESSION);
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            CompositeElement expression = this.parseExpression(lexer);
            if (expression == null) {
                element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
            } else {
                element.rawAddChildren(expression);
            }
            if (lexer.getTokenType() != JavaTokenType.RPARENTH) {
                if (expression != null) {
                    element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rparen", new Object[0])));
                }
            } else {
                element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
            }
            return element;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseArrayInitializerExpression(lexer);
        }
        CompositeElement annotation = null;
        LexerPosition beforeAnnotation = lexer.getCurrentPosition();
        if (tokenType == JavaTokenType.AT) {
            CompositeElement list = ASTFactory.composite(tokenType);
            this.myContext.getDeclarationParsing().parseAnnotationListTo(lexer, list);
            annotation = (CompositeElement)list.getFirstChildNode();
            tokenType = lexer.getTokenType();
        }
        if (tokenType == JavaTokenType.IDENTIFIER) {
            CompositeElement refExpr = ASTFactory.composite(JavaElementType.REFERENCE_EXPRESSION);
            refExpr.rawAddChildren(ASTFactory.composite(JavaElementType.REFERENCE_PARAMETER_LIST));
            if (annotation != null) {
                refExpr.rawAddChildren(annotation);
            }
            refExpr.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            return refExpr;
        }
        if (annotation != null) {
            lexer.restore(beforeAnnotation);
            tokenType = lexer.getTokenType();
        }
        if (tokenType == JavaTokenType.THIS_KEYWORD) {
            TreeElement thisKeyword = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            CompositeElement element = lexer.getTokenType() != JavaTokenType.LPARENTH ? ASTFactory.composite(JavaElementType.THIS_EXPRESSION) : ASTFactory.composite(JavaElementType.REFERENCE_EXPRESSION);
            element.rawAddChildren(ASTFactory.composite(JavaElementType.REFERENCE_PARAMETER_LIST));
            element.rawAddChildren(thisKeyword);
            return element;
        }
        if (tokenType == JavaTokenType.SUPER_KEYWORD) {
            TreeElement superKeyword = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            CompositeElement element = lexer.getTokenType() != JavaTokenType.LPARENTH ? ASTFactory.composite(JavaElementType.SUPER_EXPRESSION) : ASTFactory.composite(JavaElementType.REFERENCE_EXPRESSION);
            element.rawAddChildren(ASTFactory.composite(JavaElementType.REFERENCE_PARAMETER_LIST));
            element.rawAddChildren(superKeyword);
            return element;
        }
        if (tokenType == JavaTokenType.NEW_KEYWORD) {
            return this.parseNewExpression(lexer, null, null);
        }
        if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
            return this.parseClassObjectAccessExpression(lexer);
        }
        return null;
    }

    private CompositeElement parseNewExpression(Lexer lexer, TreeElement qualifier, TreeElement dot) {
        TreeElement refOrType;
        boolean isPrimitive;
        boolean parseAnnotations;
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.NEW_KEYWORD);
        CompositeElement element = ASTFactory.composite(JavaElementType.NEW_EXPRESSION);
        if (qualifier != null) {
            element.rawAddChildren(qualifier);
            element.rawAddChildren(dot);
        }
        TreeElement newKeyword = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
        element.rawAddChildren(newKeyword);
        lexer.advance();
        element.rawAddChildren(this.parseReferenceParameterList(lexer, false));
        boolean bl = parseAnnotations = this.areTypeAnnotationsSupported() && lexer.getTokenType() == JavaTokenType.AT;
        if (lexer.getTokenType() == JavaTokenType.IDENTIFIER || parseAnnotations) {
            isPrimitive = false;
            refOrType = this.parseJavaCodeReference(lexer, true, true, parseAnnotations);
        } else if (lexer.getTokenType() != null && ElementType.PRIMITIVE_TYPE_BIT_SET.contains(lexer.getTokenType())) {
            isPrimitive = true;
            refOrType = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
        } else {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
            return element;
        }
        if (!isPrimitive && lexer.getTokenType() == JavaTokenType.LPARENTH) {
            CompositeElement argumentList = this.parseArgumentList(lexer);
            if (lexer.getTokenType() == JavaTokenType.LBRACE && refOrType.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
                CompositeElement classElement = ASTFactory.composite(JavaElementType.ANONYMOUS_CLASS);
                element.rawAddChildren(classElement);
                classElement.rawAddChildren(refOrType);
                classElement.rawAddChildren(argumentList);
                this.myContext.getDeclarationParsing().parseClassBodyWithBraces(classElement, lexer, false, false);
            } else {
                element.rawAddChildren(refOrType);
                element.rawAddChildren(argumentList);
            }
        } else {
            element.rawAddChildren(refOrType);
            if (lexer.getTokenType() != JavaTokenType.LBRACKET) {
                String description = isPrimitive ? JavaErrorMessages.message("expected.lbracket", new Object[0]) : JavaErrorMessages.message("expected.lparen.or.lbracket", new Object[0]);
                element.rawAddChildren(Factory.createErrorElement(description));
                return element;
            }
            int bracketCount = 0;
            int dimCount = 0;
            while (lexer.getTokenType() == JavaTokenType.LBRACKET) {
                CompositeElement dimExpr;
                element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                if (bracketCount == dimCount && (dimExpr = this.parseExpression(lexer)) != null) {
                    element.rawAddChildren(dimExpr);
                    ++dimCount;
                }
                ++bracketCount;
                if (lexer.getTokenType() != JavaTokenType.RBRACKET) {
                    element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rbracket", new Object[0])));
                    return element;
                }
                element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
            }
            if (dimCount == 0) {
                if (lexer.getTokenType() == JavaTokenType.LBRACE) {
                    CompositeElement initializer = this.parseArrayInitializerExpression(lexer);
                    if (initializer != null) {
                        element.rawAddChildren(initializer);
                    }
                } else {
                    element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.array.initializer", new Object[0])));
                }
            }
        }
        return element;
    }

    private CompositeElement parseClassObjectAccessExpression(Lexer lexer) {
        LexerPosition pos = lexer.getCurrentPosition();
        CompositeElement type = this.parseType(lexer, false, false);
        if (type == null) {
            return null;
        }
        if (lexer.getTokenType() != JavaTokenType.DOT) {
            lexer.restore(pos);
            return null;
        }
        TreeElement dot = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
        lexer.advance();
        if (lexer.getTokenType() != JavaTokenType.CLASS_KEYWORD) {
            lexer.restore(pos);
            return null;
        }
        CompositeElement element = ASTFactory.composite(JavaElementType.CLASS_OBJECT_ACCESS_EXPRESSION);
        element.rawAddChildren(type);
        element.rawAddChildren(dot);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        return element;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public CompositeElement parseArgumentList(Lexer lexer) {
        CompositeElement compositeElement;
        if (lexer.getTokenType() != JavaTokenType.LPARENTH) {
            compositeElement = ASTFactory.composite(JavaElementType.EXPRESSION_LIST);
            if (compositeElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/parsing/ExpressionParsing.parseArgumentList must not return null");
            return compositeElement;
        }
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.LPARENTH);
        CompositeElement element = ASTFactory.composite(JavaElementType.EXPRESSION_LIST);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        boolean first = true;
        while (!(first && (lexer.getTokenType() == JavaTokenType.RPARENTH || lexer.getTokenType() == JavaTokenType.RBRACE || lexer.getTokenType() == JavaTokenType.RBRACKET) || !first && ExpressionParsing.isArgListFinished(lexer))) {
            boolean errored = false;
            if (!first) {
                if (lexer.getTokenType() == JavaTokenType.COMMA) {
                    element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                    lexer.advance();
                } else {
                    errored = true;
                    element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.comma.or.rparen", new Object[0])));
                    element.rawAddChildren(ASTFactory.composite(JavaElementType.EMPTY_EXPRESSION));
                }
            }
            first = false;
            CompositeElement arg = this.parseExpression(lexer);
            if (arg == null) {
                if (!errored) {
                    element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
                    element.rawAddChildren(ASTFactory.composite(JavaElementType.EMPTY_EXPRESSION));
                }
                if (ExpressionParsing.isArgListFinished(lexer)) break;
                if (lexer.getTokenType() == JavaTokenType.COMMA) continue;
                element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                continue;
            }
            element.rawAddChildren(arg);
        }
        if (lexer.getTokenType() == JavaTokenType.RPARENTH) {
            element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        } else {
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rparen", new Object[0])));
            element.putUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY, "");
        }
        if ((compositeElement = element) != null) return compositeElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/parsing/ExpressionParsing.parseArgumentList must not return null");
    }

    public static boolean isArgListFinished(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        return type != JavaTokenType.IDENTIFIER && type != TokenType.BAD_CHARACTER && type != JavaTokenType.COMMA && type != JavaTokenType.INTEGER_LITERAL && type != JavaTokenType.STRING_LITERAL;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CompositeElement parseArrayInitializerExpression(Lexer lexer) {
        if (lexer.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        CompositeElement element = ASTFactory.composite(JavaElementType.ARRAY_INITIALIZER_EXPRESSION);
        element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        boolean firstExpressionMissing = false;
        while (true) {
            CompositeElement arg;
            if (lexer.getTokenType() == JavaTokenType.RBRACE) {
                element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                return element;
            }
            if (lexer.getTokenType() == null) {
                element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rbrace", new Object[0])));
                element.putUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY, "");
                return element;
            }
            if (firstExpressionMissing) {
                element.getLastChildNode().rawInsertBeforeMe(Factory.createErrorElement(JavaErrorMessages.message("expected.expression", new Object[0])));
            }
            if ((arg = this.parseExpression(lexer)) == null) {
                if (lexer.getTokenType() != JavaTokenType.COMMA) {
                    element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.rbrace", new Object[0])));
                    element.putUserData(TreeUtil.UNCLOSED_ELEMENT_PROPERTY, "");
                    return element;
                }
                firstExpressionMissing = true;
            } else {
                element.rawAddChildren(arg);
            }
            if (lexer.getTokenType() == JavaTokenType.RBRACE) {
                element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                return element;
            }
            if (lexer.getTokenType() == JavaTokenType.COMMA) {
                element.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
                lexer.advance();
                continue;
            }
            element.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.comma", new Object[0])));
        }
    }
}

