/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.StdLanguages;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.GlobalSearchScope;

public class JavaLikeSourceFilterScope
extends JavaSourceFilterScope {
    private final GlobalSearchScope myDelegate;
    private final ProjectFileIndex myIndex;

    public JavaLikeSourceFilterScope(GlobalSearchScope delegate, Project project) {
        super(delegate, project);
        this.myDelegate = delegate;
        this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    @Override
    public boolean contains(VirtualFile file) {
        if (this.myDelegate != null && !this.myDelegate.contains(file)) {
            return false;
        }
        FileType fileType = file.getFileType();
        return JavaLikeSourceFilterScope.isJavaLikeFile(fileType) && this.myIndex.isInSourceContent(file) || StdFileTypes.CLASS == fileType && this.myIndex.isInLibraryClasses(file);
    }

    private static boolean isJavaLikeFile(FileType fileType) {
        return StdFileTypes.JAVA == fileType || fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getLanguage().isKindOf(StdLanguages.JAVA);
    }
}

