/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;

public class ConstructorReferencesSearchHelper {
    private final PsiManager myManager;

    public ConstructorReferencesSearchHelper(PsiManager manager) {
        this.myManager = manager;
    }

    public boolean processConstructorReferences(final Processor<PsiReference> processor, final PsiMethod constructor, final SearchScope searchScope, boolean ignoreAccessScope, final boolean isStrictSignatureSearch) {
        boolean constructorCanBeCalledImplicitly;
        final Ref result = new Ref();
        PsiClass aClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                PsiClass aClass = constructor.getContainingClass();
                if (aClass == null) {
                    result.set((Object)true);
                    return null;
                }
                if (aClass.isEnum()) {
                    PsiField[] fields;
                    for (PsiField field : fields = aClass.getFields()) {
                        PsiReference reference;
                        if (!(field instanceof PsiEnumConstant) || (reference = field.getReference()) == null || !reference.isReferenceTo((PsiElement)constructor) || processor.process((Object)reference)) continue;
                        result.set((Object)false);
                        return null;
                    }
                }
                return aClass;
            }
        });
        if (!result.isNull()) {
            return (Boolean)result.get();
        }
        ReadActionProcessor<PsiReference> processor1 = new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference reference) {
                PsiMethod constructor1;
                PsiElement parent = reference.getElement().getParent();
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiNewExpression && (constructor1 = ((PsiNewExpression)parent).resolveConstructor()) != null && (isStrictSignatureSearch ? ConstructorReferencesSearchHelper.this.myManager.areElementsEquivalent((PsiElement)constructor, (PsiElement)constructor1) : ConstructorReferencesSearchHelper.this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)constructor1.getContainingClass()))) {
                    return processor.process((Object)reference);
                }
                return true;
            }
        };
        if (!ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope, (boolean)ignoreAccessScope).forEach((Processor)processor1)) {
            return false;
        }
        boolean bl = constructorCanBeCalledImplicitly = constructor.getParameterList().getParametersCount() == 0;
        if (!this.processSuperOrThis(processor, aClass, constructor, constructorCanBeCalledImplicitly, searchScope, isStrictSignatureSearch, "this")) {
            return false;
        }
        Processor<PsiClass> processor2 = new Processor<PsiClass>(){

            public boolean process(PsiClass inheritor) {
                return ConstructorReferencesSearchHelper.this.processSuperOrThis((Processor<PsiReference>)processor, (PsiClass)inheritor.getNavigationElement(), constructor, constructorCanBeCalledImplicitly, searchScope, isStrictSignatureSearch, "super");
            }
        };
        return ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)searchScope, (boolean)false).forEach((Processor)processor2);
    }

    private boolean processSuperOrThis(final Processor<PsiReference> processor, final PsiClass inheritor, final PsiMethod constructor, final boolean constructorCanBeCalledImplicitly, final SearchScope searchScope, final boolean isStrictSignatureSearch, final String superOrThisKeyword) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ConstructorReferencesSearchHelper.this.processSuperOrThisInReadAction(inheritor, searchScope, superOrThisKeyword, isStrictSignatureSearch, constructor, constructorCanBeCalledImplicitly, (Processor<PsiReference>)processor);
            }
        });
    }

    private boolean processSuperOrThisInReadAction(PsiClass inheritor, SearchScope searchScope, String superOrThisKeyword, boolean isStrictSignatureSearch, PsiMethod constructor, boolean constructorCanBeCalledImplicitly, Processor<PsiReference> processor) {
        PsiMethod[] constructors = inheritor.getConstructors();
        if (constructors.length == 0 && constructorCanBeCalledImplicitly) {
            this.processImplicitConstructorCall((PsiMember)inheritor, processor, constructor, inheritor);
        }
        for (PsiMethod method : constructors) {
            PsiReferenceExpression refExpr;
            PsiExpression expr;
            PsiStatement statement;
            PsiCodeBlock body = method.getBody();
            if (body == null) continue;
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 0 && (statement = statements[0]) instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiMethodCallExpression && PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)(refExpr = ((PsiMethodCallExpression)expr).getMethodExpression())) && refExpr.getText().equals(superOrThisKeyword)) {
                boolean match;
                PsiElement referencedElement = refExpr.resolve();
                if (!(referencedElement instanceof PsiMethod)) continue;
                PsiMethod constructor1 = (PsiMethod)referencedElement;
                boolean bl = match = isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)constructor1, (PsiElement)constructor) : this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)constructor1.getContainingClass());
                if (!match || processor.process((Object)refExpr)) continue;
                return false;
            }
            if (!constructorCanBeCalledImplicitly) continue;
            this.processImplicitConstructorCall((PsiMember)method, processor, constructor, inheritor);
        }
        return true;
    }

    private void processImplicitConstructorCall(final PsiMember usage, Processor<PsiReference> processor, PsiMethod constructor, PsiClass containingClass) {
        if (containingClass instanceof PsiAnonymousClass) {
            return;
        }
        PsiClass superClass = containingClass.getSuperClass();
        if (this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)superClass)) {
            processor.process((Object)new LightMemberReference(this.myManager, usage, PsiSubstitutor.EMPTY){

                @Override
                public PsiElement getElement() {
                    return usage;
                }

                @Override
                public TextRange getRangeInElement() {
                    if (usage instanceof PsiClass) {
                        PsiIdentifier identifier = ((PsiClass)usage).getNameIdentifier();
                        if (identifier != null) {
                            return TextRange.from((int)identifier.getStartOffsetInParent(), (int)identifier.getTextLength());
                        }
                    } else {
                        PsiIdentifier identifier;
                        if (usage instanceof PsiField) {
                            PsiIdentifier identifier2 = ((PsiField)usage).getNameIdentifier();
                            return TextRange.from((int)identifier2.getStartOffsetInParent(), (int)identifier2.getTextLength());
                        }
                        if (usage instanceof PsiMethod && (identifier = ((PsiMethod)usage).getNameIdentifier()) != null) {
                            return TextRange.from((int)identifier.getStartOffsetInParent(), (int)identifier.getTextLength());
                        }
                    }
                    return super.getRangeInElement();
                }
            });
        }
    }
}

