/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightTypeElement
extends LightElement
implements PsiTypeElement {
    private final PsiType myType;

    public LightTypeElement(PsiManager manager, PsiType type) {
        super(manager, StdFileTypes.JAVA.getLanguage());
        this.myType = type = PsiUtil.convertAnonymousToBaseType((PsiType)type);
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    public String getText() {
        return this.myType.getPresentableText();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightTypeElement.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement copy() {
        return new LightTypeElement(this.myManager, this.myType);
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myType;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightTypeElement.getType must not return null");
        }
        return psiType;
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        return null;
    }

    public PsiAnnotationOwner getOwner(PsiAnnotation annotation) {
        return this;
    }

    public PsiType getTypeNoResolve(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightTypeElement.getTypeNoResolve must not be null");
        }
        return this.getType();
    }

    @Override
    public boolean isValid() {
        return this.myType.isValid();
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.myType.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightTypeElement.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightTypeElement.findAnnotation must not be null");
        }
        return this.myType.findAnnotation(qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightTypeElement.addAnnotation must not be null");
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightTypeElement.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }
}

