/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import org.jetbrains.annotations.NotNull;

public class PsiDirectoryFactoryImpl
extends PsiDirectoryFactory {
    private final PsiManagerImpl myManager;

    public PsiDirectoryFactoryImpl(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    @Override
    public PsiDirectory createDirectory(VirtualFile file) {
        return new PsiDirectoryImpl(this.myManager, file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getQualifiedName(@NotNull PsiDirectory directory, boolean presentable) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryFactoryImpl.getQualifiedName must not be null");
        }
        if (!presentable) return "";
        String string = directory.getVirtualFile().getPresentableUrl();
        String string2 = string;
        if (string != null) return string2;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryFactoryImpl.getQualifiedName must not return null");
    }

    @Override
    public boolean isPackage(PsiDirectory directory) {
        return false;
    }

    @Override
    public boolean isValidPackageName(String name) {
        return true;
    }
}

