/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBinaryFileImpl
extends PsiElementBase
implements PsiBinaryFile,
Cloneable,
Queryable {
    private final PsiManagerImpl myManager;
    private String myName;
    private byte[] myContents;
    private final long myModificationStamp;
    private final FileType myFileType;
    private final FileViewProvider myViewProvider;

    public PsiBinaryFileImpl(PsiManagerImpl manager, FileViewProvider viewProvider) {
        this.myViewProvider = viewProvider;
        this.myManager = manager;
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        this.myModificationStamp = virtualFile.getModificationStamp();
        this.myFileType = viewProvider.getVirtualFile().getFileType();
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getVirtualFile must not return null");
        }
        return virtualFile;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    public byte[] getStoredContents() {
        return this.myContents;
    }

    @NotNull
    public String getName() {
        String string = !this.isCopy() ? this.getVirtualFile().getName() : this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getName must not return null");
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.setName must not be null");
        }
        this.checkSetName(name);
        if (this.isCopy()) {
            this.myName = name;
            return this;
        }
        return PsiFileImplUtil.setName((PsiFile)this, name);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        if (this.isCopy()) {
            return;
        }
        PsiFileImplUtil.checkSetName((PsiFile)this, name);
    }

    public boolean isDirectory() {
        return false;
    }

    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        return this.getContainingDirectory();
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getLanguage must not return null");
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    public PsiFile getContainingFile() {
        return this;
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    public String getText() {
        return "";
    }

    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.textToCharArray must not return null");
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.textMatches must not be null");
        }
        return false;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.textMatches must not be null");
        }
        return false;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.accept must not be null");
        }
        visitor.visitBinaryFile((PsiBinaryFile)this);
    }

    public PsiElement copy() {
        PsiBinaryFileImpl clone = (PsiBinaryFileImpl)this.clone();
        clone.myName = this.getName();
        try {
            clone.myContents = !this.isCopy() ? this.getVirtualFile().contentsToByteArray() : this.myContents;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return clone;
    }

    private boolean isCopy() {
        return this.myName != null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.add must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.addBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.addAfter must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.checkAdd must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete((PsiFile)this);
    }

    public void checkDelete() throws IncorrectOperationException {
        if (this.isCopy()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.replace must not be null");
        }
        return null;
    }

    public boolean isValid() {
        if (this.isCopy()) {
            return true;
        }
        return this.getVirtualFile().isValid() && !this.myManager.getProject().isDisposed() && this.myManager.getFileManager().findFile(this.getVirtualFile()) == this;
    }

    public boolean isWritable() {
        return this.isCopy() || this.getVirtualFile().isWritable();
    }

    public boolean isPhysical() {
        return !this.isCopy();
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiBinaryFileImpl psiBinaryFileImpl = this;
        if (psiBinaryFileImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getOriginalFile must not return null");
        }
        return psiBinaryFileImpl;
    }

    @NonNls
    public String toString() {
        return "PsiBinaryFile:" + this.getName();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getFileType must not return null");
        }
        return fileType;
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getPsiRoots must not return null");
        }
        return psiFileArray;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getViewProvider must not return null");
        }
        return fileViewProvider;
    }

    public ASTNode getNode() {
        return null;
    }

    public void subtreeChanged() {
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext((PsiFile)this);
    }

    public void putInfo(Map<String, String> info) {
        info.put("fileName", this.getName());
        info.put("fileType", this.getFileType().getName());
    }
}

