/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsEnumConstantImpl;
import com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsClassImpl
extends ClsRepositoryPsiElement<PsiClassStub<?>>
implements PsiClass,
PsiQualifiedNamedElement,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsClassImpl");
    private final ClassInnerStuffCache innersCache = new ClassInnerStuffCache(this);
    private final PsiIdentifier myNameIdentifier;
    private final PsiDocComment myDocComment = this.isDeprecated() ? new ClsDocCommentImpl((PsiDocCommentOwner)this) : null;

    public ClsClassImpl(PsiClassStub stub) {
        super(stub);
        this.myNameIdentifier = new ClsIdentifierImpl(this, this.getShortName());
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiIdentifier name = this.getNameIdentifier();
        PsiDocComment docComment = this.getDocComment();
        PsiModifierList modifierList = this.getModifierList();
        PsiReferenceList extendsList = this.getExtendsList();
        PsiReferenceList implementsList = this.getImplementsList();
        PsiField[] fields = this.getFields();
        PsiMethod[] methods = this.getMethods();
        PsiClass[] classes = this.getInnerClasses();
        int count = (docComment != null ? 1 : 0) + 1 + 1 + 1 + 1 + fields.length + methods.length + classes.length;
        PsiElement[] children = new PsiElement[count];
        int offset = 0;
        if (docComment != null) {
            children[offset++] = docComment;
        }
        children[offset++] = modifierList;
        children[offset++] = name;
        children[offset++] = extendsList;
        children[offset++] = implementsList;
        System.arraycopy(fields, 0, children, offset, fields.length);
        System.arraycopy(methods, 0, children, offset += fields.length, methods.length);
        System.arraycopy(classes, 0, children, offset += methods.length, classes.length);
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getChildren must not return null");
        }
        return children;
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = this.myNameIdentifier;
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    private String getShortName() {
        String qName = this.getQualifiedName();
        String name = PsiNameHelper.getShortClassName((String)qName);
        if (name.length() == 0) {
            name = "_";
        }
        return name;
    }

    @NotNull
    public String getName() {
        String string = ((PsiClassStub)this.getStub()).getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getName must not return null");
        }
        return string;
    }

    @NotNull
    public PsiTypeParameterList getTypeParameterList() {
        PsiTypeParameterList psiTypeParameterList = (PsiTypeParameterList)((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST).getPsi();
        if (psiTypeParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getTypeParameterList must not return null");
        }
        return psiTypeParameterList;
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    @NotNull
    public String getQualifiedName() {
        String string = ((PsiClassStub)this.getStub()).getQualifiedName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getQualifiedName must not return null");
        }
        return string;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = (PsiModifierList)((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST).getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @NotNull
    public PsiReferenceList getExtendsList() {
        PsiReferenceList psiReferenceList = (PsiReferenceList)((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.EXTENDS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getExtendsList must not return null");
        }
        return psiReferenceList;
    }

    @NotNull
    public PsiReferenceList getImplementsList() {
        PsiReferenceList psiReferenceList = (PsiReferenceList)((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.IMPLEMENTS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getImplementsList must not return null");
        }
        return psiReferenceList;
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getExtendsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getImplementsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    public PsiClass[] getInterfaces() {
        return PsiClassImplUtil.getInterfaces(this);
    }

    @NotNull
    public PsiClass[] getSupers() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getSupers must not return null");
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getSuperTypes must not return null");
        }
        return psiClassTypeArray;
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection<HierarchicalMethodSignature> collection = PsiSuperMethodImplUtil.getVisibleSignatures(this);
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getVisibleSignatures must not return null");
        }
        return collection;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = (PsiField[])((PsiClassStub)this.getStub()).getChildrenByType(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getFields must not return null");
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = (PsiMethod[])((PsiClassStub)this.getStub()).getChildrenByType(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = PsiImplUtil.getConstructors(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getConstructors must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = (PsiClass[])((PsiClassStub)this.getStub()).getChildrenByType((IElementType)JavaStubElementTypes.CLASS, ARRAY_FACTORY);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getInitializers must not return null");
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllFields must not return null");
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllInnerClasses must not return null");
        }
        return psiClassArray;
    }

    public PsiField findFieldByName(String name, boolean checkBases) {
        return this.innersCache.findFieldByName(name, checkBases);
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.findMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.innersCache.findMethodsByName(name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.findMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.findMethodsAndTheirSubstitutorsByName must not return null");
        }
        return list;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiMethod.class);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllMethodsAndTheirSubstitutors must not return null");
        }
        return list;
    }

    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return this.innersCache.findInnerClassByName(name, checkBases);
    }

    public boolean isDeprecated() {
        return ((PsiClassStub)this.getStub()).isDeprecated();
    }

    public String getSourceFileName() {
        String sfn = ((PsiClassStub)this.getStub()).getSourceFileName();
        return sfn != null ? sfn : this.obtainSourceFileNameFromClassFileName();
    }

    @NonNls
    private String obtainSourceFileNameFromClassFileName() {
        String name = this.getContainingFile().getName();
        int i = name.indexOf(36);
        if (i < 0 && (i = name.indexOf(46)) < 0) {
            i = name.length();
        }
        return name.substring(0, i) + ".java";
    }

    public PsiDocComment getDocComment() {
        return this.myDocComment;
    }

    public PsiJavaToken getLBrace() {
        return null;
    }

    public PsiJavaToken getRBrace() {
        return null;
    }

    public boolean isInterface() {
        return ((PsiClassStub)this.getStub()).isInterface();
    }

    public boolean isAnnotationType() {
        return ((PsiClassStub)this.getStub()).isAnnotationType();
    }

    public boolean isEnum() {
        return ((PsiClassStub)this.getStub()).isEnum();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NonNls StringBuffer buffer) {
        PsiClass[] classes;
        PsiMethod[] methods;
        ClsDocCommentImpl docComment = (ClsDocCommentImpl)this.getDocComment();
        if (docComment != null) {
            docComment.appendMirrorText(indentLevel, buffer);
            ClsClassImpl.goNextLine(indentLevel, buffer);
        }
        ((ClsElementImpl)this.getModifierList()).appendMirrorText(indentLevel, buffer);
        buffer.append(this.isEnum() ? "enum " : (this.isAnnotationType() ? "@interface " : (this.isInterface() ? "interface " : "class ")));
        ((ClsElementImpl)this.getNameIdentifier()).appendMirrorText(indentLevel, buffer);
        ((ClsElementImpl)this.getTypeParameterList()).appendMirrorText(indentLevel, buffer);
        buffer.append(' ');
        if (!this.isEnum() && !this.isAnnotationType()) {
            ((ClsElementImpl)this.getExtendsList()).appendMirrorText(indentLevel, buffer);
            buffer.append(' ');
        }
        if (!this.isInterface()) {
            ((ClsElementImpl)this.getImplementsList()).appendMirrorText(indentLevel, buffer);
        }
        buffer.append('{');
        int newIndentLevel = indentLevel + this.getIndentSize();
        PsiField[] fields = this.getFields();
        if (fields.length > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (int i = 0; i < fields.length; ++i) {
                PsiField field = fields[i];
                ((ClsElementImpl)field).appendMirrorText(newIndentLevel, buffer);
                if (field instanceof ClsEnumConstantImpl) {
                    if (i < fields.length - 1 && fields[i + 1] instanceof ClsEnumConstantImpl) {
                        buffer.append(", ");
                        continue;
                    }
                    buffer.append(";");
                    if (i >= fields.length - 1) continue;
                    ClsClassImpl.goNextLine(newIndentLevel, buffer);
                    continue;
                }
                if (i >= fields.length - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        if ((methods = this.getMethods()).length > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (int i = 0; i < methods.length; ++i) {
                PsiMethod method = methods[i];
                ((ClsElementImpl)method).appendMirrorText(newIndentLevel, buffer);
                if (i >= methods.length - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        if ((classes = this.getInnerClasses()).length > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (int i = 0; i < classes.length; ++i) {
                PsiClass aClass = classes[i];
                ((ClsElementImpl)aClass).appendMirrorText(newIndentLevel, buffer);
                if (i >= classes.length - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        ClsClassImpl.goNextLine(indentLevel, buffer);
        buffer.append('}');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        PsiClass[] mirrorClasses;
        PsiClass[] classes;
        PsiMethod[] mirrorMethods;
        PsiMethod[] methods;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiClass mirror = (PsiClass)SourceTreeToPsiMap.treeElementToPsi(element);
        PsiDocComment docComment = this.getDocComment();
        if (docComment != null) {
            ((ClsElementImpl)docComment).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getDocComment()));
        }
        ((ClsElementImpl)this.getModifierList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getModifierList()));
        ((ClsElementImpl)this.getNameIdentifier()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getNameIdentifier()));
        if (!this.isAnnotationType() && !this.isEnum()) {
            ((ClsElementImpl)this.getExtendsList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getExtendsList()));
        }
        ((ClsElementImpl)this.getImplementsList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getImplementsList()));
        ((ClsElementImpl)this.getTypeParameterList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getTypeParameterList()));
        PsiField[] fields = this.getFields();
        PsiField[] mirrorFields = mirror.getFields();
        if (LOG.assertTrue(fields.length == mirrorFields.length)) {
            for (int i = 0; i < fields.length; ++i) {
                ((ClsElementImpl)fields[i]).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirrorFields[i]));
            }
        }
        if (LOG.assertTrue((methods = this.getMethods()).length == (mirrorMethods = mirror.getMethods()).length)) {
            for (int i = 0; i < methods.length; ++i) {
                ((ClsElementImpl)methods[i]).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirrorMethods[i]));
            }
        }
        if (LOG.assertTrue((classes = this.getInnerClasses()).length == (mirrorClasses = mirror.getInnerClasses()).length)) {
            for (int i = 0; i < classes.length; ++i) {
                ((ClsElementImpl)classes[i]).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirrorClasses[i]));
            }
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass((PsiClass)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiClass:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.processDeclarations must not be null");
        }
        return PsiClassImplUtil.processDeclarationsInClass(this, processor, state, null, lastParent, place, false);
    }

    public PsiElement getScope() {
        return this.getParent();
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.isInheritor must not be null");
        }
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    public PsiClass getSourceMirrorClass() {
        PsiElement parent = this.getParent();
        String name = this.getName();
        if (parent instanceof PsiFile) {
            PsiClassOwner fileNavigationElement = (PsiClassOwner)parent.getNavigationElement();
            for (PsiClass aClass : fileNavigationElement.getClasses()) {
                if (!name.equals(aClass.getName())) continue;
                return aClass;
            }
        } else if (parent != null) {
            PsiClass[] innerClasses;
            ClsClassImpl parentClass = (ClsClassImpl)parent;
            PsiClass parentSourceMirror = parentClass.getSourceMirrorClass();
            if (parentSourceMirror == null) {
                return null;
            }
            for (PsiClass innerClass : innerClasses = parentSourceMirror.getInnerClasses()) {
                if (!name.equals(innerClass.getName())) continue;
                return innerClass;
            }
        } else {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiClass aClass = this.getSourceMirrorClass();
        Object object = aClass != null ? aClass : this;
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getNavigationElement must not return null");
        }
        return object;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ClassPresentationUtil.getPresentation(this);
    }

    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiClassImplUtil.getClassUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    public PsiQualifiedNamedElement getContainer() {
        PsiDirectory dir;
        PsiFile file = this.getContainingFile();
        return file == null ? null : ((dir = file.getContainingDirectory()) == null ? null : JavaDirectoryService.getInstance().getPackage(dir));
    }

    public void putInfo(Map<String, String> info) {
        PsiClassImpl.putInfo(this, info);
    }
}

