/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsArrayInitializerMemberValueImpl
extends ClsElementImpl
implements PsiArrayInitializerMemberValue {
    private final ClsElementImpl myParent;
    private final PsiAnnotationMemberValue[] myInitializers;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl");

    public ClsArrayInitializerMemberValueImpl(ClsElementImpl parent, PsiAnnotationMemberValue[] initializers) {
        this.myParent = parent;
        this.myInitializers = initializers;
    }

    @Override
    public String getText() {
        StringBuffer buffer = new StringBuffer();
        this.appendMirrorText(0, buffer);
        return buffer.toString();
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        buffer.append('{');
        for (int i = 0; i < this.myInitializers.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            ((ClsElementImpl)this.myInitializers[i]).appendMirrorText(0, buffer);
        }
        buffer.append('}');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsArrayInitializerMemberValueImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiArrayInitializerMemberValue mirror = (PsiArrayInitializerMemberValue)SourceTreeToPsiMap.treeElementToPsi(element);
        PsiAnnotationMemberValue[] initializers = mirror.getInitializers();
        LOG.assertTrue(this.myInitializers.length == initializers.length);
        for (int i = 0; i < this.myInitializers.length; ++i) {
            ClsElementImpl value = (ClsElementImpl)this.myInitializers[i];
            value.setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)initializers[i]));
        }
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (this.myInitializers == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsArrayInitializerMemberValueImpl.getChildren must not return null");
        }
        return this.myInitializers;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsArrayInitializerMemberValueImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationArrayInitializer((PsiArrayInitializerMemberValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiAnnotationMemberValue[] getInitializers() {
        if (this.myInitializers == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsArrayInitializerMemberValueImpl.getInitializers must not return null");
        }
        return this.myInitializers;
    }
}

