/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsAnnotationImpl
extends ClsRepositoryPsiElement<PsiAnnotationStub>
implements PsiAnnotation,
Navigatable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.compiled.ClsAnnotationImpl");
    private ClsJavaCodeReferenceElementImpl myReferenceElement;
    private ClsAnnotationParameterListImpl myParameterList;
    private final Object lock = new Object();

    public ClsAnnotationImpl(PsiAnnotationStub stub) {
        super(stub);
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        buffer.append("@").append(this.getReferenceElement().getCanonicalText());
        ((ClsAnnotationParameterListImpl)this.getParameterList()).appendMirrorText(indentLevel, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsAnnotationImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiAnnotation mirror = (PsiAnnotation)SourceTreeToPsiMap.treeElementToPsi(element);
        ((ClsElementImpl)this.getParameterList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getParameterList()));
        ((ClsElementImpl)this.getNameReferenceElement()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getNameReferenceElement()));
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.getReferenceElement(), this.getParameterList()};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsAnnotationImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation((PsiAnnotation)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        Object object = this.lock;
        // MONITORENTER : object
        if (this.myParameterList == null) {
            PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
            CompositeElement mirror = stub.getTreeElement();
            PsiAnnotationParameterList paramList = (PsiAnnotationParameterList)mirror.findChildByRoleAsPsiElement(14);
            this.myParameterList = new ClsAnnotationParameterListImpl(this, paramList.getAttributes());
        }
        ClsAnnotationParameterListImpl clsAnnotationParameterListImpl = this.myParameterList;
        // MONITOREXIT : object
        if (clsAnnotationParameterListImpl != null) return clsAnnotationParameterListImpl;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationImpl.getParameterList must not return null");
    }

    @Nullable
    public String getQualifiedName() {
        if (this.getReferenceElement() == null) {
            return null;
        }
        return this.getReferenceElement().getCanonicalText();
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        return this.getReferenceElement();
    }

    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, T value) {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public String getText() {
        StringBuffer buffer = new StringBuffer();
        this.appendMirrorText(0, buffer);
        return buffer.toString();
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClsJavaCodeReferenceElementImpl getReferenceElement() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myReferenceElement == null) {
                PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
                CompositeElement mirror = stub.getTreeElement();
                this.myReferenceElement = new ClsJavaCodeReferenceElementImpl(this, mirror.findChildByRole(119).getText());
            }
            return this.myReferenceElement;
        }
    }

    public PsiAnnotationOwner getOwner() {
        return (PsiAnnotationOwner)this.getParent();
    }
}

