/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiBundle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class VfsIndexer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.cache.impl.VfsIndexer");

    public static VirtualFile[] writeFileIndex(OutputStream stream, VirtualFile root, VirtualFileFilter filter) throws IOException {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText2(PsiBundle.message((String)"psi.scanning.files.in.folder.progress", (Object[])new Object[]{root.getPresentableUrl()}));
        }
        DataOutputStream out = stream == null ? null : new DataOutputStream(stream);
        VfsIndexer._writeFileIndex(out, root, filter, result);
        if (out != null) {
            out.flush();
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    private static void _writeFileIndex(DataOutputStream out, VirtualFile file, VirtualFileFilter filter, List<VirtualFile> result) throws IOException {
        VirtualFile[] children;
        ProgressManager.checkCanceled();
        result.add(file);
        if (out != null) {
            out.writeUTF(file.getName());
        }
        if ((children = file.getChildren()) == null) {
            if (out != null) {
                out.writeInt(0);
            }
            return;
        }
        int childrenCount = 0;
        for (VirtualFile child : children) {
            if (!filter.accept(child)) continue;
            ++childrenCount;
        }
        if (out != null) {
            out.writeInt(childrenCount);
        }
        for (VirtualFile child : children) {
            if (!filter.accept(child)) continue;
            VfsIndexer._writeFileIndex(out, child, filter, result);
        }
    }

    public static VirtualFile[] readFileIndex(InputStream stream, VirtualFile root, VirtualFileFilter filter) throws IOException {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        DataInputStream in = new DataInputStream(stream);
        String rootName = in.readUTF();
        LOG.assertTrue(root.getName().equals(rootName));
        VfsIndexer._readFileIndex(in, root, filter, result);
        return VfsUtil.toVirtualFileArray(result);
    }

    private static void _readFileIndex(DataInputStream in, VirtualFile file, VirtualFileFilter filter, List<VirtualFile> result) throws IOException {
        ProgressManager.checkCanceled();
        result.add(file);
        int childrenCount = in.readInt();
        if (childrenCount == 0) {
            return;
        }
        for (int i = 0; i < childrenCount; ++i) {
            VirtualFile child;
            String name = in.readUTF();
            VirtualFile virtualFile = child = file != null ? file.findChild(name) : null;
            if (child != null && !filter.accept(child)) {
                child = null;
            }
            VfsIndexer._readFileIndex(in, child, filter, result);
        }
    }
}

