/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;

public class TextBlock
extends DocumentAdapter {
    private Document myDocument;
    private int myStartOffset = -1;
    private int myTextEndOffset = -1;
    private int myPsiEndOffset = -1;
    private boolean myIsLocked = false;

    public boolean isEmpty() {
        return this.myStartOffset == -1;
    }

    public void clear() {
        this.myStartOffset = -1;
        this.myDocument = null;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getTextEndOffset() {
        return this.myTextEndOffset;
    }

    public void lock() {
        this.myIsLocked = true;
    }

    public void unlock() {
        this.myIsLocked = false;
    }

    public boolean isLocked() {
        return this.myIsLocked;
    }

    public int getPsiEndOffset() {
        return this.myPsiEndOffset;
    }

    public void documentChanged(DocumentEvent e) {
        this.myDocument = e.getDocument();
        assert (!this.myIsLocked);
        int offset = e.getOffset();
        if (this.isEmpty()) {
            this.myStartOffset = offset;
            this.myTextEndOffset = offset + e.getNewLength();
            this.myPsiEndOffset = offset + e.getOldLength();
        } else {
            int shift = offset + e.getOldLength() - this.myTextEndOffset;
            if (shift > 0) {
                this.myPsiEndOffset += shift;
                this.myTextEndOffset = offset + e.getNewLength();
            } else {
                this.myTextEndOffset += e.getNewLength() - e.getOldLength();
            }
            this.myStartOffset = Math.min(this.myStartOffset, offset);
        }
    }
}

