/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CodeBlockBlock
extends AbstractJavaBlock {
    private static final int BEFORE_FIRST = 0;
    private static final int BEFORE_LBRACE = 1;
    private static final int INSIDE_BODY = 2;
    private final int myChildrenIndent;

    public CodeBlockBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CodeStyleSettings settings) {
        super(node, wrap, alignment, indent, settings);
        this.myChildrenIndent = this.isSwitchCodeBlock() && !settings.INDENT_CASE_FROM_SWITCH ? 0 : 1;
    }

    private boolean isSwitchCodeBlock() {
        return this.myNode.getTreeParent().getElementType() == ElementType.SWITCH_STATEMENT;
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        Alignment childAlignment = this.createChildAlignment();
        Wrap childWrap = this.createChildWrap();
        this.buildChildren(result, childAlignment, childWrap);
        return result;
    }

    private void buildChildren(ArrayList<Block> result, Alignment childAlignment, Wrap childWrap) {
        ASTNode child = this.myNode.getFirstChildNode();
        int state = 0;
        if (this.myNode.getPsi() instanceof JspClass) {
            state = 2;
        }
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                Indent indent = this.calcCurrentIndent(child, state);
                state = this.calcNewState(child, state);
                child = child.getElementType() == ElementType.SWITCH_LABEL_STATEMENT ? this.processCaseAndStatementAfter(result, child, childAlignment, childWrap, indent) : (this.myNode.getElementType() == ElementType.CLASS && child.getElementType() == ElementType.LBRACE ? this.composeCodeBlock(result, child, this.getCodeBlockExternalIndent()) : this.processChild(result, child, childAlignment, childWrap, indent));
            }
            if (child == null) continue;
            child = child.getTreeNext();
        }
    }

    private ASTNode composeCodeBlock(ArrayList<Block> result, ASTNode child, Indent indent) {
        ArrayList<Block> localResult = new ArrayList<Block>();
        this.processChild(localResult, child, null, null, Indent.getNoneIndent());
        child = child.getTreeNext();
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child)) {
                boolean rBrace = this.isRBrace(child);
                Indent childIndent = rBrace ? Indent.getNoneIndent() : this.getCodeBlockInternalIndent(this.myChildrenIndent);
                child = this.processChild(localResult, child, null, null, childIndent);
                if (rBrace) {
                    result.add(this.createCodeBlockBlock(localResult, indent));
                    return child;
                }
            }
            if (child == null) continue;
            child = child.getTreeNext();
        }
        result.add(this.createCodeBlockBlock(localResult, indent));
        return null;
    }

    private SyntheticCodeBlock createCodeBlockBlock(ArrayList<Block> localResult, Indent indent) {
        SyntheticCodeBlock result = new SyntheticCodeBlock(localResult, null, this.getSettings(), indent, null);
        result.setChildAttributes(new ChildAttributes(this.getCodeBlockInternalIndent(this.myChildrenIndent), null));
        return result;
    }

    private ASTNode processCaseAndStatementAfter(ArrayList<Block> result, ASTNode child, Alignment childAlignment, Wrap childWrap, Indent indent) {
        ArrayList<Block> localResult = new ArrayList<Block>();
        this.processChild(localResult, child, null, null, Indent.getNoneIndent());
        Indent childIndent = Indent.getNormalIndent();
        for (child = child.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == ElementType.SWITCH_LABEL_STATEMENT || this.isRBrace(child)) {
                result.add(this.createCaseSectionBlock(localResult, childAlignment, indent, childWrap));
                return child.getTreePrev();
            }
            if (FormatterUtil.containsWhiteSpacesOnly(child)) continue;
            if (child.getElementType() == ElementType.BLOCK_STATEMENT) {
                childIndent = Indent.getNoneIndent();
            }
            boolean breakOrReturn = this.isBreakOrReturn(child);
            this.processChild(localResult, child, null, null, childIndent);
            if (!breakOrReturn) continue;
            result.add(this.createCaseSectionBlock(localResult, childAlignment, indent, childWrap));
            return child;
        }
        result.add(this.createCaseSectionBlock(localResult, childAlignment, indent, childWrap));
        return null;
    }

    private boolean isBreakOrReturn(ASTNode child) {
        IElementType elementType = child.getElementType();
        return JavaElementType.BREAK_STATEMENT == elementType || JavaElementType.RETURN_STATEMENT == elementType;
    }

    private SyntheticCodeBlock createCaseSectionBlock(ArrayList<Block> localResult, Alignment childAlignment, Indent indent, Wrap childWrap) {
        SyntheticCodeBlock result = new SyntheticCodeBlock(localResult, childAlignment, this.getSettings(), indent, childWrap){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public ChildAttributes getChildAttributes(int newChildIndex) {
                ChildAttributes childAttributes;
                Block previousBlock;
                IElementType prevElementType = null;
                if (newChildIndex > 0 && (previousBlock = this.getSubBlocks().get(newChildIndex - 1)) instanceof AbstractBlock) {
                    prevElementType = ((AbstractBlock)previousBlock).getNode().getElementType();
                }
                if (prevElementType == ElementType.BLOCK_STATEMENT || prevElementType == ElementType.BREAK_STATEMENT || prevElementType == ElementType.RETURN_STATEMENT) {
                    childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
                    if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/CodeBlockBlock$1.getChildAttributes must not return null");
                    return childAttributes;
                }
                childAttributes = super.getChildAttributes(newChildIndex);
                if (childAttributes != null) return childAttributes;
                throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/CodeBlockBlock$1.getChildAttributes must not return null");
            }
        };
        result.setChildAttributes(new ChildAttributes(Indent.getNormalIndent(), null));
        result.setIsIncomplete(true);
        return result;
    }

    private int calcNewState(ASTNode child, int state) {
        switch (state) {
            case 0: {
                if (StdTokenSets.COMMENT_BIT_SET.contains(child.getElementType())) {
                    return 0;
                }
                if (this.isLBrace(child)) {
                    return 2;
                }
                return 1;
            }
            case 1: {
                if (this.isLBrace(child)) {
                    return 2;
                }
                return 1;
            }
        }
        return 2;
    }

    private boolean isLBrace(ASTNode child) {
        return child.getElementType() == ElementType.LBRACE;
    }

    private Indent calcCurrentIndent(ASTNode child, int state) {
        if (this.isRBrace(child)) {
            return Indent.getNoneIndent();
        }
        if (state == 0) {
            return Indent.getNoneIndent();
        }
        if (child.getElementType() == ElementType.SWITCH_LABEL_STATEMENT) {
            return this.getCodeBlockInternalIndent(this.myChildrenIndent);
        }
        if (state == 1) {
            if (this.isLBrace(child)) {
                return Indent.getNoneIndent();
            }
            return Indent.getContinuationIndent();
        }
        if (this.isRBrace(child)) {
            return Indent.getNoneIndent();
        }
        return this.getCodeBlockInternalIndent(this.myChildrenIndent);
    }

    private boolean isRBrace(ASTNode child) {
        return child.getElementType() == ElementType.RBRACE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        if (this.isAfter(newChildIndex, new IElementType[]{JavaDocElementType.DOC_COMMENT, JavaElementType.MODIFIER_LIST})) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/CodeBlockBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        if (this.getSubBlocks().size() == newChildIndex) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/CodeBlockBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        childAttributes = new ChildAttributes(this.getCodeBlockInternalIndent(this.myChildrenIndent), null);
        if (childAttributes != null) return childAttributes;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/CodeBlockBlock.getChildAttributes must not return null");
    }

    @Override
    protected Wrap getReservedWrap(IElementType elementType) {
        return null;
    }

    @Override
    protected void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
    }
}

