/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;

public abstract class AlignmentStrategy {
    private final Alignment myAlignment;

    public static AlignmentStrategy createDoNotAlingCommaStrategy(Alignment alignment) {
        return new AlignmentStrategy(alignment){

            @Override
            protected boolean shouldAlign(IElementType type) {
                return type != ElementType.COMMA || type == null;
            }
        };
    }

    protected AlignmentStrategy(Alignment alignment) {
        this.myAlignment = alignment;
    }

    public Alignment getAlignment(IElementType elementType) {
        if (this.shouldAlign(elementType)) {
            return this.myAlignment;
        }
        return null;
    }

    protected abstract boolean shouldAlign(IElementType var1);
}

