/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.FormatterUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlock
implements ASTBlock {
    public static final List<Block> EMPTY = Collections.unmodifiableList(new ArrayList(0));
    protected final ASTNode myNode;
    private List<Block> mySubBlocks;
    protected final Wrap myWrap;
    protected final Alignment myAlignment;

    protected AbstractBlock(ASTNode node, Wrap wrap, Alignment alignment) {
        this.myNode = node;
        this.myWrap = wrap;
        this.myAlignment = alignment;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/common/AbstractBlock.getTextRange must not return null");
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            List<Block> list = this.buildChildren();
            this.mySubBlocks = list.size() > 0 ? list : EMPTY;
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/common/AbstractBlock.getSubBlocks must not return null");
        }
        return list;
    }

    protected abstract List<Block> buildChildren();

    public final Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return null;
    }

    public final Alignment getAlignment() {
        return this.myAlignment;
    }

    public final ASTNode getNode() {
        return this.myNode;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(this.getChildIndent(), this.getFirstChildAlignment());
        if (childAttributes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/common/AbstractBlock.getChildAttributes must not return null");
        }
        return childAttributes;
    }

    private Alignment getFirstChildAlignment() {
        List<Block> subBlocks = this.getSubBlocks();
        for (Block subBlock : subBlocks) {
            Alignment alignment = subBlock.getAlignment();
            if (alignment == null) continue;
            return alignment;
        }
        return null;
    }

    @Nullable
    protected Indent getChildIndent() {
        return null;
    }

    public boolean isIncomplete() {
        return FormatterUtil.isIncompleted(this.getNode());
    }

    public String toString() {
        if (this.myNode == null) {
            return super.toString();
        }
        return this.myNode.getText() + " " + this.getTextRange();
    }
}

