/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtilHelper;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FormatterUtil {
    private static final List<FormatterUtilHelper> ourHelpers = ContainerUtil.createEmptyCOWList();

    private FormatterUtil() {
    }

    public static void addHelper(FormatterUtilHelper helper) {
        ourHelpers.add(helper);
    }

    private static ASTNode getWsCandidate(ASTNode element) {
        if (element == null) {
            return null;
        }
        ASTNode treePrev = element.getTreePrev();
        if (treePrev != null) {
            if (FormatterUtil.isSpaceTextElement(treePrev)) {
                return treePrev;
            }
            if (treePrev.getTextLength() == 0) {
                return FormatterUtil.getWsCandidate(treePrev);
            }
            return element;
        }
        ASTNode treeParent = element.getTreeParent();
        if (treeParent == null || treeParent.getTreeParent() == null) {
            return element;
        }
        return FormatterUtil.getWsCandidate(treeParent);
    }

    @Nullable
    private static ASTNode getLastChildOf(ASTNode element) {
        return TreeUtil.getLastChild(element);
    }

    private static boolean isWhiteSpaceElement(ASTNode treePrev) {
        return treePrev.getElementType() == TokenType.WHITE_SPACE;
    }

    private static boolean isSpaceTextElement(ASTNode treePrev) {
        return FormatterUtil.isWhiteSpaceElement(treePrev);
    }

    public static void replaceWhiteSpace(String whiteSpace, ASTNode leafElement, IElementType whiteSpaceToken, @Nullable TextRange textRange) {
        CharTable charTable = SharedImplUtil.findCharTableByTree(leafElement);
        if (textRange != null && textRange.getStartOffset() > leafElement.getTextRange().getStartOffset() && textRange.getEndOffset() < leafElement.getTextRange().getEndOffset()) {
            StringBuilder newText = FormatterUtil.createNewLeafChars(leafElement, textRange, whiteSpace);
            LeafElement newElement = Factory.createSingleLeafElement(leafElement.getElementType(), newText, charTable, leafElement.getPsi().getManager());
            leafElement.getTreeParent().replaceChild(leafElement, (ASTNode)newElement);
            return;
        }
        ASTNode treePrev = FormatterUtil.findPreviousWhiteSpace(leafElement);
        if (treePrev == null) {
            treePrev = FormatterUtil.getWsCandidate(leafElement);
        }
        if (treePrev != null && treePrev.getText().trim().length() == 0 && treePrev.getElementType() != whiteSpaceToken && treePrev.getTextLength() > 0 && whiteSpace.length() > 0) {
            LeafElement whiteSpaceElement = Factory.createSingleLeafElement(treePrev.getElementType(), whiteSpace, charTable, SharedImplUtil.getManagerByTree(leafElement));
            ASTNode treeParent = treePrev.getTreeParent();
            treeParent.replaceChild(treePrev, (ASTNode)whiteSpaceElement);
        } else {
            LeafElement whiteSpaceElement = Factory.createSingleLeafElement(whiteSpaceToken, whiteSpace, charTable, SharedImplUtil.getManagerByTree(leafElement));
            if (treePrev == null) {
                if (whiteSpace.length() > 0) {
                    FormatterUtil.addWhiteSpace(leafElement, whiteSpaceElement);
                }
            } else if (!FormatterUtil.isSpaceTextElement(treePrev)) {
                if (whiteSpace.length() > 0) {
                    FormatterUtil.addWhiteSpace(treePrev, whiteSpaceElement);
                }
            } else if (FormatterUtil.isWhiteSpaceElement(treePrev)) {
                CompositeElement treeParent = (CompositeElement)treePrev.getTreeParent();
                if (whiteSpace.length() > 0) {
                    treeParent.replaceChild(treePrev, whiteSpaceElement);
                } else {
                    treeParent.removeChild(treePrev);
                }
            }
        }
    }

    private static StringBuilder createNewLeafChars(ASTNode leafElement, TextRange textRange, String whiteSpace) {
        TextRange elementRange = leafElement.getTextRange();
        String elementText = leafElement.getText();
        StringBuilder result = new StringBuilder();
        if (elementRange.getStartOffset() < textRange.getStartOffset()) {
            result.append(elementText.substring(0, textRange.getStartOffset() - elementRange.getStartOffset()));
        }
        result.append(whiteSpace);
        if (elementRange.getEndOffset() > textRange.getEndOffset()) {
            result.append(elementText.substring(textRange.getEndOffset() - elementRange.getStartOffset()));
        }
        return result;
    }

    private static void addWhiteSpace(ASTNode treePrev, LeafElement whiteSpaceElement) {
        for (FormatterUtilHelper helper : ourHelpers) {
            if (!helper.addWhitespace(treePrev, whiteSpaceElement)) continue;
            return;
        }
        ASTNode treeParent = treePrev.getTreeParent();
        treeParent.addChild((ASTNode)whiteSpaceElement, treePrev);
    }

    @Nullable
    private static ASTNode findPreviousWhiteSpace(ASTNode leafElement) {
        int offset = leafElement.getTextRange().getStartOffset() - 1;
        if (offset < 0) {
            return null;
        }
        PsiElement found = SourceTreeToPsiMap.treeElementToPsi(leafElement).getContainingFile().findElementAt(offset);
        if (found == null) {
            return null;
        }
        ASTNode treeElement = found.getNode();
        if (treeElement.getElementType() == TokenType.WHITE_SPACE) {
            return treeElement;
        }
        return null;
    }

    @Nullable
    public static ASTNode getLeafNonSpaceBefore(ASTNode element) {
        if (element == null) {
            return null;
        }
        ASTNode treePrev = element.getTreePrev();
        if (treePrev != null) {
            ASTNode candidate = FormatterUtil.getLastChildOf(treePrev);
            if (candidate != null && !FormatterUtil.isSpaceTextElement(candidate) && candidate.getTextLength() > 0) {
                return candidate;
            }
            return FormatterUtil.getLeafNonSpaceBefore(candidate);
        }
        ASTNode treeParent = element.getTreeParent();
        if (treeParent == null || treeParent.getTreeParent() == null) {
            return null;
        }
        return FormatterUtil.getLeafNonSpaceBefore(treeParent);
    }

    public static boolean isIncompleted(ASTNode treeNode) {
        ASTNode lastChild;
        for (lastChild = treeNode.getLastChildNode(); lastChild != null && lastChild.getElementType() == TokenType.WHITE_SPACE; lastChild = lastChild.getTreePrev()) {
        }
        if (lastChild == null) {
            return false;
        }
        if (lastChild.getElementType() == TokenType.ERROR_ELEMENT) {
            return true;
        }
        return FormatterUtil.isIncompleted(lastChild);
    }

    public static void replaceLastWhiteSpace(ASTNode astNode, String whiteSpace, TextRange textRange) {
        LeafElement lastWS = TreeUtil.findLastLeaf(astNode);
        if (lastWS.getElementType() != TokenType.WHITE_SPACE) {
            lastWS = null;
        }
        if (lastWS != null && !lastWS.getTextRange().equals((Object)textRange)) {
            return;
        }
        if (whiteSpace.length() == 0 && lastWS == null) {
            return;
        }
        if (lastWS != null && whiteSpace.length() == 0) {
            lastWS.getTreeParent().removeRange(lastWS, null);
            return;
        }
        LeafElement whiteSpaceElement = ASTFactory.whitespace(whiteSpace);
        if (lastWS == null) {
            astNode.addChild((ASTNode)whiteSpaceElement, null);
        } else {
            CompositeElement treeParent = lastWS.getTreeParent();
            treeParent.replaceChild(lastWS, whiteSpaceElement);
        }
    }

    public static boolean containsWhiteSpacesOnly(ASTNode node) {
        if (node.getElementType() == TokenType.WHITE_SPACE || node.getTextLength() == 0) {
            return true;
        }
        for (FormatterUtilHelper helper : ourHelpers) {
            if (!helper.containsWhitespacesOnly(node)) continue;
            return true;
        }
        if (node instanceof LeafElement) {
            return false;
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(child)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrecededBy(ASTNode node, IElementType eType) {
        ASTNode prevNode;
        for (prevNode = node.getTreePrev(); prevNode != null && prevNode.getPsi() instanceof PsiWhiteSpace; prevNode = prevNode.getTreePrev()) {
        }
        if (prevNode == null) {
            return false;
        }
        return prevNode.getElementType() == eType;
    }

    public static boolean isPrecededBy(ASTNode node, TokenSet tokens) {
        ASTNode prevNode;
        for (prevNode = node.getTreePrev(); prevNode != null && prevNode.getPsi() instanceof PsiWhiteSpace; prevNode = prevNode.getTreePrev()) {
        }
        if (prevNode == null) {
            return false;
        }
        return tokens.contains(prevNode.getElementType());
    }
}

