/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class PsiMethodCallFilter
implements ElementFilter {
    @NonNls
    private final String myClassName;
    @NonNls
    private final Set<String> myMethodNames;

    public PsiMethodCallFilter(@NonNls String className, String ... methodNames) {
        this.myClassName = className;
        this.myMethodNames = new HashSet<String>(Arrays.asList(methodNames));
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        PsiMethodCallExpression callExpression;
        PsiMethod psiMethod;
        if (element instanceof PsiMethodCallExpression && (psiMethod = (callExpression = (PsiMethodCallExpression)element).resolveMethod()) != null) {
            if (!this.myMethodNames.contains(psiMethod.getName())) {
                return false;
            }
            PsiClass psiClass = psiMethod.getContainingClass();
            PsiClass expectedClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(this.myClassName, psiClass.getResolveScope());
            return InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)expectedClass, (boolean)true);
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return PsiMethodCallExpression.class.isAssignableFrom(hintClass);
    }

    @NonNls
    public String toString() {
        return "methodcall(" + this.myClassName + "." + this.myMethodNames + ")";
    }
}

