/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.Icons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LibraryElementType
extends ComplexPackagingElementType<LibraryPackagingElement> {
    public static final LibraryElementType LIBRARY_ELEMENT_TYPE = new LibraryElementType();

    LibraryElementType() {
        super("library", CompilerBundle.message((String)"element.type.name.library.files", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return Icons.LIBRARY_ICON;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/LibraryElementType.canCreate must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/LibraryElementType.canCreate must not be null");
        }
        return !LibraryElementType.getAllLibraries(context).isEmpty();
    }

    @NotNull
    public List<? extends LibraryPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/LibraryElementType.chooseAndCreate must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/LibraryElementType.chooseAndCreate must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/LibraryElementType.chooseAndCreate must not be null");
        }
        List selected = context.chooseLibraries(LibraryElementType.getAllLibraries(context), ProjectBundle.message((String)"dialog.title.packaging.choose.library", (Object[])new Object[0]));
        ArrayList<LibraryPackagingElement> elements = new ArrayList<LibraryPackagingElement>();
        for (Library library : selected) {
            elements.add(new LibraryPackagingElement(library.getTable().getTableLevel(), library.getName(), null));
        }
        ArrayList<LibraryPackagingElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/LibraryElementType.chooseAndCreate must not return null");
        }
        return arrayList;
    }

    private static List<Library> getAllLibraries(ArtifactEditorContext context) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        libraries.addAll(Arrays.asList(LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraries()));
        libraries.addAll(Arrays.asList(LibraryTablesRegistrar.getInstance().getLibraryTable(context.getProject()).getLibraries()));
        return libraries;
    }

    @NotNull
    public LibraryPackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/LibraryElementType.createEmpty must not be null");
        }
        LibraryPackagingElement libraryPackagingElement = new LibraryPackagingElement();
        if (libraryPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/LibraryElementType.createEmpty must not return null");
        }
        return libraryPackagingElement;
    }

    public String getShowContentActionText() {
        return "Show Library Files";
    }
}

