/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.RenameablePackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.FileCopyPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileCopyPackagingElement
extends FileOrDirectoryCopyPackagingElement<FileCopyPackagingElement>
implements RenameablePackagingElement {
    @NonNls
    public static final String OUTPUT_FILE_NAME_ATTRIBUTE = "output-file-name";
    private String myRenamedOutputFileName;

    public FileCopyPackagingElement() {
        super(PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE);
    }

    public FileCopyPackagingElement(String filePath) {
        this();
        this.myFilePath = filePath;
    }

    public FileCopyPackagingElement(String filePath, String outputFileName) {
        this(filePath);
        this.myRenamedOutputFileName = outputFileName;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.createPresentation must not be null");
        }
        return new FileCopyPresentation(this.myFilePath, this.getOutputFileName(), context);
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.computeAntInstructions must not be null");
        }
        if (creator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.computeAntInstructions must not be null");
        }
        if (generationContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.computeAntInstructions must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.computeAntInstructions must not be null");
        }
        if (this.isDirectory()) {
            return Collections.emptyList();
        }
        String path = generationContext.getSubstitutedPath(this.myFilePath);
        return Collections.singletonList(creator.createFileCopyInstruction(path, this.getOutputFileName()));
    }

    public String getOutputFileName() {
        return this.myRenamedOutputFileName != null ? this.myRenamedOutputFileName : PathUtil.getFileName((String)this.myFilePath);
    }

    public void computeIncrementalCompilerInstructions(@NotNull IncrementalCompilerInstructionCreator creator, @NotNull PackagingElementResolvingContext resolvingContext, @NotNull ArtifactIncrementalCompilerContext compilerContext, @NotNull ArtifactType artifactType) {
        if (creator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        if (compilerContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.computeIncrementalCompilerInstructions must not be null");
        }
        VirtualFile file = this.findFile();
        if (file != null && file.isValid() && !file.isDirectory()) {
            creator.addFileCopyInstruction(file, this.getOutputFileName());
        }
    }

    @NonNls
    public String toString() {
        return "file:" + this.myFilePath + (this.myRenamedOutputFileName != null ? ",rename to:" + this.myRenamedOutputFileName : "");
    }

    public boolean isDirectory() {
        return new File(FileUtil.toSystemDependentName((String)this.myFilePath)).isDirectory();
    }

    @Override
    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.isEqualTo must not be null");
        }
        return element instanceof FileCopyPackagingElement && super.isEqualTo(element) && Comparing.equal((String)this.myRenamedOutputFileName, (String)((FileCopyPackagingElement)element).getRenamedOutputFileName());
    }

    public FileCopyPackagingElement getState() {
        return this;
    }

    public void loadState(FileCopyPackagingElement state) {
        this.setFilePath(state.getFilePath());
        this.setRenamedOutputFileName(state.getRenamedOutputFileName());
    }

    @Attribute(value="output-file-name")
    @Nullable
    public String getRenamedOutputFileName() {
        return this.myRenamedOutputFileName;
    }

    public void setRenamedOutputFileName(String renamedOutputFileName) {
        this.myRenamedOutputFileName = renamedOutputFileName;
    }

    public String getName() {
        return this.getOutputFileName();
    }

    public boolean canBeRenamed() {
        return !this.isDirectory();
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/FileCopyPackagingElement.rename must not be null");
        }
        this.myRenamedOutputFileName = newName.equals(PathUtil.getFileName((String)this.myFilePath)) ? null : newName;
    }

    @Nullable
    public VirtualFile getLibraryRoot() {
        String url = VfsUtil.getUrlForLibraryRoot((File)new File(FileUtil.toSystemDependentName((String)this.getFilePath())));
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }
}

