/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.ExplodedDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarInfo;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.impl.compiler.ArtifactPackagingProcessingItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsProcessingItemsBuilderContext
implements ArtifactIncrementalCompilerContext {
    private boolean myCollectingEnabledItems;
    protected final Map<VirtualFile, ArtifactPackagingProcessingItem> myItemsBySource;
    private final Map<String, VirtualFile> mySourceByOutput;
    private final Map<String, JarInfo> myJarByPath;
    private final CompileContext myCompileContext;

    public ArtifactsProcessingItemsBuilderContext(CompileContext compileContext) {
        this.myCompileContext = compileContext;
        this.myItemsBySource = new HashMap<VirtualFile, ArtifactPackagingProcessingItem>();
        this.mySourceByOutput = new HashMap<String, VirtualFile>();
        this.myJarByPath = new HashMap<String, JarInfo>();
    }

    public boolean addDestination(@NotNull VirtualFile sourceFile, @NotNull DestinationInfo destinationInfo) {
        if (sourceFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactsProcessingItemsBuilderContext.addDestination must not be null");
        }
        if (destinationInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactsProcessingItemsBuilderContext.addDestination must not be null");
        }
        if (destinationInfo instanceof ExplodedDestinationInfo && sourceFile.equals(destinationInfo.getOutputFile())) {
            return false;
        }
        if (this.checkOutputPath(destinationInfo.getOutputPath(), sourceFile)) {
            this.getOrCreateProcessingItem(sourceFile).addDestination(destinationInfo, this.myCollectingEnabledItems);
            return true;
        }
        return false;
    }

    public ArtifactPackagingProcessingItem[] getProcessingItems() {
        Collection<ArtifactPackagingProcessingItem> processingItems = this.myItemsBySource.values();
        return processingItems.toArray(new ArtifactPackagingProcessingItem[processingItems.size()]);
    }

    public void setCollectingEnabledItems(boolean collectingEnabledItems) {
        this.myCollectingEnabledItems = collectingEnabledItems;
    }

    public boolean checkOutputPath(String outputPath, VirtualFile sourceFile) {
        VirtualFile old = this.mySourceByOutput.get(outputPath);
        if (old == null) {
            this.mySourceByOutput.put(outputPath, sourceFile);
            return true;
        }
        return false;
    }

    public ArtifactPackagingProcessingItem getItemBySource(VirtualFile source) {
        return this.myItemsBySource.get(source);
    }

    public boolean registerJarFile(@NotNull JarInfo jarInfo, @NotNull String outputPath) {
        if (jarInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactsProcessingItemsBuilderContext.registerJarFile must not be null");
        }
        if (outputPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactsProcessingItemsBuilderContext.registerJarFile must not be null");
        }
        if (this.myJarByPath.containsKey(outputPath)) {
            return false;
        }
        this.myJarByPath.put(outputPath, jarInfo);
        return true;
    }

    @Nullable
    public JarInfo getJarInfo(String outputPath) {
        return this.myJarByPath.get(outputPath);
    }

    @Nullable
    public VirtualFile getSourceByOutput(String outputPath) {
        return this.mySourceByOutput.get(outputPath);
    }

    public CompileContext getCompileContext() {
        return this.myCompileContext;
    }

    public ArtifactPackagingProcessingItem getOrCreateProcessingItem(VirtualFile sourceFile) {
        ArtifactPackagingProcessingItem item = this.myItemsBySource.get(sourceFile);
        if (item == null) {
            item = new ArtifactPackagingProcessingItem(sourceFile);
            this.myItemsBySource.put(sourceFile, item);
        }
        return item;
    }
}

