/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.compiler.ArtifactPackagingItemValidityState;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactPackagingProcessingItem
implements FileProcessingCompiler.ProcessingItem {
    private final VirtualFile mySourceFile;
    private final SmartList<Pair<DestinationInfo, Boolean>> myDestinations = new SmartList();
    private List<DestinationInfo> myEnabledDestinations;
    private boolean mySourceFileModified;
    private ArtifactPackagingItemValidityState myOldState;

    public ArtifactPackagingProcessingItem(VirtualFile sourceFile) {
        this.mySourceFile = sourceFile;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.mySourceFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/compiler/ArtifactPackagingProcessingItem.getFile must not return null");
        }
        return virtualFile;
    }

    public void addDestination(DestinationInfo info, boolean enabled) {
        int size = this.myDestinations.size();
        for (int i = 0; i < size; ++i) {
            Pair pair = (Pair)this.myDestinations.get(i);
            if (!info.getOutputPath().equals(((DestinationInfo)pair.getFirst()).getOutputPath())) continue;
            if (enabled && !((Boolean)pair.getSecond()).booleanValue()) {
                this.myDestinations.set(i, (Object)Pair.create((Object)info, (Object)true));
            }
            return;
        }
        this.myDestinations.add((Object)Pair.create((Object)info, (Object)enabled));
    }

    public List<Pair<DestinationInfo, Boolean>> getDestinations() {
        return this.myDestinations;
    }

    public void init(FileProcessingCompilerStateCache cache) throws IOException {
        String url = this.mySourceFile.getUrl();
        this.myOldState = (ArtifactPackagingItemValidityState)cache.getExtState(url);
        this.mySourceFileModified = cache.getTimestamp(url) != this.mySourceFile.getTimeStamp();
    }

    public void setProcessed() {
        for (DestinationInfo destination : this.myEnabledDestinations) {
            destination.update();
        }
    }

    public List<DestinationInfo> getEnabledDestinations() {
        if (this.myEnabledDestinations == null) {
            this.myEnabledDestinations = new ArrayList<DestinationInfo>();
            for (Pair destination : this.myDestinations) {
                if (!((Boolean)destination.getSecond()).booleanValue()) continue;
                this.myEnabledDestinations.add((DestinationInfo)destination.getFirst());
            }
        }
        return this.myEnabledDestinations;
    }

    @Nullable
    public ValidityState getValidityState() {
        return new ArtifactPackagingItemValidityState(this.getEnabledDestinations(), this.mySourceFileModified, this.myOldState);
    }
}

