/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ModuleOutputElementType;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactCompileScope {
    private static final Key<Artifact[]> ARTIFACTS_KEY = Key.create((String)"artifacts");
    private static final Key<Set<Artifact>> CACHED_ARTIFACTS_KEY = Key.create((String)"cached_artifacts");
    private static final Key<Key<?>> ARTIFACTS_CONTENT_ID_KEY = Key.create((String)"build_artifacts_task");

    private ArtifactCompileScope() {
    }

    public static ModuleCompileScope createScopeForModulesInArtifacts(@NotNull Project project, @NotNull Collection<? extends Artifact> artifacts) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactCompileScope.createScopeForModulesInArtifacts must not be null");
        }
        if (artifacts == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactCompileScope.createScopeForModulesInArtifacts must not be null");
        }
        final HashSet modules = new HashSet();
        final PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        for (Artifact artifact : artifacts) {
            ArtifactUtil.processPackagingElements(artifact, ModuleOutputElementType.MODULE_OUTPUT_ELEMENT_TYPE, new Processor<ModuleOutputPackagingElement>(){

                public boolean process(ModuleOutputPackagingElement moduleOutputPackagingElement) {
                    Module module = moduleOutputPackagingElement.findModule(context);
                    if (module != null) {
                        modules.add(module);
                    }
                    return true;
                }
            }, context, true);
        }
        return new ModuleCompileScope(project, modules.toArray(new Module[modules.size()]), true);
    }

    public static CompileScope createArtifactsScope(@NotNull Project project, @NotNull Collection<Artifact> artifacts) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactCompileScope.createArtifactsScope must not be null");
        }
        if (artifacts == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactCompileScope.createArtifactsScope must not be null");
        }
        return ArtifactCompileScope.createScopeWithArtifacts(ArtifactCompileScope.createScopeForModulesInArtifacts(project, artifacts), artifacts);
    }

    public static CompileScope createScopeWithArtifacts(CompileScope baseScope, @NotNull Collection<Artifact> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactCompileScope.createScopeWithArtifacts must not be null");
        }
        baseScope.putUserData(ARTIFACTS_KEY, (Object)artifacts.toArray(new Artifact[artifacts.size()]));
        baseScope.putUserData(CompilerManager.CONTENT_ID_KEY, ARTIFACTS_CONTENT_ID_KEY);
        return baseScope;
    }

    public static Set<Artifact> getArtifactsToBuild(Project project, CompileScope compileScope) {
        Artifact[] artifactsFromScope = ArtifactCompileScope.getArtifacts(compileScope);
        if (artifactsFromScope != null) {
            return new HashSet<Artifact>(Arrays.asList(artifactsFromScope));
        }
        Set cached = (Set)compileScope.getUserData(CACHED_ARTIFACTS_KEY);
        if (cached != null) {
            return cached;
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
        HashSet<Module> modules = new HashSet<Module>(Arrays.asList(compileScope.getAffectedModules()));
        List<Module> allModules = Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        for (Artifact artifact : artifactManager.getArtifacts()) {
            if (!artifact.isBuildOnMake() || !modules.containsAll(allModules) && !ArtifactCompileScope.containsModuleOutput(artifact, modules, artifactManager)) continue;
            artifacts.add(artifact);
        }
        compileScope.putUserData(CACHED_ARTIFACTS_KEY, artifacts);
        return artifacts;
    }

    @Nullable
    public static Artifact[] getArtifacts(CompileScope compileScope) {
        return (Artifact[])compileScope.getUserData(ARTIFACTS_KEY);
    }

    private static boolean containsModuleOutput(Artifact artifact, final Set<Module> modules, ArtifactManager artifactManager) {
        final PackagingElementResolvingContext context = artifactManager.getResolvingContext();
        return !ArtifactUtil.processPackagingElements(artifact, ModuleOutputElementType.MODULE_OUTPUT_ELEMENT_TYPE, new Processor<ModuleOutputPackagingElement>(){

            public boolean process(ModuleOutputPackagingElement moduleOutputPackagingElement) {
                Module module = moduleOutputPackagingElement.findModule(context);
                return module == null || !modules.contains(module);
            }
        }, context, true);
    }
}

