/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ArtifactModelBase
implements ArtifactModel {
    private Map<String, Artifact> myArtifactsMap;
    private Artifact[] myArtifactsArray;

    protected abstract List<? extends Artifact> getArtifactsList();

    @NotNull
    public Artifact[] getArtifacts() {
        if (this.myArtifactsArray == null) {
            List<? extends Artifact> artifacts = this.getArtifactsList();
            this.myArtifactsArray = artifacts.toArray(new Artifact[artifacts.size()]);
        }
        if (this.myArtifactsArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactModelBase.getArtifacts must not return null");
        }
        return this.myArtifactsArray;
    }

    public Artifact findArtifact(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactModelBase.findArtifact must not be null");
        }
        if (this.myArtifactsMap == null) {
            this.myArtifactsMap = new HashMap<String, Artifact>();
            for (Artifact artifact : this.getArtifactsList()) {
                this.myArtifactsMap.put(artifact.getName(), artifact);
            }
        }
        return this.myArtifactsMap.get(name);
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactModelBase.getArtifactByOriginal must not be null");
        }
        Artifact artifact2 = artifact;
        if (artifact2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactModelBase.getArtifactByOriginal must not return null");
        }
        return artifact2;
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactModelBase.getOriginalArtifact must not be null");
        }
        Artifact artifact2 = artifact;
        if (artifact2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactModelBase.getOriginalArtifact must not return null");
        }
        return artifact2;
    }

    public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactModelBase.getArtifactsByType must not be null");
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : this.getArtifacts()) {
            if (!artifact.getArtifactType().equals(type)) continue;
            result.add(artifact);
        }
        return result;
    }

    protected void artifactsChanged() {
        this.myArtifactsMap = null;
        this.myArtifactsArray = null;
    }
}

