/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ArtifactBySourceFileFinderImpl
extends ArtifactBySourceFileFinder {
    private CachedValue<MultiValuesMap<VirtualFile, Artifact>> myFile2Artifacts;
    private final Project myProject;

    public ArtifactBySourceFileFinderImpl(Project project) {
        this.myProject = project;
    }

    public CachedValue<MultiValuesMap<VirtualFile, Artifact>> getFileToArtifactsMap() {
        if (this.myFile2Artifacts == null) {
            this.myFile2Artifacts = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new CachedValueProvider<MultiValuesMap<VirtualFile, Artifact>>(){

                public CachedValueProvider.Result<MultiValuesMap<VirtualFile, Artifact>> compute() {
                    MultiValuesMap result = ArtifactBySourceFileFinderImpl.this.computeFileToArtifactsMap();
                    ArrayList<ModificationTracker> trackers = new ArrayList<ModificationTracker>();
                    trackers.add(ArtifactManager.getInstance((Project)ArtifactBySourceFileFinderImpl.this.myProject).getModificationTracker());
                    for (ComplexPackagingElementType type : PackagingElementFactory.getInstance().getComplexElementTypes()) {
                        ContainerUtil.addIfNotNull((Object)type.getAllSubstitutionsModificationTracker(ArtifactBySourceFileFinderImpl.this.myProject), trackers);
                    }
                    return CachedValueProvider.Result.create((Object)result, (Object[])trackers.toArray(new ModificationTracker[trackers.size()]));
                }
            }, false);
        }
        return this.myFile2Artifacts;
    }

    private MultiValuesMap<VirtualFile, Artifact> computeFileToArtifactsMap() {
        final MultiValuesMap result = new MultiValuesMap();
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        for (final Artifact artifact : artifactManager.getArtifacts()) {
            final PackagingElementResolvingContext context = artifactManager.getResolvingContext();
            ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(){

                @Override
                public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                    Module module;
                    if (element == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl$2.process must not be null");
                    }
                    if (path == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl$2.process must not be null");
                    }
                    if (element instanceof FileOrDirectoryCopyPackagingElement) {
                        VirtualFile root = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                        if (root != null) {
                            result.put((Object)root, (Object)artifact);
                        }
                    } else if (element instanceof ModuleOutputPackagingElement && (module = ((ModuleOutputPackagingElement)element).findModule(context)) != null) {
                        ModuleRootModel rootModel = context.getModulesProvider().getRootModel(module);
                        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                            for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                                VirtualFile sourceRoot = sourceFolder.getFile();
                                if (sourceRoot == null || sourceFolder.isTestSource()) continue;
                                result.put((Object)sourceRoot, (Object)artifact);
                            }
                        }
                    }
                    return true;
                }
            }, context, true);
        }
        return result;
    }

    @Override
    public Collection<? extends Artifact> findArtifacts(@NotNull VirtualFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl.findArtifacts must not be null");
        }
        MultiValuesMap map = (MultiValuesMap)this.getFileToArtifactsMap().getValue();
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result = null;
        for (VirtualFile file = sourceFile; file != null; file = file.getParent()) {
            Collection artifacts = map.get((Object)file);
            if (artifacts == null) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.addAll(artifacts);
        }
        return result != null ? result : Collections.emptyList();
    }
}

